/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.oidc.metadata.cache.impl;

import java.io.IOException;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import net.shibboleth.ext.spring.resource.PreferFileSystemResourceLoader;
import net.shibboleth.oidc.metadata.cache.MetadataCache;
import net.shibboleth.oidc.metadata.cache.impl.BatchMetadataCacheBuilderSpec;
import net.shibboleth.oidc.metadata.cache.impl.DefaultFileLoadingStrategy;
import net.shibboleth.oidc.metadata.cache.impl.MetadataCacheBuilder;
import net.shibboleth.oidc.metadata.policy.MetadataPolicy;
import net.shibboleth.oidc.metadata.policy.MetadataPolicyResolver;
import net.shibboleth.oidc.metadata.policy.impl.OIDCMetadataPolicyResolver;
import net.shibboleth.oidc.profile.config.navigate.ResolverBasedRegistrationMetadataPolicyLookupFunction;
import net.shibboleth.utilities.java.support.annotation.ParameterName;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import org.opensaml.profile.context.ProfileRequestContext;
import org.springframework.core.io.Resource;

@ThreadSafe
public class MetadataPolicyLookupStrategyFactory {
    public Function<ProfileRequestContext, Map<String, MetadataPolicy>> buildFileLoadingMetadataPolicyResolver(@ParameterName(name="resource") @Nullable String resource, @ParameterName(name="cacheSpec") @Nonnull BatchMetadataCacheBuilderSpec<String, Map<String, MetadataPolicy>> cacheSpec, @ParameterName(name="criteriaSetLookupStrategy") @Nullable Function<ProfileRequestContext, CriteriaSet> criteriaSetLookupStrategy, @ParameterName(name="id") @Nonnull String id) throws ComponentInitializationException, IOException {
        MetadataCacheBuilder.Builder<String, Map<String, MetadataPolicy>> builder = new MetadataCacheBuilder.Builder<String, Map<String, MetadataPolicy>>();
        Resource fileResource = null;
        if (resource != null && !resource.isEmpty()) {
            PreferFileSystemResourceLoader resourceLoader = new PreferFileSystemResourceLoader();
            fileResource = resourceLoader.getResource(resource);
        }
        DefaultFileLoadingStrategy fileStrategy = new DefaultFileLoadingStrategy(fileResource);
        cacheSpec.setLoadingStrategy(fileStrategy);
        cacheSpec.setCacheId(id + "-cache");
        MetadataCache<Map<String, MetadataPolicy>> cache = builder.build(cacheSpec);
        OIDCMetadataPolicyResolver resolver = new OIDCMetadataPolicyResolver(cache);
        resolver.setId(id + "-resolver");
        resolver.initialize();
        ResolverBasedRegistrationMetadataPolicyLookupFunction function = new ResolverBasedRegistrationMetadataPolicyLookupFunction();
        function.setMetadataPolicyResolver((MetadataPolicyResolver)resolver);
        function.setCriteriaSetLookupStrategy(criteriaSetLookupStrategy);
        return function;
    }
}

