/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.oidc.metadata.cache.impl;

import javax.annotation.Nonnull;
import net.shibboleth.oidc.metadata.cache.MetadataCache;
import net.shibboleth.oidc.metadata.cache.impl.BatchMetadataCache;
import net.shibboleth.oidc.metadata.cache.impl.BatchMetadataCacheBuilderSpec;
import net.shibboleth.oidc.metadata.cache.impl.DynamicMetadataCache;
import net.shibboleth.oidc.metadata.cache.impl.DynamicMetadataCacheBuilderSpec;
import net.shibboleth.oidc.metadata.cache.impl.FetchThroughMetadataCache;
import net.shibboleth.oidc.metadata.cache.impl.FetchThroughMetadataCacheBuilderSpec;
import net.shibboleth.oidc.metadata.cache.impl.MetadataCacheBuilderSpec;
import net.shibboleth.oidc.metadata.impl.DefaultBatchBackingStore;
import net.shibboleth.oidc.metadata.impl.DefaultDynamicBackingStore;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MetadataCacheBuilder {
    private MetadataCacheBuilder() {
    }

    public static class Builder<IdentifierType, MetadataType> {
        @Nonnull
        private final Logger log = LoggerFactory.getLogger(MetadataCacheBuilder.class);

        public MetadataCache<MetadataType> build(@Nonnull MetadataCacheBuilderSpec<IdentifierType, MetadataType> specification) throws ComponentInitializationException {
            if (specification instanceof BatchMetadataCacheBuilderSpec) {
                BatchMetadataCacheBuilderSpec spec = (BatchMetadataCacheBuilderSpec)specification;
                BatchMetadataCache cache = new BatchMetadataCache(new DefaultBatchBackingStore());
                cache.setSourceMetadataExpiryStrategy(spec.getSourceMetadataExpiryStrategy());
                cache.setLoadingStrategy(spec.getLoadingStrategy());
                cache.setParsingStrategy(spec.getParsingStrategy());
                cache.setMinRefreshDelay(spec.getMinRefreshDelay());
                cache.setMaxRefreshDelay(spec.getMaxRefreshDelay());
                cache.setRefreshDelayFactor(spec.getRefreshDelayFactor());
                cache.setIdentifierExtractionStrategy(spec.getIdentifierExtractionStrategy());
                cache.setCriteriaToIdentifierStrategy(spec.getCriteriaToIdentifierStrategy());
                cache.setMetadataFilterStrategy(spec.getMetadataFilterStrategy());
                cache.setMetadataBeforeRemovalHook(spec.getMetadataBeforeRemovalHook());
                cache.setMatchOnIdentifierRequired(spec.isMatchOnIdentifierRequired());
                cache.setMetadataValidPredicate(spec.getMetadataValidPredicate());
                cache.setSourceMetadataValidPredicate(spec.getSourceMetadataValidPredicate());
                cache.setId(spec.getCacheId());
                cache.initialize();
                return cache;
            }
            if (specification instanceof DynamicMetadataCacheBuilderSpec) {
                DynamicMetadataCacheBuilderSpec spec = (DynamicMetadataCacheBuilderSpec)specification;
                DynamicMetadataCache cache = new DynamicMetadataCache(new DefaultDynamicBackingStore());
                cache.setFetchStrategy(spec.getFetchStrategy());
                cache.setMinCacheDuration(spec.getMinCacheDuration());
                cache.setMaxCacheDuration(spec.getMaxCacheDuration());
                cache.setRefreshDelayFactor(spec.getRefreshDelayFactor());
                cache.setMaxIdleEntityData(spec.getMaxIdleEntityData());
                cache.setMetadataExpirationTimeStrategy(spec.getMetadataExpirationTimeStrategy());
                cache.setIdentifierExtractionStrategy(spec.getIdentifierExtractionStrategy());
                cache.setCriteriaToIdentifierStrategy(spec.getCriteriaToIdentifierStrategy());
                cache.setCleanupTaskInterval(spec.getCleanupTaskInterval());
                cache.setRemoveIdleEntityData(spec.isRemoveIdleEntityData());
                cache.setInitialCleanupTaskDelay(spec.getInitialCleanupTaskDelay());
                cache.setMetadataFilterStrategy(spec.getMetadataFilterStrategy());
                cache.setMetadataBeforeRemovalHook(spec.getMetadataBeforeRemovalHook());
                cache.setMetadataValidPredicate(spec.getMetadataValidPredicate());
                cache.setId(spec.getCacheId());
                cache.initialize();
                return cache;
            }
            if (specification instanceof FetchThroughMetadataCacheBuilderSpec) {
                FetchThroughMetadataCacheBuilderSpec spec = (FetchThroughMetadataCacheBuilderSpec)specification;
                FetchThroughMetadataCache cache = new FetchThroughMetadataCache();
                cache.setFetchStrategy(spec.getFetchStrategy());
                cache.setRefreshDelayFactor(spec.getRefreshDelayFactor());
                cache.setIdentifierExtractionStrategy(spec.getIdentifierExtractionStrategy());
                cache.setCriteriaToIdentifierStrategy(spec.getCriteriaToIdentifierStrategy());
                cache.setMetadataFilterStrategy(spec.getMetadataFilterStrategy());
                cache.setMetadataBeforeRemovalHook(spec.getMetadataBeforeRemovalHook());
                cache.setMetadataValidPredicate(spec.getMetadataValidPredicate());
                cache.setId(spec.getCacheId());
                cache.initialize();
                return cache;
            }
            this.log.error("Unable to construct metadata cache, unknown specification type '{}'", (Object)specification.getClass().getSimpleName());
            throw new ComponentInitializationException("Cache Specification type not recognized");
        }
    }
}

