/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.oidc.metadata.cache.impl;

import java.time.Duration;
import java.time.Instant;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.oidc.metadata.cache.ExpirationTimeContext;
import net.shibboleth.oidc.metadata.cache.impl.BaseMetadataCacheBuilderSpec;
import net.shibboleth.oidc.metadata.cache.impl.MetadataCacheBuilderSpec;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;

public class DynamicMetadataCacheBuilderSpec<IdentifierType, MetadataType>
extends BaseMetadataCacheBuilderSpec<IdentifierType, MetadataType>
implements MetadataCacheBuilderSpec<IdentifierType, MetadataType> {
    @Nullable
    private Function<CriteriaSet, MetadataType> fetchStrategy;
    @Nonnull
    private Duration maxCacheDuration = Duration.ofHours(8L);
    @Nonnull
    private Duration minCacheDuration = Duration.ofMinutes(10L);
    @Nullable
    private Duration maxIdleEntityData = Duration.ofHours(8L);
    @Nonnull
    private Duration cleanupTaskInterval = Duration.ofMinutes(30L);
    private boolean removeIdleEntityData = true;
    @Nonnull
    private Duration initialCleanupTaskDelay = Duration.ofMinutes(1L);
    @Nullable
    private Function<ExpirationTimeContext<MetadataType>, Instant> metadataExpirationTimeStrategy;

    protected DynamicMetadataCacheBuilderSpec() {
    }

    @Nonnull
    protected Duration getMaxCacheDuration() {
        return this.maxCacheDuration;
    }

    public void setMaxCacheDuration(@Nonnull Duration duration) {
        Constraint.isNotNull((Object)duration, (String)"Duration cannot be null");
        Constraint.isFalse((boolean)duration.isNegative(), (String)"Duration cannot be negative");
        this.maxCacheDuration = duration;
    }

    @Nonnull
    protected Duration getMinCacheDuration() {
        return this.minCacheDuration;
    }

    public void setMinCacheDuration(@Nonnull Duration duration) {
        Constraint.isNotNull((Object)duration, (String)"Duration cannot be null");
        Constraint.isFalse((boolean)duration.isNegative(), (String)"Duration cannot be negative");
        this.minCacheDuration = duration;
    }

    public void setRemoveIdleEntityData(boolean flag) {
        this.removeIdleEntityData = flag;
    }

    protected boolean isRemoveIdleEntityData() {
        return this.removeIdleEntityData;
    }

    public void setMetadataExpirationTimeStrategy(@Nonnull Function<ExpirationTimeContext<MetadataType>, Instant> strategy) {
        this.metadataExpirationTimeStrategy = (Function)Constraint.isNotNull(strategy, (String)"Strategy can not be null");
    }

    @Nullable
    protected Function<ExpirationTimeContext<MetadataType>, Instant> getMetadataExpirationTimeStrategy() {
        return this.metadataExpirationTimeStrategy;
    }

    @Nonnull
    protected Duration getCleanupTaskInterval() {
        return this.cleanupTaskInterval;
    }

    public void setCleanupTaskInterval(@Nonnull Duration interval) {
        Constraint.isNotNull((Object)interval, (String)"Cleanup task interval may not be null");
        Constraint.isFalse((interval.isNegative() || interval.isZero() ? 1 : 0) != 0, (String)"Cleanup task interval must be positive");
        this.cleanupTaskInterval = interval;
    }

    public void setFetchStrategy(@Nonnull Function<CriteriaSet, MetadataType> strategy) {
        this.fetchStrategy = (Function)Constraint.isNotNull(strategy, (String)"Metadata fetch strategy can not be null");
    }

    @Nullable
    protected Function<CriteriaSet, MetadataType> getFetchStrategy() {
        return this.fetchStrategy;
    }

    @Nonnull
    protected Duration getMaxIdleEntityData() {
        return this.maxIdleEntityData;
    }

    public void setMaxIdleEntityData(@Nonnull Duration max) {
        Constraint.isNotNull((Object)max, (String)"Max idle time cannot be null");
        Constraint.isFalse((boolean)max.isNegative(), (String)"Max idle time cannot be negative");
        this.maxIdleEntityData = max;
    }

    @Nonnull
    protected Duration getInitialCleanupTaskDelay() {
        return this.initialCleanupTaskDelay;
    }

    public void setInitialCleanupTaskDelay(@Nonnull Duration delay) {
        Constraint.isNotNull((Object)delay, (String)"Cleanup task delay can not be null");
        Constraint.isFalse((delay.isNegative() || delay.isZero() ? 1 : 0) != 0, (String)"Cleanup task delay must be positive");
        this.initialCleanupTaskDelay = delay;
    }
}

