/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.oidc.metadata.cache.impl;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.RatioGauge;
import com.codahale.metrics.Timer;
import java.time.Duration;
import java.time.Instant;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.StampedLock;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.oidc.metadata.DynamicBackingStore;
import net.shibboleth.oidc.metadata.MetadataManagementData;
import net.shibboleth.oidc.metadata.cache.ExpirationTimeContext;
import net.shibboleth.oidc.metadata.cache.MetadataCacheException;
import net.shibboleth.oidc.metadata.cache.impl.AbstractMetadataCache;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullAfterInit;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.DestructableComponent;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import org.opensaml.core.metrics.MetricsSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamicMetadataCache<IdentifierType, MetadataType>
extends AbstractMetadataCache<IdentifierType, MetadataType> {
    public static final String METRIC_TIMER_GET = "timer.get";
    public static final String METRIC_GAUGE_NUM_LIVE_INDEX_METADATA = "gauge.numLiveIndexedMetadata";
    public static final String METRIC_TIMER_FETCH_FROM_ORIGIN_SOURCE = "timer.fetchFromOriginSource";
    public static final String METRIC_RATIOGAUGE_FETCH_TO_GET = "ratioGauge.fetchToGet";
    private final Logger log = LoggerFactory.getLogger(DynamicMetadataCache.class);
    @NonnullAfterInit
    private Duration cleanupTaskInterval;
    @NonnullAfterInit
    private Duration initialCleanupTaskDelay;
    @NonnullAfterInit
    private Duration maxIdleEntityData;
    private boolean removeIdleEntityData;
    @NonnullAfterInit
    private Duration minCacheDuration;
    @NonnullAfterInit
    private Duration maxCacheDuration;
    @NonnullAfterInit
    private Function<CriteriaSet, MetadataType> fetchStrategy;
    @NonnullAfterInit
    private Function<ExpirationTimeContext<MetadataType>, Instant> metadataExpirationTimeStrategy;
    @Nonnull
    private final Function<IdentifierType, MetadataManagementData<IdentifierType>> mgmtMappingFunction = id -> {
        Instant now = Instant.now();
        MetadataManagementData mgmt = new MetadataManagementData(id);
        mgmt.setRefreshTriggerTime(now.plus(this.maxCacheDuration));
        mgmt.setExpirationTime(now.plus(this.maxCacheDuration));
        return mgmt;
    };
    @NonnullAfterInit
    private String metricsBaseName;
    @Nullable
    private Timer timerGet;
    @Nullable
    private Timer timerFetchFromSource;
    @Nullable
    private RatioGauge ratioGaugeFetchToGet;
    @Nullable
    private Gauge<Integer> gaugeNumLiveIndexedMetadata;

    protected DynamicMetadataCache(@Nonnull DynamicBackingStore<IdentifierType, MetadataType> store) {
        this(store, null);
    }

    protected DynamicMetadataCache(@Nonnull DynamicBackingStore<IdentifierType, MetadataType> store, @Nullable ScheduledExecutorService executor) {
        super(store, executor);
    }

    public void setMinCacheDuration(@Nonnull Duration duration) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        Constraint.isNotNull((Object)duration, (String)"Duration cannot be null");
        Constraint.isFalse((boolean)duration.isNegative(), (String)"Duration cannot be negative");
        this.minCacheDuration = duration;
    }

    public void setMaxCacheDuration(@Nonnull Duration duration) {
        Constraint.isNotNull((Object)duration, (String)"Duration cannot be null");
        Constraint.isFalse((boolean)duration.isNegative(), (String)"Duration cannot be negative");
        this.maxCacheDuration = duration;
    }

    public void setFetchStrategy(@Nonnull Function<CriteriaSet, MetadataType> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        this.fetchStrategy = (Function)Constraint.isNotNull(strategy, (String)"Dynamic Metadata fetch strategy can not be null");
    }

    public void setInitialCleanupTaskDelay(@Nonnull Duration delay) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        Constraint.isNotNull((Object)delay, (String)"Cleanup task delay can not be null");
        Constraint.isFalse((delay.isNegative() || delay.isZero() ? 1 : 0) != 0, (String)"Cleanup task delay must be positive");
        this.initialCleanupTaskDelay = delay;
    }

    @Override
    protected void doDestroy() {
        if (this.ratioGaugeFetchToGet != null) {
            MetricsSupport.remove((String)MetricRegistry.name((String)this.metricsBaseName, (String[])new String[]{METRIC_RATIOGAUGE_FETCH_TO_GET}), (Metric)this.ratioGaugeFetchToGet);
        }
        if (this.gaugeNumLiveIndexedMetadata != null) {
            MetricsSupport.remove((String)MetricRegistry.name((String)this.metricsBaseName, (String[])new String[]{METRIC_GAUGE_NUM_LIVE_INDEX_METADATA}), this.gaugeNumLiveIndexedMetadata);
        }
        this.ratioGaugeFetchToGet = null;
        this.gaugeNumLiveIndexedMetadata = null;
        this.timerFetchFromSource = null;
        this.timerGet = null;
        super.doDestroy();
    }

    public void setCleanupTaskInterval(@Nonnull Duration interval) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        Constraint.isNotNull((Object)interval, (String)"Cleanup task interval may not be null");
        Constraint.isFalse((interval.isNegative() || interval.isZero() ? 1 : 0) != 0, (String)"Cleanup task interval must be positive");
        this.cleanupTaskInterval = interval;
    }

    public void setRemoveIdleEntityData(boolean flag) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        this.removeIdleEntityData = flag;
    }

    public void setMaxIdleEntityData(@Nonnull Duration max) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        Constraint.isNotNull((Object)max, (String)"Max idle time cannot be null");
        Constraint.isFalse((boolean)max.isNegative(), (String)"Max idle time cannot be negative");
        this.maxIdleEntityData = max;
    }

    public void setMetadataExpirationTimeStrategy(@Nonnull Function<ExpirationTimeContext<MetadataType>, Instant> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        this.metadataExpirationTimeStrategy = (Function)Constraint.isNotNull(strategy, (String)"Metadata expiration strategy can not be null");
    }

    @NonnullAfterInit
    protected Function<ExpirationTimeContext<MetadataType>, Instant> getMetadataExpirationTimeStrategy() {
        return this.metadataExpirationTimeStrategy;
    }

    @Override
    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.maxCacheDuration == null || this.minCacheDuration == null || this.maxIdleEntityData == null || this.cleanupTaskInterval == null || this.initialCleanupTaskDelay == null) {
            throw new ComponentInitializationException("Dynamic metadata cache not property initialized");
        }
        if (this.metadataExpirationTimeStrategy == null) {
            throw new ComponentInitializationException("Metadata expiration strategy can not be null");
        }
        if (this.fetchStrategy == null) {
            throw new ComponentInitializationException("Metadata fetching strategy can not be null");
        }
        this.initializeMetricsInstrumentation();
        this.getExecutorService().scheduleAtFixedRate(this.errorHandlingWrapper(new ExpiredAndIdleMetadataCleanupTask()), this.initialCleanupTaskDelay.toMillis(), this.cleanupTaskInterval.toMillis(), TimeUnit.MILLISECONDS);
    }

    private void initializeMetricsInstrumentation() {
        MetricRegistry metricRegistry;
        if (this.metricsBaseName == null) {
            this.setMetricsBaseName(MetricRegistry.name(((Object)((Object)this)).getClass(), (String[])new String[]{this.getId()}));
        }
        if ((metricRegistry = MetricsSupport.getMetricRegistry()) != null) {
            this.timerGet = metricRegistry.timer(MetricRegistry.name((String)this.metricsBaseName, (String[])new String[]{METRIC_TIMER_GET}));
            this.timerFetchFromSource = metricRegistry.timer(MetricRegistry.name((String)this.metricsBaseName, (String[])new String[]{METRIC_TIMER_FETCH_FROM_ORIGIN_SOURCE}));
            this.ratioGaugeFetchToGet = (RatioGauge)MetricsSupport.register((String)MetricRegistry.name((String)this.metricsBaseName, (String[])new String[]{METRIC_RATIOGAUGE_FETCH_TO_GET}), (Metric)new RatioGauge(){

                protected RatioGauge.Ratio getRatio() {
                    return RatioGauge.Ratio.of((double)DynamicMetadataCache.this.timerFetchFromSource.getCount(), (double)DynamicMetadataCache.this.timerGet.getCount());
                }
            }, (boolean)true);
            this.gaugeNumLiveIndexedMetadata = (Gauge)MetricsSupport.register((String)MetricRegistry.name((String)this.metricsBaseName, (String[])new String[]{METRIC_GAUGE_NUM_LIVE_INDEX_METADATA}), (Metric)((Gauge)() -> this.getBackingStore().getIndexedValues().keySet().size()), (boolean)true);
        }
    }

    public synchronized void setMetricsBaseName(@Nullable String baseName) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        ComponentSupport.ifDestroyedThrowDestroyedComponentException((DestructableComponent)this);
        this.metricsBaseName = StringSupport.trimOrNull((String)baseName);
    }

    @Override
    @Nonnull
    protected DynamicBackingStore<IdentifierType, MetadataType> getBackingStore() {
        return (DynamicBackingStore)super.getBackingStore();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    @NonnullElements
    public List<MetadataType> get(@Nonnull @NotEmpty CriteriaSet criteria) throws MetadataCacheException {
        if (!this.isInitialized()) {
            throw new MetadataCacheException("Metadata cache has not been initialized");
        }
        Timer.Context contextResolve = MetricsSupport.startTimer((Timer)this.timerGet);
        try {
            Object identifier = this.getCriteriaToIdentifierStrategy().apply(criteria);
            this.log.debug("{} Resolved criteria to identifier: {}", (Object)this.getLogPrefix(), identifier);
            if (identifier != null) {
                MetadataManagementData mgmtData = this.getBackingStore().computeManagementDataIfAbsent(identifier, this.mgmtMappingFunction);
                List<Object> allMetadata = Collections.emptyList();
                if (!this.shouldAttemptRefresh(mgmtData)) {
                    allMetadata = this.read(mgmtData, identifier);
                }
                if (allMetadata.isEmpty()) {
                    this.log.debug("Metadata for '{}' does not exist, is no longer valid, or is stale, attempting to fetch it", identifier);
                    this.fetch(mgmtData, identifier, criteria);
                    List<MetadataType> list = this.read(mgmtData, identifier);
                    return list;
                }
                this.log.debug("Metadata for '{}' found in cache", identifier);
                List<Object> list = allMetadata;
                return list;
            }
            this.log.debug("Identifier not resolvable from criteria, can not fetch metadata");
            List list = Collections.emptyList();
            return list;
        }
        finally {
            MetricsSupport.stopTimer((Timer.Context)contextResolve);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fetch(@Nonnull MetadataManagementData<IdentifierType> mgmtData, @Nonnull IdentifierType identifier, @Nonnull @NotEmpty CriteriaSet criteria) throws MetadataCacheException {
        StampedLock sl = mgmtData.getStampLock();
        long stamp = sl.writeLock();
        try {
            if (!this.shouldAttemptRefresh(mgmtData)) {
                List allMetadata = this.lookupIdentifier(identifier);
                if (!allMetadata.isEmpty()) {
                    this.log.debug("{} Metadata for '{}' was acquired while waiting for the write lock", (Object)this.getLogPrefix(), identifier);
                    return;
                }
            } else {
                this.log.trace("{} Metadata for '{}' is stale and requires refreshing", (Object)this.getLogPrefix(), identifier);
            }
            MetadataType resolvedMetadata = null;
            Timer.Context contextFetchFromSource = MetricsSupport.startTimer((Timer)this.timerFetchFromSource);
            try {
                resolvedMetadata = this.fetchStrategy.apply(criteria);
            }
            finally {
                MetricsSupport.stopTimer((Timer.Context)contextFetchFromSource);
            }
            if (resolvedMetadata != null) {
                this.storeNewMetadata(mgmtData, resolvedMetadata, identifier);
            } else {
                this.log.warn("{} Metadata for '{}' could not be resolved from source", (Object)this.getLogPrefix(), identifier);
            }
        }
        finally {
            sl.unlock(stamp);
        }
    }

    private void storeNewMetadata(@Nonnull MetadataManagementData<IdentifierType> mgmtData, @Nonnull MetadataType metadata, @Nonnull IdentifierType expectedIdentifier) {
        Object filteredMetadata = this.getMetadataFilterStrategy().apply(metadata, this.newFilterContext());
        if (filteredMetadata == null) {
            this.log.warn("{} Filtered metadata is null, no further processing performed", (Object)this.getLogPrefix());
            return;
        }
        Object extractedIdentifier = this.getIdentifierExtractionStrategy().apply(filteredMetadata);
        if (extractedIdentifier == null) {
            this.log.warn("{} Metadata identifier could not be extracted, no further processing performed", (Object)this.getLogPrefix());
        }
        if (!Objects.equals(expectedIdentifier, extractedIdentifier)) {
            this.log.warn("{} New metadata's identifer '{}' does not match expected identifier '{}', will not process", new Object[]{this.getLogPrefix(), extractedIdentifier, expectedIdentifier});
            return;
        }
        this.log.debug("{} Resolved metadata with identifier '{}'", (Object)this.getLogPrefix(), extractedIdentifier);
        this.writeToBackingStore(filteredMetadata);
        Instant now = Instant.now();
        this.log.debug("{} For metadata '{}' expiration and refresh computation, 'now' is : {}", new Object[]{this.getLogPrefix(), extractedIdentifier, now});
        mgmtData.setLastUpdateTime(now);
        mgmtData.setExpirationTime(this.getMetadataExpirationTimeStrategy().apply(this.createExpirationTimeContext(filteredMetadata, now)));
        this.log.debug("{} Computed metadata '{}' expiration time: {}", new Object[]{this.getLogPrefix(), extractedIdentifier, mgmtData.getExpirationTime()});
        mgmtData.setRefreshTriggerTime(this.computeRefreshTriggerTime(mgmtData.getExpirationTime(), now));
        this.log.debug("{} Computed metadata '{}' refresh trigger time: {}", new Object[]{this.getLogPrefix(), extractedIdentifier, mgmtData.getRefreshTriggerTime()});
        this.log.info("{} Successfully loaded new Metadata with identifer '{}'", (Object)this.getLogPrefix(), extractedIdentifier);
    }

    protected ExpirationTimeContext<MetadataType> createExpirationTimeContext(@Nonnull MetadataType metadata, @Nonnull Instant now) {
        return new ExpirationTimeContext(metadata, this.minCacheDuration, this.maxCacheDuration, now);
    }

    @Nonnull
    private Instant computeRefreshTriggerTime(@Nullable Instant expirationTime, @Nonnull Instant nowDateTime) {
        long refreshDelay;
        long now = nowDateTime.toEpochMilli();
        long expireInstant = 0L;
        if (expirationTime != null) {
            expireInstant = expirationTime.toEpochMilli();
        }
        if ((refreshDelay = (long)((float)(expireInstant - now) * this.getRefreshDelayFactor().floatValue())) < this.minCacheDuration.toMillis()) {
            refreshDelay = this.minCacheDuration.toMillis();
        }
        return nowDateTime.plusMillis(refreshDelay);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    private List<MetadataType> read(@Nonnull MetadataManagementData<IdentifierType> mgmtData, @Nonnull IdentifierType identifier) throws MetadataCacheException {
        if (this.hasExpired(mgmtData)) {
            this.log.trace("{} Metadata has expired for '{}'", (Object)this.getLogPrefix(), identifier);
            return Collections.emptyList();
        }
        mgmtData.recordEntityAccess();
        StampedLock sl = mgmtData.getStampLock();
        long stamp = sl.tryOptimisticRead();
        List allMetadata = this.lookupIdentifier(identifier);
        if (sl.validate(stamp)) {
            return allMetadata;
        }
        stamp = sl.readLock();
        try {
            List list = this.lookupIdentifier(identifier);
            return list;
        }
        finally {
            sl.unlock(stamp);
        }
    }

    private class ExpiredAndIdleMetadataCleanupTask
    implements Runnable {
        @Nonnull
        private final Logger log = LoggerFactory.getLogger(ExpiredAndIdleMetadataCleanupTask.class);

        private ExpiredAndIdleMetadataCleanupTask() {
        }

        @Override
        public void run() {
            if (DynamicMetadataCache.this.isDestroyed() || !DynamicMetadataCache.this.isInitialized()) {
                this.log.debug("BackingStoreCleanupSweeper will not run because: inited: {}, destroyed: {}", (Object)DynamicMetadataCache.this.isInitialized(), (Object)DynamicMetadataCache.this.isDestroyed());
                return;
            }
            this.log.trace("{} Running metadata cleanup background timer task", (Object)DynamicMetadataCache.this.getLogPrefix());
            this.removeExpiredAndIdleMetadata();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void removeExpiredAndIdleMetadata() {
            Instant now = Instant.now();
            Instant earliestValidLastAccessed = now.minus(DynamicMetadataCache.this.maxIdleEntityData);
            DynamicBackingStore store = DynamicMetadataCache.this.getBackingStore();
            HashSet ids = new HashSet();
            ids.addAll(store.getIndexedValues().keySet());
            ids.addAll(store.getManagementDataIdentifiers());
            for (Object identifier : ids) {
                MetadataManagementData mgmtData = store.computeManagementDataIfAbsent(identifier, DynamicMetadataCache.this.mgmtMappingFunction);
                long stamp = mgmtData.getStampLock().writeLock();
                try {
                    if (!this.isRemoveData(mgmtData, now, earliestValidLastAccessed)) continue;
                    DynamicMetadataCache.this.invalidate(identifier);
                    store.removeManagementData(identifier);
                }
                finally {
                    mgmtData.getStampLock().unlock(stamp);
                }
            }
        }

        private boolean isRemoveData(@Nonnull MetadataManagementData<IdentifierType> mgmtData, @Nonnull Instant now, @Nonnull Instant earliestValidLastAccessed) {
            if (DynamicMetadataCache.this.removeIdleEntityData && mgmtData.getLastAccessedTime().isBefore(earliestValidLastAccessed)) {
                this.log.debug("{} Metadata exceeds maximum idle time, removing: {}", (Object)DynamicMetadataCache.this.getLogPrefix(), mgmtData.getID());
                return true;
            }
            if (now.isAfter(mgmtData.getExpirationTime())) {
                this.log.debug("{} Metadata has expired, removing: {}", (Object)DynamicMetadataCache.this.getLogPrefix(), mgmtData.getID());
                return true;
            }
            return false;
        }
    }
}

