/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.oidc.profile.spring.relyingparty.metadata.impl;

import java.io.IOException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import javax.servlet.http.HttpServletResponse;
import net.shibboleth.ext.spring.service.ReloadableSpringService;
import net.shibboleth.idp.profile.impl.ReloadServiceConfiguration;
import net.shibboleth.idp.profile.testing.ActionTestingSupport;
import net.shibboleth.idp.profile.testing.RequestContextBuilder;
import net.shibboleth.oidc.metadata.ProviderMetadataResolver;
import net.shibboleth.oidc.metadata.impl.ChainingProviderMetadataResolver;
import net.shibboleth.oidc.profile.spring.relyingparty.metadata.impl.ProviderMetadataResolverServiceStrategy;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.service.ReloadableService;
import net.shibboleth.utilities.java.support.service.ServiceableComponent;
import org.opensaml.profile.context.ProfileRequestContext;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class ReloadProviderMetadataResolverServiceConfigurationTest {
    private ReloadableSpringService<ProviderMetadataResolver> service;
    private RequestContext src;
    private List<Resource> oneResolver;
    private List<Resource> twoResolvers;

    @BeforeClass
    public void setup() throws IOException, ComponentInitializationException {
        this.oneResolver = new ArrayList<Resource>();
        this.oneResolver.add((Resource)new ClassPathResource("/net/shibboleth/oidc/metadata/impl/oidc-provider-metadata-providers.xml"));
        this.twoResolvers = new ArrayList<Resource>();
        this.twoResolvers.add((Resource)new ClassPathResource("/net/shibboleth/oidc/metadata/impl/oidc-provider-metadata-providers2.xml"));
    }

    public void setupResolver(List<Resource> serviceLocations) throws ComponentInitializationException {
        this.service = new ReloadableSpringService(ProviderMetadataResolver.class, (Function)new ProviderMetadataResolverServiceStrategy());
        this.service.setFailFast(true);
        this.service.setId("mockId");
        this.service.setServiceConfigurations(serviceLocations);
        this.service.initialize();
    }

    @BeforeMethod
    public void setUpAction() throws ComponentInitializationException {
        this.src = new RequestContextBuilder().buildRequestContext();
    }

    @Test
    public void oneResource() throws ComponentInitializationException {
        this.setupResolver(this.oneResolver);
        Instant time = this.service.getLastReloadAttemptInstant();
        this.service.reload();
        Assert.assertNotEquals((Object)time, (Object)this.service.getLastReloadAttemptInstant());
        ServiceableComponent component = this.service.getServiceableComponent();
        ProviderMetadataResolver resolver = (ProviderMetadataResolver)component.getComponent();
        component.unpinComponent();
        Assert.assertEquals((int)this.getChainSize(resolver), (int)1);
    }

    protected int getChainSize(ProviderMetadataResolver resolver) {
        Assert.assertTrue((boolean)(resolver instanceof ChainingProviderMetadataResolver));
        ChainingProviderMetadataResolver chain = (ChainingProviderMetadataResolver)resolver;
        return chain.getResolvers().size();
    }

    @Test
    public void twoResources() throws ComponentInitializationException {
        this.setupResolver(this.twoResolvers);
        Instant time = this.service.getLastReloadAttemptInstant();
        this.service.reload();
        Assert.assertNotEquals((Object)time, (Object)this.service.getLastReloadAttemptInstant());
        ServiceableComponent component = this.service.getServiceableComponent();
        ProviderMetadataResolver resolver = (ProviderMetadataResolver)component.getComponent();
        component.unpinComponent();
        Assert.assertEquals((int)this.getChainSize(resolver), (int)2);
    }

    @Test(expectedExceptions={ComponentInitializationException.class})
    public void noResources() throws ComponentInitializationException {
        this.setupResolver(new ArrayList<Resource>());
    }

    @Test
    public void serviceAction() throws ComponentInitializationException {
        this.setupResolver(this.oneResolver);
        Instant time = this.service.getLastReloadAttemptInstant();
        MockHttpServletResponse response = new MockHttpServletResponse();
        ReloadServiceConfiguration action = ReloadProviderMetadataResolverServiceConfigurationTest.initializeAction(this.service, (HttpServletResponse)response);
        Event event = action.execute(this.src);
        this.service.getServiceableComponent().unpinComponent();
        ActionTestingSupport.assertProceedEvent((Event)event);
        Assert.assertNotEquals((Object)time, (Object)this.service.getLastReloadAttemptInstant());
        Assert.assertEquals((int)response.getStatus(), (int)200);
    }

    protected static ReloadServiceConfiguration initializeAction(final ReloadableService<?> reloadableService, HttpServletResponse response) throws ComponentInitializationException {
        ReloadServiceConfiguration action = new ReloadServiceConfiguration();
        action.setHttpServletResponse(response);
        action.setServiceLookupStrategy(new Function<ProfileRequestContext, ReloadableService<?>>(){

            @Override
            public ReloadableService<?> apply(ProfileRequestContext input) {
                return reloadableService;
            }
        });
        action.initialize();
        return action;
    }

    @AfterClass
    public void teardown() {
        ComponentSupport.destroy(this.service);
    }
}

