/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.oidc.metadata.policy.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.shibboleth.oidc.metadata.policy.MetadataPolicy;
import net.shibboleth.oidc.metadata.policy.impl.MetadataPolicyHelper;
import net.shibboleth.utilities.java.support.logic.ConstraintViolationException;
import org.testng.Assert;
import org.testng.annotations.Test;

public class MetadataPolicyHelperTest {
    @Test
    public void mergeMetadataPolicies_bothNull_shouldReturnNull() {
        Assert.assertNull((Object)MetadataPolicyHelper.mergeMetadataPolicies(null, null));
    }

    @Test
    public void mergeMetadataPolicies_subordinateNull_shouldReturnSuperior() {
        MetadataPolicy superior = new MetadataPolicy.Builder().withSubsetOfValues(List.of("value1", "value2", "value3")).build();
        MetadataPolicy merged = MetadataPolicyHelper.mergeMetadataPolicies((MetadataPolicy)superior, null);
        this.assertEquals(merged, superior);
    }

    @Test
    public void mergeMetadataPolicies_superiorNull_shouldReturnSubordinate() {
        MetadataPolicy subordinate = new MetadataPolicy.Builder().withSubsetOfValues(List.of("value1", "value2", "value3")).build();
        MetadataPolicy merged = MetadataPolicyHelper.mergeMetadataPolicies(null, (MetadataPolicy)subordinate);
        this.assertEquals(merged, subordinate);
    }

    @Test
    public void mergeMetadataPolicies_bothSubsetOf_shouldReturnIntersection() {
        MetadataPolicy superior = new MetadataPolicy.Builder().withSubsetOfValues(List.of("value1", "value2", "value3")).build();
        MetadataPolicy subordinate = new MetadataPolicy.Builder().withSubsetOfValues(List.of("value2", "value3", "value4")).build();
        MetadataPolicy merged = MetadataPolicyHelper.mergeMetadataPolicies((MetadataPolicy)superior, (MetadataPolicy)subordinate);
        Assert.assertNotNull((Object)merged);
        Assert.assertEquals(new HashSet(merged.getSubsetOfValues()), Set.of("value2", "value3"));
    }

    @Test
    public void mergeMetadataPolicies_bothSubsetOfDifferentTypes_shouldReturnEmptyList() {
        MetadataPolicy superior = new MetadataPolicy.Builder().withSubsetOfValues(List.of("1", "2", "3")).build();
        MetadataPolicy subordinate = new MetadataPolicy.Builder().withSubsetOfValues(List.of(Integer.valueOf(2), Integer.valueOf(3), Integer.valueOf(4))).build();
        MetadataPolicy merged = MetadataPolicyHelper.mergeMetadataPolicies((MetadataPolicy)superior, (MetadataPolicy)subordinate);
        Assert.assertNotNull((Object)merged);
        Assert.assertEquals((Collection)merged.getSubsetOfValues(), Collections.emptyList());
    }

    @Test
    public void mergeMetadataPolicies_oneSubsetOf_shouldReturnSameOne() {
        MetadataPolicy superior = new MetadataPolicy.Builder().withSubsetOfValues(List.of("value1", "value2", "value3")).build();
        MetadataPolicy subordinate = new MetadataPolicy.Builder().build();
        MetadataPolicy merged = MetadataPolicyHelper.mergeMetadataPolicies((MetadataPolicy)superior, (MetadataPolicy)subordinate);
        Assert.assertNotNull((Object)merged);
        Assert.assertEquals((Collection)merged.getSubsetOfValues(), (Collection)superior.getSubsetOfValues());
    }

    @Test
    public void mergeMetadataPolicies_oneSubsetOf_shouldReturnSameOne2() {
        MetadataPolicy superior = new MetadataPolicy.Builder().build();
        MetadataPolicy subordinate = new MetadataPolicy.Builder().withSubsetOfValues(List.of("value1", "value2", "value3")).build();
        MetadataPolicy merged = MetadataPolicyHelper.mergeMetadataPolicies((MetadataPolicy)superior, (MetadataPolicy)subordinate);
        Assert.assertNotNull((Object)merged);
        Assert.assertEquals((Collection)merged.getSubsetOfValues(), (Collection)subordinate.getSubsetOfValues());
    }

    @Test
    public void mergeMetadataPolicies_oneSubsetOf_anotherEmpty_shouldReturnEmpty() {
        MetadataPolicy superior = new MetadataPolicy.Builder().withSubsetOfValues(List.of("value1", "value2", "value3")).build();
        MetadataPolicy subordinate = new MetadataPolicy.Builder().withSubsetOfValues(Collections.emptyList()).build();
        MetadataPolicy merged = MetadataPolicyHelper.mergeMetadataPolicies((MetadataPolicy)superior, (MetadataPolicy)subordinate);
        Assert.assertNotNull((Object)merged);
        Assert.assertEquals((Collection)merged.getSubsetOfValues(), Collections.emptyList());
    }

    @Test
    public void mergeMetadataPolicies_oneSubsetOf_anotherEmpty_shouldReturnEmpty2() {
        MetadataPolicy superior = new MetadataPolicy.Builder().withSubsetOfValues(Collections.emptyList()).build();
        MetadataPolicy subordinate = new MetadataPolicy.Builder().withSubsetOfValues(List.of("value1", "value2", "value3")).build();
        MetadataPolicy merged = MetadataPolicyHelper.mergeMetadataPolicies((MetadataPolicy)superior, (MetadataPolicy)subordinate);
        Assert.assertNotNull((Object)merged);
        Assert.assertEquals((Collection)merged.getSubsetOfValues(), Collections.emptyList());
    }

    @Test
    public void mergeMetadataPolicies_bothOneOf_shouldReturnIntersection() {
        MetadataPolicy superior = new MetadataPolicy.Builder().withOneOfValues(List.of("value1", "value2", "value3")).build();
        MetadataPolicy subordinate = new MetadataPolicy.Builder().withOneOfValues(List.of("value2", "value3", "value4")).build();
        MetadataPolicy merged = MetadataPolicyHelper.mergeMetadataPolicies((MetadataPolicy)superior, (MetadataPolicy)subordinate);
        Assert.assertNotNull((Object)merged);
        Assert.assertEquals(new HashSet(merged.getOneOfValues()), Set.of("value2", "value3"));
    }

    @Test
    public void mergeMetadataPolicies_bothOneOfDifferentTypes_shouldReturnEmptyList() {
        MetadataPolicy superior = new MetadataPolicy.Builder().withOneOfValues(List.of("1", "2", "3")).build();
        MetadataPolicy subordinate = new MetadataPolicy.Builder().withOneOfValues(List.of(Integer.valueOf(2), Integer.valueOf(3), Integer.valueOf(4))).build();
        MetadataPolicy merged = MetadataPolicyHelper.mergeMetadataPolicies((MetadataPolicy)superior, (MetadataPolicy)subordinate);
        Assert.assertNotNull((Object)merged);
        Assert.assertEquals((Collection)merged.getOneOfValues(), Collections.emptyList());
    }

    @Test
    public void mergeMetadataPolicies_oneOneOf_shouldReturnSameOne() {
        MetadataPolicy superior = new MetadataPolicy.Builder().withOneOfValues(List.of("value1", "value2", "value3")).build();
        MetadataPolicy subordinate = new MetadataPolicy.Builder().build();
        MetadataPolicy merged = MetadataPolicyHelper.mergeMetadataPolicies((MetadataPolicy)superior, (MetadataPolicy)subordinate);
        Assert.assertNotNull((Object)merged);
        Assert.assertEquals((Collection)merged.getOneOfValues(), (Collection)superior.getOneOfValues());
    }

    @Test
    public void mergeMetadataPolicies_oneOneOf_shouldReturnSameOne2() {
        MetadataPolicy superior = new MetadataPolicy.Builder().build();
        MetadataPolicy subordinate = new MetadataPolicy.Builder().withOneOfValues(List.of("value1", "value2", "value3")).build();
        MetadataPolicy merged = MetadataPolicyHelper.mergeMetadataPolicies((MetadataPolicy)superior, (MetadataPolicy)subordinate);
        Assert.assertNotNull((Object)merged);
        Assert.assertEquals((Collection)merged.getOneOfValues(), (Collection)subordinate.getOneOfValues());
    }

    @Test
    public void mergeMetadataPolicies_oneOneOf_anotherEmpty_shouldReturnEmpty() {
        MetadataPolicy superior = new MetadataPolicy.Builder().withOneOfValues(List.of("value1", "value2", "value3")).build();
        MetadataPolicy subordinate = new MetadataPolicy.Builder().withOneOfValues(Collections.emptyList()).build();
        MetadataPolicy merged = MetadataPolicyHelper.mergeMetadataPolicies((MetadataPolicy)superior, (MetadataPolicy)subordinate);
        Assert.assertNotNull((Object)merged);
        Assert.assertEquals((Collection)merged.getOneOfValues(), Collections.emptyList());
    }

    @Test
    public void mergeMetadataPolicies_oneOneOf_anotherEmpty_shouldReturnEmpty2() {
        MetadataPolicy superior = new MetadataPolicy.Builder().withOneOfValues(Collections.emptyList()).build();
        MetadataPolicy subordinate = new MetadataPolicy.Builder().withOneOfValues(List.of("value1", "value2", "value3")).build();
        MetadataPolicy merged = MetadataPolicyHelper.mergeMetadataPolicies((MetadataPolicy)superior, (MetadataPolicy)subordinate);
        Assert.assertNotNull((Object)merged);
        Assert.assertEquals((Collection)merged.getOneOfValues(), Collections.emptyList());
    }

    @Test
    public void mergeMetadataPolicies_bothSupersetOf_shouldReturnUnion() {
        MetadataPolicy superior = new MetadataPolicy.Builder().withSupersetOfValues(List.of("value1", "value2", "value3")).build();
        MetadataPolicy subordinate = new MetadataPolicy.Builder().withSupersetOfValues(List.of("value2", "value3", "value4")).build();
        MetadataPolicy merged = MetadataPolicyHelper.mergeMetadataPolicies((MetadataPolicy)superior, (MetadataPolicy)subordinate);
        Assert.assertNotNull((Object)merged);
        Assert.assertEquals(new HashSet(merged.getSupersetOfValues()), Set.of("value1", "value2", "value3", "value4"));
    }

    @Test
    public void mergeMetadataPolicies_oneSupersetOf_shouldReturnSame() {
        MetadataPolicy superior = new MetadataPolicy.Builder().withSupersetOfValues(List.of("value1", "value2", "value3")).build();
        MetadataPolicy subordinate = new MetadataPolicy.Builder().build();
        MetadataPolicy merged = MetadataPolicyHelper.mergeMetadataPolicies((MetadataPolicy)superior, (MetadataPolicy)subordinate);
        Assert.assertNotNull((Object)merged);
        Assert.assertEquals(new HashSet(merged.getSupersetOfValues()), Set.of("value1", "value2", "value3"));
    }

    @Test
    public void mergeMetadataPolicies_bothAdd_oneSingle_shouldReturnSameValue() {
        MetadataPolicy superior = new MetadataPolicy.Builder().withAdd((Object)"singleValue1").build();
        MetadataPolicy subordinate = new MetadataPolicy.Builder().withAdd((Object)"singleValue1").build();
        MetadataPolicy merged = MetadataPolicyHelper.mergeMetadataPolicies((MetadataPolicy)superior, (MetadataPolicy)subordinate);
        Assert.assertNotNull((Object)merged);
        Assert.assertEquals((Object)merged.getAdd(), (Object)"singleValue1");
    }

    @Test
    public void mergeMetadataPolicies_bothAdd_twoSinglesDifferentTypes_shouldReturnUnionAsList() {
        MetadataPolicy superior = new MetadataPolicy.Builder().withAdd((Object)"singleValue1").build();
        MetadataPolicy subordinate = new MetadataPolicy.Builder().withAdd((Object)2).build();
        MetadataPolicy merged = MetadataPolicyHelper.mergeMetadataPolicies((MetadataPolicy)superior, (MetadataPolicy)subordinate);
        Assert.assertNotNull((Object)merged);
        Assert.assertEquals(new HashSet((List)merged.getAdd()), Set.of("singleValue1", Integer.valueOf(2)));
    }

    @Test
    public void mergeMetadataPolicies_bothAdd_twoSingles_shouldReturnUnionAsList() {
        MetadataPolicy superior = new MetadataPolicy.Builder().withAdd((Object)"singleValue1").build();
        MetadataPolicy subordinate = new MetadataPolicy.Builder().withAdd((Object)"singleValue2").build();
        MetadataPolicy merged = MetadataPolicyHelper.mergeMetadataPolicies((MetadataPolicy)superior, (MetadataPolicy)subordinate);
        Assert.assertNotNull((Object)merged);
        Assert.assertEquals(new HashSet((List)merged.getAdd()), Set.of("singleValue1", "singleValue2"));
    }

    @Test
    public void mergeMetadataPolicies_bothAdd_singleAndList_shouldReturnUnionAsList() {
        MetadataPolicy superior = new MetadataPolicy.Builder().withAdd((Object)"singleValue1").build();
        MetadataPolicy subordinate = new MetadataPolicy.Builder().withAdd(List.of("listValue1", "listValue2")).build();
        MetadataPolicy merged = MetadataPolicyHelper.mergeMetadataPolicies((MetadataPolicy)superior, (MetadataPolicy)subordinate);
        Assert.assertNotNull((Object)merged);
        Assert.assertEquals(new HashSet((List)merged.getAdd()), Set.of("singleValue1", "listValue1", "listValue2"));
    }

    @Test
    public void mergeMetadataPolicies_bothSameValue_shouldReturnSame() {
        MetadataPolicy superior = new MetadataPolicy.Builder().withValue((Object)"singleValue1").build();
        MetadataPolicy subordinate = new MetadataPolicy.Builder().withValue((Object)"singleValue1").build();
        MetadataPolicy merged = MetadataPolicyHelper.mergeMetadataPolicies((MetadataPolicy)superior, (MetadataPolicy)subordinate);
        Assert.assertNotNull((Object)merged);
        Assert.assertEquals((Object)merged.getValue(), (Object)"singleValue1");
    }

    @Test(expectedExceptions={ConstraintViolationException.class})
    public void mergeMetadataPolicies_bothDifferentValue_shouldThrow() {
        MetadataPolicy superior = new MetadataPolicy.Builder().withValue((Object)"singleValue1").build();
        MetadataPolicy subordinate = new MetadataPolicy.Builder().withValue((Object)"singleValue2").build();
        MetadataPolicyHelper.mergeMetadataPolicies((MetadataPolicy)superior, (MetadataPolicy)subordinate);
    }

    @Test(expectedExceptions={ConstraintViolationException.class})
    public void mergeMetadataPolicies_bothDifferentListValue_shouldThrow() {
        MetadataPolicy superior = new MetadataPolicy.Builder().withValue(List.of("singleValue1")).build();
        MetadataPolicy subordinate = new MetadataPolicy.Builder().withValue(List.of("singleValue2")).build();
        MetadataPolicyHelper.mergeMetadataPolicies((MetadataPolicy)superior, (MetadataPolicy)subordinate);
    }

    @Test
    public void mergeMetadataPolicies_bothSameDefaultValue_shouldReturnSame() {
        MetadataPolicy superior = new MetadataPolicy.Builder().withDefaultValue((Object)"singleValue1").build();
        MetadataPolicy subordinate = new MetadataPolicy.Builder().withDefaultValue((Object)"singleValue1").build();
        MetadataPolicy merged = MetadataPolicyHelper.mergeMetadataPolicies((MetadataPolicy)superior, (MetadataPolicy)subordinate);
        Assert.assertNotNull((Object)merged);
        Assert.assertEquals((Object)merged.getDefaultValue(), (Object)"singleValue1");
    }

    @Test(expectedExceptions={ConstraintViolationException.class})
    public void mergeMetadataPolicies_bothDifferentDefaultValue_shouldThrow() {
        MetadataPolicy superior = new MetadataPolicy.Builder().withDefaultValue((Object)"singleValue1").build();
        MetadataPolicy subordinate = new MetadataPolicy.Builder().withDefaultValue((Object)"singleValue2").build();
        MetadataPolicyHelper.mergeMetadataPolicies((MetadataPolicy)superior, (MetadataPolicy)subordinate);
    }

    @Test
    public void mergeMetadataPolicies_bothSameRegexp_shouldReturnSame() {
        MetadataPolicy superior = new MetadataPolicy.Builder().withRegexp("singleValue1").build();
        MetadataPolicy subordinate = new MetadataPolicy.Builder().withRegexp("singleValue1").build();
        MetadataPolicy merged = MetadataPolicyHelper.mergeMetadataPolicies((MetadataPolicy)superior, (MetadataPolicy)subordinate);
        Assert.assertNotNull((Object)merged);
        Assert.assertEquals((String)merged.getRegexp(), (String)"singleValue1");
    }

    @Test(expectedExceptions={ConstraintViolationException.class})
    public void mergeMetadataPolicies_bothDifferentRegexp_shouldThrow() {
        MetadataPolicy superior = new MetadataPolicy.Builder().withRegexp("singleValue1").build();
        MetadataPolicy subordinate = new MetadataPolicy.Builder().withRegexp("singleValue2").build();
        MetadataPolicyHelper.mergeMetadataPolicies((MetadataPolicy)superior, (MetadataPolicy)subordinate);
    }

    @Test(expectedExceptions={ConstraintViolationException.class})
    public void mergeMetadataPolicies_bothDifferentDefaultListValue_shouldThrow() {
        MetadataPolicy superior = new MetadataPolicy.Builder().withDefaultValue(List.of("singleValue1")).build();
        MetadataPolicy subordinate = new MetadataPolicy.Builder().withDefaultValue(List.of("singleValue2")).build();
        MetadataPolicyHelper.mergeMetadataPolicies((MetadataPolicy)superior, (MetadataPolicy)subordinate);
    }

    @Test
    public void mergeMetadataPolicies_bothEssentialTrue_shouldReturnTrue() {
        MetadataPolicy superior = new MetadataPolicy.Builder().withEssential(Boolean.TRUE).build();
        MetadataPolicy subordinate = new MetadataPolicy.Builder().withEssential(Boolean.TRUE).build();
        MetadataPolicy merged = MetadataPolicyHelper.mergeMetadataPolicies((MetadataPolicy)superior, (MetadataPolicy)subordinate);
        Assert.assertNotNull((Object)merged);
        Assert.assertTrue((boolean)merged.isEssential());
    }

    @Test
    public void mergeMetadataPolicies_bothEssentialFalse_shouldReturnFalse() {
        MetadataPolicy superior = new MetadataPolicy.Builder().withEssential(Boolean.FALSE).build();
        MetadataPolicy subordinate = new MetadataPolicy.Builder().withEssential(Boolean.FALSE).build();
        MetadataPolicy merged = MetadataPolicyHelper.mergeMetadataPolicies((MetadataPolicy)superior, (MetadataPolicy)subordinate);
        Assert.assertNotNull((Object)merged);
        Assert.assertFalse((boolean)merged.isEssential());
    }

    @Test
    public void mergeMetadataPolicies_superiorEssentialTrueSubordinateFalse_shouldReturnTrue() {
        MetadataPolicy superior = new MetadataPolicy.Builder().withEssential(Boolean.TRUE).build();
        MetadataPolicy subordinate = new MetadataPolicy.Builder().withEssential(Boolean.FALSE).build();
        MetadataPolicy merged = MetadataPolicyHelper.mergeMetadataPolicies((MetadataPolicy)superior, (MetadataPolicy)subordinate);
        Assert.assertNotNull((Object)merged);
        Assert.assertTrue((boolean)merged.isEssential());
    }

    protected void assertEquals(MetadataPolicy actual, MetadataPolicy expected) {
        Assert.assertNotNull((Object)actual);
        Assert.assertNotNull((Object)expected);
        Assert.assertEquals((Collection)actual.getSubsetOfValues(), (Collection)expected.getSubsetOfValues());
        Assert.assertEquals((Object)actual.getAdd(), (Object)expected.getAdd());
        Assert.assertEquals((Object)actual.getDefaultValue(), (Object)expected.getDefaultValue());
        Assert.assertEquals((Object)actual.getValue(), (Object)expected.getValue());
        Assert.assertEquals((Collection)actual.getOneOfValues(), (Collection)expected.getOneOfValues());
        Assert.assertEquals((Collection)actual.getSupersetOfValues(), (Collection)expected.getSupersetOfValues());
        Assert.assertEquals((String)actual.getRegexp(), (String)expected.getRegexp());
        Assert.assertEquals((boolean)actual.isEssential(), (boolean)expected.isEssential());
    }
}

