/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.oidc.metadata.policy.impl;

import java.util.List;
import java.util.Map;
import net.shibboleth.oidc.metadata.policy.MetadataPolicy;
import net.shibboleth.oidc.metadata.policy.impl.DefaultMetadataPolicyValidator;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class DefaultMetadataPolicyValidatorTest {
    DefaultMetadataPolicyValidator validator;

    @BeforeMethod
    public void init() {
        this.validator = new DefaultMetadataPolicyValidator();
    }

    @Test
    public void test_whenOneOfAndSupersetOfHaveBeenSet_shouldReturnFalse() {
        Map<String, MetadataPolicy> map = Map.of("mockClaim", new MetadataPolicy.Builder().withOneOfValues(List.of("must")).withSupersetOfValues(List.of("must")).build());
        Assert.assertFalse((boolean)this.validator.test(map));
    }

    @Test
    public void test_whenOneOfAndSubsetOfHaveBeenSet_shouldReturnFalse() {
        Map<String, MetadataPolicy> map = Map.of("mockClaim", new MetadataPolicy.Builder().withOneOfValues(List.of("must")).withSubsetOfValues(List.of("must")).build());
        Assert.assertFalse((boolean)this.validator.test(map));
    }

    @Test
    public void test_whenValueAndAddIsSet_shouldReturnFalse() {
        Map<String, MetadataPolicy> map = Map.of("mockClaim", new MetadataPolicy.Builder().withValue((Object)"mockValue").withAdd((Object)"another").build());
        Assert.assertFalse((boolean)this.validator.test(map));
    }

    @Test
    public void test_whenValueAndDefaultSet_shouldReturnFalse() {
        Map<String, MetadataPolicy> map = Map.of("mockClaim", new MetadataPolicy.Builder().withValue((Object)"mockValue").withDefaultValue((Object)"mockValue").build());
        Assert.assertFalse((boolean)this.validator.test(map));
    }

    @Test
    public void test_whenValueAndOneOfSet_shouldReturnFalse() {
        Map<String, MetadataPolicy> map = Map.of("mockClaim", new MetadataPolicy.Builder().withValue((Object)"mockValue").withOneOfValues(List.of("mockValue")).build());
        Assert.assertFalse((boolean)this.validator.test(map));
    }

    @Test
    public void test_whenValueAndSubsetOfSet_shouldReturnFalse() {
        Map<String, MetadataPolicy> map = Map.of("mockClaim", new MetadataPolicy.Builder().withValue((Object)"mockValue").withSubsetOfValues(List.of("mockValue")).build());
        Assert.assertFalse((boolean)this.validator.test(map));
    }

    @Test
    public void test_whenValueAndSupersetOfSet_shouldReturnFalse() {
        Map<String, MetadataPolicy> map = Map.of("mockClaim", new MetadataPolicy.Builder().withValue((Object)"mockValue").withSupersetOfValues(List.of("mockValue")).build());
        Assert.assertFalse((boolean)this.validator.test(map));
    }

    @Test
    public void test_whenValueAndRegexpSet_shouldReturnFalse() {
        Map<String, MetadataPolicy> map = Map.of("mockClaim", new MetadataPolicy.Builder().withValue((Object)"mockValue").withRegexp(".*").build());
        Assert.assertFalse((boolean)this.validator.test(map));
    }

    @Test
    public void test_whenValueAndEssentialSet_shouldReturnTrue() {
        Map<String, MetadataPolicy> map = Map.of("mockClaim", new MetadataPolicy.Builder().withValue((Object)"mockValue").withEssential(Boolean.valueOf(true)).build());
        Assert.assertTrue((boolean)this.validator.test(map));
    }

    @Test
    public void test_whenValueAndNonEssentialSet_shouldReturnTrue() {
        Map<String, MetadataPolicy> map = Map.of("mockClaim", new MetadataPolicy.Builder().withValue((Object)"mockValue").withEssential(Boolean.valueOf(false)).build());
        Assert.assertTrue((boolean)this.validator.test(map));
    }

    @Test
    public void test_whenSubsetAndSupersetOfSet_subsetOfNotBeingSuperset_shouldReturnFalse() {
        Map<String, MetadataPolicy> map = Map.of("mockClaim", new MetadataPolicy.Builder().withSupersetOfValues(List.of("mockValue", "mockValue2")).withSubsetOfValues(List.of("mockValue")).build());
        Assert.assertFalse((boolean)this.validator.test(map));
    }

    @Test
    public void test_whenSubsetAndSupersetOfSet_subsetOfMatchingSupersetOf_shouldReturnTrue() {
        Map<String, MetadataPolicy> map = Map.of("mockClaim", new MetadataPolicy.Builder().withSupersetOfValues(List.of("mockValue", "mockValue2")).withSubsetOfValues(List.of("mockValue", "mockValue2")).build());
        Assert.assertTrue((boolean)this.validator.test(map));
    }

    @Test
    public void test_whenSubsetOfAndAdd_singleAddNotBeingInSubset_shouldReturnFalse() {
        Map<String, MetadataPolicy> map = Map.of("mockClaim", new MetadataPolicy.Builder().withAdd((Object)"mockValue").withSubsetOfValues(List.of("mockValue2", "mockValue3")).build());
        Assert.assertFalse((boolean)this.validator.test(map));
    }

    @Test
    public void test_whenSubsetOfAndAdd_listAddNotBeingInSubset_shouldReturnFalse() {
        Map<String, MetadataPolicy> map = Map.of("mockClaim", new MetadataPolicy.Builder().withAdd(List.of("mockValue")).withSubsetOfValues(List.of("mockValue2", "mockValue3")).build());
        Assert.assertFalse((boolean)this.validator.test(map));
    }

    @Test
    public void test_whenSupersetOfAndAdd_singleAddNotBeingInSuperset_shouldReturnFalse() {
        Map<String, MetadataPolicy> map = Map.of("mockClaim", new MetadataPolicy.Builder().withAdd((Object)"mockValue").withSupersetOfValues(List.of("mockValue", "mockValue2")).build());
        Assert.assertFalse((boolean)this.validator.test(map));
    }

    @Test
    public void test_whenSupersetOfAndAdd_listAddNotBeingInSuperset_shouldReturnFalse() {
        Map<String, MetadataPolicy> map = Map.of("mockClaim", new MetadataPolicy.Builder().withAdd(List.of("mockValue")).withSupersetOfValues(List.of("mockValue", "mockValue2")).build());
        Assert.assertFalse((boolean)this.validator.test(map));
    }

    @Test
    public void test_whenSubsetOfAndDefault_singleDefaultNotBeingInSubset_shouldReturnFalse() {
        Map<String, MetadataPolicy> map = Map.of("mockClaim", new MetadataPolicy.Builder().withDefaultValue((Object)"mockValue").withSubsetOfValues(List.of("mockValue2", "mockValue3")).build());
        Assert.assertFalse((boolean)this.validator.test(map));
    }

    @Test
    public void test_whenSubsetOfAndDefault_listDefaultNotBeingInSubset_shouldReturnFalse() {
        Map<String, MetadataPolicy> map = Map.of("mockClaim", new MetadataPolicy.Builder().withDefaultValue(List.of("mockValue")).withSubsetOfValues(List.of("mockValue2", "mockValue3")).build());
        Assert.assertFalse((boolean)this.validator.test(map));
    }

    @Test
    public void test_whenSupersetOfAndDefault_singleDefaultNotBeingInSuperset_shouldReturnFalse() {
        Map<String, MetadataPolicy> map = Map.of("mockClaim", new MetadataPolicy.Builder().withDefaultValue((Object)"mockValue").withSupersetOfValues(List.of("mockValue", "mockValue2")).build());
        Assert.assertFalse((boolean)this.validator.test(map));
    }

    @Test
    public void test_whenSupersetOfAndDefault_listDefaultNotBeingInSuperset_shouldReturnFalse() {
        Map<String, MetadataPolicy> map = Map.of("mockClaim", new MetadataPolicy.Builder().withDefaultValue(List.of("mockValue")).withSupersetOfValues(List.of("mockValue", "mockValue2")).build());
        Assert.assertFalse((boolean)this.validator.test(map));
    }

    @Test
    public void test_whenOneOfAndAdd_singleAddInOneOf_shouldReturnTrue() {
        Map<String, MetadataPolicy> map = Map.of("mockClaim", new MetadataPolicy.Builder().withAdd((Object)"mockValue").withOneOfValues(List.of("mockValue", "mockValue2")).build());
        Assert.assertTrue((boolean)this.validator.test(map));
    }

    @Test
    public void test_whenOneOfAndAdd_singleAddNotInOneOf_shouldReturnFalse() {
        Map<String, MetadataPolicy> map = Map.of("mockClaim", new MetadataPolicy.Builder().withAdd((Object)"mockValue3").withOneOfValues(List.of("mockValue", "mockValue2")).build());
        Assert.assertFalse((boolean)this.validator.test(map));
    }

    @Test
    public void test_whenOneOfAndAdd_listAddInOneOf_shouldReturnFalse() {
        Map<String, MetadataPolicy> map = Map.of("mockClaim", new MetadataPolicy.Builder().withAdd(List.of("mockValue")).withOneOfValues(List.of("mockValue", "mockValue2")).build());
        Assert.assertFalse((boolean)this.validator.test(map));
    }

    @Test
    public void test_whenOneOfAndDefault_singleDefaultInOneOf_shouldReturnTrue() {
        Map<String, MetadataPolicy> map = Map.of("mockClaim", new MetadataPolicy.Builder().withDefaultValue((Object)"mockValue").withOneOfValues(List.of("mockValue", "mockValue2")).build());
        Assert.assertTrue((boolean)this.validator.test(map));
    }

    @Test
    public void test_whenOneOfAndDefault_singleDefaultNotInOneOf_shouldReturnFalse() {
        Map<String, MetadataPolicy> map = Map.of("mockClaim", new MetadataPolicy.Builder().withDefaultValue((Object)"mockValue3").withOneOfValues(List.of("mockValue", "mockValue2")).build());
        Assert.assertFalse((boolean)this.validator.test(map));
    }

    @Test
    public void test_whenOneOfAndDefault_listDefaultInOneOf_shouldReturnFalse() {
        Map<String, MetadataPolicy> map = Map.of("mockClaim", new MetadataPolicy.Builder().withDefaultValue(List.of("mockValue")).withOneOfValues(List.of("mockValue", "mockValue2")).build());
        Assert.assertFalse((boolean)this.validator.test(map));
    }
}

