/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.oidc.metadata.policy.impl;

import java.util.List;
import net.shibboleth.oidc.metadata.policy.MetadataPolicy;
import net.shibboleth.oidc.metadata.policy.impl.DefaultMetadataPolicyEnforcer;
import net.shibboleth.utilities.java.support.collection.Pair;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class DefaultMetadataPolicyEnforcerTest {
    DefaultMetadataPolicyEnforcer applier;

    @BeforeMethod
    public void init() {
        this.applier = new DefaultMetadataPolicyEnforcer();
    }

    @Test
    public void apply_whenValueSetToNull_resultIsValueWithTrue() {
        String stringValue = "mockValue";
        DefaultMetadataPolicyEnforcerTest.assertResultEquals((Pair<Object, Boolean>)this.applier.apply(null, new MetadataPolicy.Builder().withValue((Object)"mockValue").build()), "mockValue");
        List<String> listValue = List.of("value1", "value2");
        DefaultMetadataPolicyEnforcerTest.assertResultEquals((Pair<Object, Boolean>)this.applier.apply(null, new MetadataPolicy.Builder().withValue(listValue).build()), listValue);
        int intValue = 123;
        DefaultMetadataPolicyEnforcerTest.assertResultEquals((Pair<Object, Boolean>)this.applier.apply(null, new MetadataPolicy.Builder().withValue((Object)123).build()), 123);
        boolean booleanValue = true;
        DefaultMetadataPolicyEnforcerTest.assertResultEquals((Pair<Object, Boolean>)this.applier.apply(null, new MetadataPolicy.Builder().withValue((Object)true).build()), true);
    }

    @Test
    public void apply_whenValueSetToSomething_resultIsValueWithTrue() {
        String stringValue = "mockValue";
        DefaultMetadataPolicyEnforcerTest.assertResultEquals((Pair<Object, Boolean>)this.applier.apply((Object)4321, new MetadataPolicy.Builder().withValue((Object)"mockValue").build()), "mockValue");
        List<String> listValue = List.of("value1", "value2");
        DefaultMetadataPolicyEnforcerTest.assertResultEquals((Pair<Object, Boolean>)this.applier.apply((Object)"mock", new MetadataPolicy.Builder().withValue(listValue).build()), listValue);
        int intValue = 123;
        DefaultMetadataPolicyEnforcerTest.assertResultEquals((Pair<Object, Boolean>)this.applier.apply((Object)false, new MetadataPolicy.Builder().withValue((Object)123).build()), 123);
        boolean booleanValue = true;
        DefaultMetadataPolicyEnforcerTest.assertResultEquals((Pair<Object, Boolean>)this.applier.apply(List.of("1"), new MetadataPolicy.Builder().withValue((Object)true).build()), true);
    }

    @Test
    public void apply_whenAddToNullCandidate_resultIsSameAsWithValue() {
        String stringValue = "mockValue";
        System.out.println("" + this.applier.apply(null, new MetadataPolicy.Builder().withAdd((Object)"mockValue").build()));
        Assert.assertEquals((Object)this.applier.apply(null, new MetadataPolicy.Builder().withAdd((Object)"mockValue").build()), (Object)this.applier.apply(null, new MetadataPolicy.Builder().withValue((Object)"mockValue").build()));
        List<String> listValue = List.of("value1", "value2");
        Assert.assertEquals((Object)this.applier.apply(null, new MetadataPolicy.Builder().withAdd(listValue).build()), (Object)this.applier.apply(null, new MetadataPolicy.Builder().withValue(listValue).build()));
        int intValue = 123;
        Assert.assertEquals((Object)this.applier.apply(null, new MetadataPolicy.Builder().withAdd((Object)123).build()), (Object)this.applier.apply(null, new MetadataPolicy.Builder().withValue((Object)123).build()));
        boolean booleanValue = true;
        Assert.assertEquals((Object)this.applier.apply(null, new MetadataPolicy.Builder().withAdd((Object)true).build()), (Object)this.applier.apply(null, new MetadataPolicy.Builder().withValue((Object)true).build()));
    }

    @Test
    public void apply_whenAddToSameExistingCandidate_resultIsSameWithTrue() {
        DefaultMetadataPolicyEnforcerTest.assertResultEquals((Pair<Object, Boolean>)this.applier.apply((Object)"existing", new MetadataPolicy.Builder().withAdd((Object)"existing").build()), "existing");
        DefaultMetadataPolicyEnforcerTest.assertResultEquals((Pair<Object, Boolean>)this.applier.apply((Object)123, new MetadataPolicy.Builder().withAdd((Object)123).build()), 123);
        DefaultMetadataPolicyEnforcerTest.assertResultEquals((Pair<Object, Boolean>)this.applier.apply((Object)true, new MetadataPolicy.Builder().withAdd((Object)true).build()), true);
    }

    @Test
    public void apply_whenAddToDifferentSingleExistingCandidate_resultIsFalse() {
        DefaultMetadataPolicyEnforcerTest.assertResultFalse((Pair<Object, Boolean>)this.applier.apply((Object)"existing", new MetadataPolicy.Builder().withAdd((Object)"another").build()));
        DefaultMetadataPolicyEnforcerTest.assertResultFalse((Pair<Object, Boolean>)this.applier.apply((Object)"existing", new MetadataPolicy.Builder().withAdd(List.of("another")).build()));
        DefaultMetadataPolicyEnforcerTest.assertResultFalse((Pair<Object, Boolean>)this.applier.apply((Object)123, new MetadataPolicy.Builder().withAdd((Object)321).build()));
        DefaultMetadataPolicyEnforcerTest.assertResultFalse((Pair<Object, Boolean>)this.applier.apply((Object)true, new MetadataPolicy.Builder().withAdd((Object)false).build()));
    }

    @Test
    public void apply_whenAddToListCandidate_resultIsMergedWithTrue() {
        List<String> listValue = List.of("value1", "value2");
        DefaultMetadataPolicyEnforcerTest.assertResultEquals((Pair<Object, Boolean>)this.applier.apply(List.of("value0"), new MetadataPolicy.Builder().withAdd(listValue).build()), List.of("value0", "value1", "value2"));
        List<Integer> intValues = List.of(Integer.valueOf(123));
        DefaultMetadataPolicyEnforcerTest.assertResultEquals((Pair<Object, Boolean>)this.applier.apply(List.of(Integer.valueOf(321)), new MetadataPolicy.Builder().withAdd(intValues).build()), List.of(Integer.valueOf(321), Integer.valueOf(123)));
        List<Boolean> booleanValues = List.of(Boolean.valueOf(true));
        DefaultMetadataPolicyEnforcerTest.assertResultEquals((Pair<Object, Boolean>)this.applier.apply(List.of(Boolean.valueOf(false)), new MetadataPolicy.Builder().withAdd(booleanValues).build()), List.of(Boolean.valueOf(false), Boolean.valueOf(true)));
    }

    @Test
    public void apply_whenNoCandidateAndDefaultSet_resultIsDefaultWithTrue() {
        DefaultMetadataPolicyEnforcerTest.assertResultEquals((Pair<Object, Boolean>)this.applier.apply(null, new MetadataPolicy.Builder().withDefaultValue((Object)"default").build()), "default");
        DefaultMetadataPolicyEnforcerTest.assertResultEquals((Pair<Object, Boolean>)this.applier.apply(null, new MetadataPolicy.Builder().withDefaultValue(List.of("default")).build()), List.of("default"));
        DefaultMetadataPolicyEnforcerTest.assertResultEquals((Pair<Object, Boolean>)this.applier.apply(null, new MetadataPolicy.Builder().withDefaultValue((Object)123).build()), 123);
        DefaultMetadataPolicyEnforcerTest.assertResultEquals((Pair<Object, Boolean>)this.applier.apply(null, new MetadataPolicy.Builder().withDefaultValue((Object)true).build()), true);
    }

    @Test
    public void apply_whenCandidateAndDefaultSet_resultIsCandidateWithTrue() {
        DefaultMetadataPolicyEnforcerTest.assertResultEquals((Pair<Object, Boolean>)this.applier.apply((Object)"existing", new MetadataPolicy.Builder().withDefaultValue((Object)"default").build()), "existing");
        DefaultMetadataPolicyEnforcerTest.assertResultEquals((Pair<Object, Boolean>)this.applier.apply(List.of("existing"), new MetadataPolicy.Builder().withDefaultValue(List.of("default")).build()), List.of("existing"));
        DefaultMetadataPolicyEnforcerTest.assertResultEquals((Pair<Object, Boolean>)this.applier.apply((Object)321, new MetadataPolicy.Builder().withDefaultValue((Object)123).build()), 321);
        DefaultMetadataPolicyEnforcerTest.assertResultEquals((Pair<Object, Boolean>)this.applier.apply((Object)false, new MetadataPolicy.Builder().withDefaultValue((Object)true).build()), false);
    }

    @Test
    public void apply_whenEssentialAndNoValue_resultIsFalse() {
        DefaultMetadataPolicyEnforcerTest.assertResultFalse((Pair<Object, Boolean>)this.applier.apply(null, new MetadataPolicy.Builder().withEssential(Boolean.valueOf(true)).build()));
    }

    @Test
    public void apply_whenNonEssentialAndNoValue_resultIsNullWithTrue() {
        DefaultMetadataPolicyEnforcerTest.assertResultEquals((Pair<Object, Boolean>)this.applier.apply(null, new MetadataPolicy.Builder().build()), null);
        DefaultMetadataPolicyEnforcerTest.assertResultEquals((Pair<Object, Boolean>)this.applier.apply(null, new MetadataPolicy.Builder().withEssential(Boolean.valueOf(false)).build()), null);
    }

    @Test
    public void apply_whenOneOfMeetsValue_resultIsCandidateWithTrue() {
        DefaultMetadataPolicyEnforcerTest.assertResultEquals((Pair<Object, Boolean>)this.applier.apply((Object)"existing", new MetadataPolicy.Builder().withOneOfValues(List.of("existing")).build()), "existing");
        DefaultMetadataPolicyEnforcerTest.assertResultEquals((Pair<Object, Boolean>)this.applier.apply((Object)"existing", new MetadataPolicy.Builder().withOneOfValues(List.of("existing", "another")).build()), "existing");
        DefaultMetadataPolicyEnforcerTest.assertResultEquals((Pair<Object, Boolean>)this.applier.apply(List.of("existing"), new MetadataPolicy.Builder().withOneOfValues(List.of("existing")).build()), List.of("existing"));
        DefaultMetadataPolicyEnforcerTest.assertResultEquals((Pair<Object, Boolean>)this.applier.apply(List.of("existing"), new MetadataPolicy.Builder().withOneOfValues(List.of("existing", "another")).build()), List.of("existing"));
        DefaultMetadataPolicyEnforcerTest.assertResultEquals((Pair<Object, Boolean>)this.applier.apply((Object)123, new MetadataPolicy.Builder().withOneOfValues(List.of(Integer.valueOf(123))).build()), 123);
        DefaultMetadataPolicyEnforcerTest.assertResultEquals((Pair<Object, Boolean>)this.applier.apply((Object)123, new MetadataPolicy.Builder().withOneOfValues(List.of(Integer.valueOf(123), Integer.valueOf(321))).build()), 123);
        DefaultMetadataPolicyEnforcerTest.assertResultEquals((Pair<Object, Boolean>)this.applier.apply(List.of(Integer.valueOf(123)), new MetadataPolicy.Builder().withOneOfValues(List.of(Integer.valueOf(123))).build()), List.of(Integer.valueOf(123)));
        DefaultMetadataPolicyEnforcerTest.assertResultEquals((Pair<Object, Boolean>)this.applier.apply(List.of(Integer.valueOf(123)), new MetadataPolicy.Builder().withOneOfValues(List.of(Integer.valueOf(123), Integer.valueOf(321))).build()), List.of(Integer.valueOf(123)));
        DefaultMetadataPolicyEnforcerTest.assertResultEquals((Pair<Object, Boolean>)this.applier.apply((Object)true, new MetadataPolicy.Builder().withOneOfValues(List.of(Boolean.valueOf(true))).build()), true);
        DefaultMetadataPolicyEnforcerTest.assertResultEquals((Pair<Object, Boolean>)this.applier.apply((Object)true, new MetadataPolicy.Builder().withOneOfValues(List.of(Boolean.valueOf(true), Boolean.valueOf(false))).build()), true);
        DefaultMetadataPolicyEnforcerTest.assertResultEquals((Pair<Object, Boolean>)this.applier.apply(List.of(Boolean.valueOf(true)), new MetadataPolicy.Builder().withOneOfValues(List.of(Boolean.valueOf(true))).build()), List.of(Boolean.valueOf(true)));
        DefaultMetadataPolicyEnforcerTest.assertResultEquals((Pair<Object, Boolean>)this.applier.apply(List.of(Boolean.valueOf(true)), new MetadataPolicy.Builder().withOneOfValues(List.of(Boolean.valueOf(true), Boolean.valueOf(false))).build()), List.of(Boolean.valueOf(true)));
    }

    @Test
    public void apply_whenOneOfNotMeetingValue_resultIsFalse() {
        DefaultMetadataPolicyEnforcerTest.assertResultFalse((Pair<Object, Boolean>)this.applier.apply(List.of("existing", "another"), new MetadataPolicy.Builder().withOneOfValues(List.of("existing", "another")).build()));
        DefaultMetadataPolicyEnforcerTest.assertResultFalse((Pair<Object, Boolean>)this.applier.apply(List.of("not"), new MetadataPolicy.Builder().withOneOfValues(List.of("existing", "another")).build()));
        DefaultMetadataPolicyEnforcerTest.assertResultFalse((Pair<Object, Boolean>)this.applier.apply((Object)"not", new MetadataPolicy.Builder().withOneOfValues(List.of("existing")).build()));
        DefaultMetadataPolicyEnforcerTest.assertResultFalse((Pair<Object, Boolean>)this.applier.apply((Object)"not", new MetadataPolicy.Builder().withOneOfValues(List.of("existing", "another")).build()));
        DefaultMetadataPolicyEnforcerTest.assertResultFalse((Pair<Object, Boolean>)this.applier.apply((Object)123, new MetadataPolicy.Builder().withOneOfValues(List.of(Integer.valueOf(321))).build()));
        DefaultMetadataPolicyEnforcerTest.assertResultFalse((Pair<Object, Boolean>)this.applier.apply((Object)123, new MetadataPolicy.Builder().withOneOfValues(List.of(Integer.valueOf(321), Integer.valueOf(322))).build()));
        DefaultMetadataPolicyEnforcerTest.assertResultFalse((Pair<Object, Boolean>)this.applier.apply(List.of(Integer.valueOf(123)), new MetadataPolicy.Builder().withOneOfValues(List.of(Integer.valueOf(321))).build()));
        DefaultMetadataPolicyEnforcerTest.assertResultFalse((Pair<Object, Boolean>)this.applier.apply(List.of(Integer.valueOf(123)), new MetadataPolicy.Builder().withOneOfValues(List.of(Integer.valueOf(321), Integer.valueOf(322))).build()));
        DefaultMetadataPolicyEnforcerTest.assertResultFalse((Pair<Object, Boolean>)this.applier.apply((Object)true, new MetadataPolicy.Builder().withOneOfValues(List.of(Boolean.valueOf(false))).build()));
        DefaultMetadataPolicyEnforcerTest.assertResultFalse((Pair<Object, Boolean>)this.applier.apply((Object)false, new MetadataPolicy.Builder().withOneOfValues(List.of(Boolean.valueOf(true))).build()));
        DefaultMetadataPolicyEnforcerTest.assertResultFalse((Pair<Object, Boolean>)this.applier.apply(List.of(Boolean.valueOf(true)), new MetadataPolicy.Builder().withOneOfValues(List.of(Boolean.valueOf(false))).build()));
        DefaultMetadataPolicyEnforcerTest.assertResultFalse((Pair<Object, Boolean>)this.applier.apply(List.of(Boolean.valueOf(false)), new MetadataPolicy.Builder().withOneOfValues(List.of(Boolean.valueOf(true))).build()));
    }

    @Test
    public void apply_whenSubsetOfMeetsValue_resultIsCandidateWithTrue() {
        DefaultMetadataPolicyEnforcerTest.assertResultEquals((Pair<Object, Boolean>)this.applier.apply((Object)"existing", new MetadataPolicy.Builder().withSubsetOfValues(List.of("existing")).build()), "existing");
        DefaultMetadataPolicyEnforcerTest.assertResultEquals((Pair<Object, Boolean>)this.applier.apply((Object)"existing", new MetadataPolicy.Builder().withSubsetOfValues(List.of("existing", "another")).build()), "existing");
        DefaultMetadataPolicyEnforcerTest.assertResultEquals((Pair<Object, Boolean>)this.applier.apply((Object)123, new MetadataPolicy.Builder().withSubsetOfValues(List.of(Integer.valueOf(123))).build()), 123);
        DefaultMetadataPolicyEnforcerTest.assertResultEquals((Pair<Object, Boolean>)this.applier.apply((Object)123, new MetadataPolicy.Builder().withSubsetOfValues(List.of(Integer.valueOf(123), Integer.valueOf(321))).build()), 123);
        DefaultMetadataPolicyEnforcerTest.assertResultEquals((Pair<Object, Boolean>)this.applier.apply((Object)true, new MetadataPolicy.Builder().withSubsetOfValues(List.of(Boolean.valueOf(true))).build()), true);
        DefaultMetadataPolicyEnforcerTest.assertResultEquals((Pair<Object, Boolean>)this.applier.apply((Object)true, new MetadataPolicy.Builder().withSubsetOfValues(List.of(Boolean.valueOf(true), Boolean.valueOf(false))).build()), true);
        DefaultMetadataPolicyEnforcerTest.assertResultEquals((Pair<Object, Boolean>)this.applier.apply(List.of("existing", "another"), new MetadataPolicy.Builder().withSubsetOfValues(List.of("existing", "another")).build()), List.of("existing", "another"));
        DefaultMetadataPolicyEnforcerTest.assertResultEquals((Pair<Object, Boolean>)this.applier.apply(List.of("existing", "another"), new MetadataPolicy.Builder().withSubsetOfValues(List.of("existing", "another", "yet_another")).build()), List.of("existing", "another"));
        DefaultMetadataPolicyEnforcerTest.assertResultEquals((Pair<Object, Boolean>)this.applier.apply(List.of(Integer.valueOf(123), Integer.valueOf(321)), new MetadataPolicy.Builder().withSubsetOfValues(List.of(Integer.valueOf(123), Integer.valueOf(321))).build()), List.of(Integer.valueOf(123), Integer.valueOf(321)));
        DefaultMetadataPolicyEnforcerTest.assertResultEquals((Pair<Object, Boolean>)this.applier.apply(List.of(Integer.valueOf(123), Integer.valueOf(321)), new MetadataPolicy.Builder().withSubsetOfValues(List.of(Integer.valueOf(123), Integer.valueOf(321), Integer.valueOf(213))).build()), List.of(Integer.valueOf(123), Integer.valueOf(321)));
        DefaultMetadataPolicyEnforcerTest.assertResultEquals((Pair<Object, Boolean>)this.applier.apply(List.of(Boolean.valueOf(true)), new MetadataPolicy.Builder().withSubsetOfValues(List.of(Boolean.valueOf(true))).build()), List.of(Boolean.valueOf(true)));
        DefaultMetadataPolicyEnforcerTest.assertResultEquals((Pair<Object, Boolean>)this.applier.apply(List.of(Boolean.valueOf(true), Boolean.valueOf(false)), new MetadataPolicy.Builder().withSubsetOfValues(List.of(Boolean.valueOf(true), Boolean.valueOf(false))).build()), List.of(Boolean.valueOf(true), Boolean.valueOf(false)));
    }

    @Test
    public void apply_whenSubsetOfNotMeetingValue_resultIsFalse() {
        DefaultMetadataPolicyEnforcerTest.assertResultFalse((Pair<Object, Boolean>)this.applier.apply((Object)"not", new MetadataPolicy.Builder().withSubsetOfValues(List.of("existing")).build()));
        DefaultMetadataPolicyEnforcerTest.assertResultFalse((Pair<Object, Boolean>)this.applier.apply((Object)"not", new MetadataPolicy.Builder().withSubsetOfValues(List.of("existing", "another")).build()));
        DefaultMetadataPolicyEnforcerTest.assertResultFalse((Pair<Object, Boolean>)this.applier.apply((Object)321, new MetadataPolicy.Builder().withSubsetOfValues(List.of(Integer.valueOf(123))).build()));
        DefaultMetadataPolicyEnforcerTest.assertResultFalse((Pair<Object, Boolean>)this.applier.apply((Object)123, new MetadataPolicy.Builder().withSubsetOfValues(List.of(Integer.valueOf(223), Integer.valueOf(321))).build()));
        DefaultMetadataPolicyEnforcerTest.assertResultFalse((Pair<Object, Boolean>)this.applier.apply((Object)true, new MetadataPolicy.Builder().withSubsetOfValues(List.of(Boolean.valueOf(false))).build()));
        DefaultMetadataPolicyEnforcerTest.assertResultFalse((Pair<Object, Boolean>)this.applier.apply((Object)false, new MetadataPolicy.Builder().withSubsetOfValues(List.of(Boolean.valueOf(true))).build()));
        DefaultMetadataPolicyEnforcerTest.assertResultFalse((Pair<Object, Boolean>)this.applier.apply(List.of("not"), new MetadataPolicy.Builder().withSubsetOfValues(List.of("existing", "another")).build()));
        DefaultMetadataPolicyEnforcerTest.assertResultFalse((Pair<Object, Boolean>)this.applier.apply(List.of("not", "neither"), new MetadataPolicy.Builder().withSubsetOfValues(List.of("existing", "another", "yet_another")).build()));
        DefaultMetadataPolicyEnforcerTest.assertResultFalse((Pair<Object, Boolean>)this.applier.apply(List.of(Integer.valueOf(123)), new MetadataPolicy.Builder().withSubsetOfValues(List.of(Integer.valueOf(321), Integer.valueOf(432))).build()));
        DefaultMetadataPolicyEnforcerTest.assertResultFalse((Pair<Object, Boolean>)this.applier.apply(List.of(Integer.valueOf(123), Integer.valueOf(321)), new MetadataPolicy.Builder().withSubsetOfValues(List.of(Integer.valueOf(123), Integer.valueOf(213))).build()));
        DefaultMetadataPolicyEnforcerTest.assertResultFalse((Pair<Object, Boolean>)this.applier.apply(List.of(Boolean.valueOf(true)), new MetadataPolicy.Builder().withSubsetOfValues(List.of(Boolean.valueOf(false))).build()));
        DefaultMetadataPolicyEnforcerTest.assertResultFalse((Pair<Object, Boolean>)this.applier.apply(List.of(Boolean.valueOf(false)), new MetadataPolicy.Builder().withSubsetOfValues(List.of(Boolean.valueOf(true))).build()));
    }

    @Test
    public void apply_whenSupersetOfMeetsValue_resultIsCandidateWithTrue() {
        DefaultMetadataPolicyEnforcerTest.assertResultEquals((Pair<Object, Boolean>)this.applier.apply((Object)"existing", new MetadataPolicy.Builder().withSupersetOfValues(List.of("existing")).build()), "existing");
        DefaultMetadataPolicyEnforcerTest.assertResultEquals((Pair<Object, Boolean>)this.applier.apply((Object)123, new MetadataPolicy.Builder().withSupersetOfValues(List.of(Integer.valueOf(123))).build()), 123);
        DefaultMetadataPolicyEnforcerTest.assertResultEquals((Pair<Object, Boolean>)this.applier.apply((Object)true, new MetadataPolicy.Builder().withSupersetOfValues(List.of(Boolean.valueOf(true))).build()), true);
        DefaultMetadataPolicyEnforcerTest.assertResultEquals((Pair<Object, Boolean>)this.applier.apply((Object)false, new MetadataPolicy.Builder().withSupersetOfValues(List.of(Boolean.valueOf(false))).build()), false);
        DefaultMetadataPolicyEnforcerTest.assertResultEquals((Pair<Object, Boolean>)this.applier.apply(List.of("existing", "another"), new MetadataPolicy.Builder().withSupersetOfValues(List.of("existing", "another")).build()), List.of("existing", "another"));
        DefaultMetadataPolicyEnforcerTest.assertResultEquals((Pair<Object, Boolean>)this.applier.apply(List.of("existing", "another"), new MetadataPolicy.Builder().withSupersetOfValues(List.of("existing")).build()), List.of("existing", "another"));
        DefaultMetadataPolicyEnforcerTest.assertResultEquals((Pair<Object, Boolean>)this.applier.apply(List.of(Integer.valueOf(123), Integer.valueOf(321)), new MetadataPolicy.Builder().withSupersetOfValues(List.of(Integer.valueOf(123), Integer.valueOf(321))).build()), List.of(Integer.valueOf(123), Integer.valueOf(321)));
        DefaultMetadataPolicyEnforcerTest.assertResultEquals((Pair<Object, Boolean>)this.applier.apply(List.of(Integer.valueOf(123), Integer.valueOf(321), Integer.valueOf(213)), new MetadataPolicy.Builder().withSupersetOfValues(List.of(Integer.valueOf(123))).build()), List.of(Integer.valueOf(123), Integer.valueOf(321), Integer.valueOf(213)));
        DefaultMetadataPolicyEnforcerTest.assertResultEquals((Pair<Object, Boolean>)this.applier.apply(List.of(Boolean.valueOf(true)), new MetadataPolicy.Builder().withSupersetOfValues(List.of(Boolean.valueOf(true))).build()), List.of(Boolean.valueOf(true)));
        DefaultMetadataPolicyEnforcerTest.assertResultEquals((Pair<Object, Boolean>)this.applier.apply(List.of(Boolean.valueOf(true), Boolean.valueOf(false)), new MetadataPolicy.Builder().withSupersetOfValues(List.of(Boolean.valueOf(false))).build()), List.of(Boolean.valueOf(true), Boolean.valueOf(false)));
    }

    @Test
    public void apply_whenSupersetOfNotMeetingValue_resultIsFalse() {
        DefaultMetadataPolicyEnforcerTest.assertResultFalse((Pair<Object, Boolean>)this.applier.apply((Object)"not", new MetadataPolicy.Builder().withSupersetOfValues(List.of("existing")).build()));
        DefaultMetadataPolicyEnforcerTest.assertResultFalse((Pair<Object, Boolean>)this.applier.apply((Object)"not", new MetadataPolicy.Builder().withSupersetOfValues(List.of("existing", "another")).build()));
        DefaultMetadataPolicyEnforcerTest.assertResultFalse((Pair<Object, Boolean>)this.applier.apply((Object)321, new MetadataPolicy.Builder().withSupersetOfValues(List.of(Integer.valueOf(123))).build()));
        DefaultMetadataPolicyEnforcerTest.assertResultFalse((Pair<Object, Boolean>)this.applier.apply((Object)123, new MetadataPolicy.Builder().withSupersetOfValues(List.of(Integer.valueOf(223), Integer.valueOf(321))).build()));
        DefaultMetadataPolicyEnforcerTest.assertResultFalse((Pair<Object, Boolean>)this.applier.apply((Object)true, new MetadataPolicy.Builder().withSupersetOfValues(List.of(Boolean.valueOf(false))).build()));
        DefaultMetadataPolicyEnforcerTest.assertResultFalse((Pair<Object, Boolean>)this.applier.apply((Object)false, new MetadataPolicy.Builder().withSupersetOfValues(List.of(Boolean.valueOf(true))).build()));
        DefaultMetadataPolicyEnforcerTest.assertResultFalse((Pair<Object, Boolean>)this.applier.apply(List.of("not"), new MetadataPolicy.Builder().withSupersetOfValues(List.of("not", "another")).build()));
        DefaultMetadataPolicyEnforcerTest.assertResultFalse((Pair<Object, Boolean>)this.applier.apply(List.of("not", "neither"), new MetadataPolicy.Builder().withSupersetOfValues(List.of("not", "neither", "another")).build()));
        DefaultMetadataPolicyEnforcerTest.assertResultFalse((Pair<Object, Boolean>)this.applier.apply(List.of(Integer.valueOf(123)), new MetadataPolicy.Builder().withSupersetOfValues(List.of(Integer.valueOf(123), Integer.valueOf(321))).build()));
        DefaultMetadataPolicyEnforcerTest.assertResultFalse((Pair<Object, Boolean>)this.applier.apply(List.of(Integer.valueOf(123), Integer.valueOf(321)), new MetadataPolicy.Builder().withSupersetOfValues(List.of(Integer.valueOf(123), Integer.valueOf(321), Integer.valueOf(213))).build()));
        DefaultMetadataPolicyEnforcerTest.assertResultFalse((Pair<Object, Boolean>)this.applier.apply(List.of(Boolean.valueOf(true)), new MetadataPolicy.Builder().withSupersetOfValues(List.of(Boolean.valueOf(false))).build()));
        DefaultMetadataPolicyEnforcerTest.assertResultFalse((Pair<Object, Boolean>)this.applier.apply(List.of(Boolean.valueOf(false)), new MetadataPolicy.Builder().withSupersetOfValues(List.of(Boolean.valueOf(true), Boolean.valueOf(false))).build()));
    }

    @Test
    public void apply_whenRegexMeetsValue_resultIsCandidateWithTrue() {
        String candidate = "https://sub.example.org/cb";
        DefaultMetadataPolicyEnforcerTest.assertResultEquals((Pair<Object, Boolean>)this.applier.apply((Object)"https://sub.example.org/cb", new MetadataPolicy.Builder().withRegexp(".*").build()), "https://sub.example.org/cb");
        DefaultMetadataPolicyEnforcerTest.assertResultEquals((Pair<Object, Boolean>)this.applier.apply((Object)"https://sub.example.org/cb", new MetadataPolicy.Builder().withRegexp("^https:\\/\\/(?:([^.]+)\\.)?example\\.org\\/(.*)").build()), "https://sub.example.org/cb");
        List<String> candidates = List.of("https://sub.example.org/cb1", "https://sub.example.org/cb2");
        DefaultMetadataPolicyEnforcerTest.assertResultEquals((Pair<Object, Boolean>)this.applier.apply(candidates, new MetadataPolicy.Builder().withRegexp("^https:\\/\\/(?:([^.]+)\\.)?example\\.org\\/(.*)").build()), candidates);
    }

    @Test
    public void apply_whenRegexNotMeetingValue_resultIsFalse() {
        String regex = "^https:\\/\\/(?:([^.]+)\\.)?example\\.org\\/(.*)";
        DefaultMetadataPolicyEnforcerTest.assertResultFalse((Pair<Object, Boolean>)this.applier.apply((Object)"http://example.org/cb", new MetadataPolicy.Builder().withRegexp("^https:\\/\\/(?:([^.]+)\\.)?example\\.org\\/(.*)").build()));
        DefaultMetadataPolicyEnforcerTest.assertResultFalse((Pair<Object, Boolean>)this.applier.apply((Object)"https://example.com/cb", new MetadataPolicy.Builder().withRegexp("^https:\\/\\/(?:([^.]+)\\.)?example\\.org\\/(.*)").build()));
        DefaultMetadataPolicyEnforcerTest.assertResultFalse((Pair<Object, Boolean>)this.applier.apply(List.of("https://sub.example.org/cb", "https://sub.example.com/cb"), new MetadataPolicy.Builder().withRegexp("^https:\\/\\/(?:([^.]+)\\.)?example\\.org\\/(.*)").build()));
    }

    public static void assertResultEquals(Pair<Object, Boolean> pair, Object expected) {
        Assert.assertTrue((boolean)((Boolean)pair.getSecond()));
        Assert.assertEquals((Object)pair.getFirst(), (Object)expected);
    }

    public static void assertResultFalse(Pair<Object, Boolean> pair) {
        Assert.assertFalse((boolean)((Boolean)pair.getSecond()));
    }
}

