/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.oidc.metadata.impl;

import java.util.Iterator;
import net.shibboleth.oidc.metadata.impl.BaseClientSecretValueResolverTest;
import net.shibboleth.oidc.metadata.impl.PropertiesClientSecretValueResolver;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.UnmodifiableComponentException;
import net.shibboleth.utilities.java.support.logic.ConstraintViolationException;
import net.shibboleth.utilities.java.support.resolver.ResolverException;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class PropertiesClientSecretValueResolverTest
extends BaseClientSecretValueResolverTest<PropertiesClientSecretValueResolver> {
    Resource resource;
    String clientSecretKeyReference = "mockClientSecretKey";
    String clientSecretValue = "mockClientSecretmockClientSecretmockClientSecret";

    @BeforeMethod
    public void init() {
        this.resource = new ClassPathResource("net/shibboleth/oidc/metadata/impl/client-secret-test.properties");
    }

    @Test(expectedExceptions={ComponentInitializationException.class})
    public void initialize_shouldThrowWhenResourceNotSet() throws ComponentInitializationException {
        this.resolver = new PropertiesClientSecretValueResolver();
        ((PropertiesClientSecretValueResolver)this.resolver).setId("mockId");
        ((PropertiesClientSecretValueResolver)this.resolver).initialize();
    }

    @Test(expectedExceptions={ConstraintViolationException.class})
    public void setResource_shouldThrowIfResourceIsNul() {
        this.resolver = new PropertiesClientSecretValueResolver();
        ((PropertiesClientSecretValueResolver)this.resolver).setResource(null);
    }

    @Test(expectedExceptions={UnmodifiableComponentException.class})
    public void setResource_shouldThrowAfterInit() throws ComponentInitializationException {
        this.resolver = this.buildResolver(true);
        ((PropertiesClientSecretValueResolver)this.resolver).setResource(this.resource);
    }

    @Test
    public void resolveSingle_shouldReturnNullWhenPropertyNotFound() throws ResolverException, ComponentInitializationException {
        this.resolver = this.buildResolver(true);
        Assert.assertNull((Object)((PropertiesClientSecretValueResolver)this.resolver).resolveSingle(this.buildCriteriaSet("not_found")));
    }

    @Test
    public void resolveSingle_shouldReturnPropertyWhenFound() throws ResolverException, ComponentInitializationException {
        this.resolver = this.buildResolver(true);
        Assert.assertEquals((String)((PropertiesClientSecretValueResolver)this.resolver).resolveSingle(this.buildCriteriaSet(this.clientSecretKeyReference)), (String)this.clientSecretValue);
    }

    @Test
    public void resolve_shouldReturnEmptyIteratorWhenPropertyNotFound() throws ResolverException, ComponentInitializationException {
        this.resolver = this.buildResolver(true);
        Iterable iterable = ((PropertiesClientSecretValueResolver)this.resolver).resolve(this.buildCriteriaSet("not_found"));
        Assert.assertNotNull((Object)iterable);
        Assert.assertFalse((boolean)iterable.iterator().hasNext());
    }

    @Test
    public void resolve_shouldReturnSingleValueIteratorWhenPropertyFound() throws ResolverException, ComponentInitializationException {
        this.resolver = this.buildResolver(true);
        Iterable iterable = ((PropertiesClientSecretValueResolver)this.resolver).resolve(this.buildCriteriaSet(this.clientSecretKeyReference));
        Assert.assertNotNull((Object)iterable);
        Iterator iterator = iterable.iterator();
        Assert.assertTrue((boolean)iterator.hasNext());
        Assert.assertEquals((String)((String)iterator.next()), (String)this.clientSecretValue);
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    @Override
    protected PropertiesClientSecretValueResolver buildResolver(boolean init) throws ComponentInitializationException {
        this.resolver = new PropertiesClientSecretValueResolver();
        ((PropertiesClientSecretValueResolver)this.resolver).setId("mockId");
        ((PropertiesClientSecretValueResolver)this.resolver).setResource(this.resource);
        if (init) {
            ((PropertiesClientSecretValueResolver)this.resolver).initialize();
        }
        return (PropertiesClientSecretValueResolver)this.resolver;
    }
}

