/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.oidc.metadata.impl;

import com.google.common.base.Predicates;
import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.as.AuthorizationServerMetadata;
import com.nimbusds.oauth2.sdk.id.Issuer;
import com.nimbusds.openid.connect.sdk.op.OIDCProviderMetadata;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.time.Duration;
import java.time.Instant;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.shibboleth.oidc.metadata.AbstractEvaluableMetadataCriterion;
import net.shibboleth.oidc.metadata.BatchBackingStore;
import net.shibboleth.oidc.metadata.DynamicBackingStore;
import net.shibboleth.oidc.metadata.MetadataManagementData;
import net.shibboleth.oidc.metadata.cache.CacheLoadingContext;
import net.shibboleth.oidc.metadata.cache.LoadingStrategy;
import net.shibboleth.oidc.metadata.cache.impl.BatchMetadataCache;
import net.shibboleth.oidc.metadata.cache.impl.DynamicMetadataCache;
import net.shibboleth.oidc.metadata.cache.impl.ManuallyTriggeredScheduledExecutorService;
import net.shibboleth.oidc.metadata.criterion.IssuerIDCriterion;
import net.shibboleth.oidc.metadata.impl.DefaultBatchBackingStore;
import net.shibboleth.oidc.metadata.impl.DefaultDynamicBackingStore;
import net.shibboleth.oidc.metadata.impl.HTTPProviderConfigurationFetchingStrategy;
import net.shibboleth.oidc.metadata.impl.OIDCProviderMetadataResolver;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import net.shibboleth.utilities.java.support.resolver.Criterion;
import net.shibboleth.utilities.java.support.resolver.ResolverException;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.ProtocolVersion;
import org.apache.http.client.HttpClient;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.message.BasicHeader;
import org.apache.http.message.BasicHttpResponse;
import org.apache.http.protocol.HttpContext;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class OIDCProviderMetadataResolverTest {
    private static final String GOOD_PROVIDER_CONFIGURATION_INFO = "{\n\"issuer\": \"https://example.oidc.op.org\",\n\"authorization_endpoint\": \"https://example.oidc.op.org/o/oauth2/v2/auth\",\n\"device_authorization_endpoint\": \"https://oauth2.googleapis.com/device/code\",\n\"token_endpoint\": \"https://oauth2.googleapis.com/token\",\n\"userinfo_endpoint\": \"https://openidconnect.googleapis.com/v1/userinfo\",\n\"revocation_endpoint\": \"https://oauth2.googleapis.com/revoke\",\n\"jwks_uri\": \"https://www.googleapis.com/oauth2/v3/certs\",\n\"response_types_supported\": [\n\"code\",\n\"token\",\n\"id_token\",\n\"code token\",\n\"code id_token\",\n\"token id_token\",\n\"code token id_token\",\n\"none\"\n],\n\"subject_types_supported\": [\n\"public\"\n],\n\"id_token_signing_alg_values_supported\": [\n\"RS256\"\n],\n\"scopes_supported\": [\n\"openid\",\n\"email\",\n\"profile\"\n],\n\"token_endpoint_auth_methods_supported\": [\n\"client_secret_post\",\n\"client_secret_basic\"\n],\n\"claims_supported\": [\n\"aud\",\n\"email\",\n\"email_verified\",\n\"exp\",\n\"family_name\",\n\"given_name\",\n\"iat\",\n\"iss\",\n\"locale\",\n\"name\",\n\"picture\",\n\"sub\"\n],\n\"code_challenge_methods_supported\": [\n\"plain\",\n\"S256\"\n],\n\"grant_types_supported\": [\n\"authorization_code\",\n\"refresh_token\",\n\"urn:ietf:params:oauth:grant-type:device_code\",\n\"urn:ietf:params:oauth:grant-type:jwt-bearer\"\n]\n}";
    private OIDCProviderMetadataResolver dynResolver;
    private OIDCProviderMetadataResolver batchResolver;
    private HttpClient httpClient;
    private TestableDynamicMetadataCache<Issuer, OIDCProviderMetadata> dynCache;
    private TestableBatchMetadataCache<Issuer, OIDCProviderMetadata> batchCache;

    @BeforeMethod
    public void setup() throws Exception {
        this.setupDynamicGlobalCache();
        this.setupBatchGlobalCache();
        this.dynResolver = new OIDCProviderMetadataResolver(this.dynCache);
        this.dynResolver.setId("mockDynmaicHttpOIDCProvider");
        this.dynResolver.initialize();
        this.batchResolver = new OIDCProviderMetadataResolver(this.batchCache);
        this.batchResolver.setId("mockBatchFileOIDCProvider");
        this.batchResolver.initialize();
    }

    private void setupBatchGlobalCache() throws ComponentInitializationException {
        LoadingStrategy metadataLoadingStrat = new LoadingStrategy(){

            public byte[] load(CacheLoadingContext t) {
                return OIDCProviderMetadataResolverTest.GOOD_PROVIDER_CONFIGURATION_INFO.getBytes();
            }

            public String getSourceIdentifier() {
                return "Mock loading source";
            }
        };
        Function<byte[], List> parsingStrat = in -> {
            try {
                return List.of(OIDCProviderMetadata.parse((String)new String((byte[])in, "UTF-8")));
            }
            catch (ParseException | UnsupportedEncodingException e) {
                return null;
            }
        };
        ManuallyTriggeredScheduledExecutorService scheduler = new ManuallyTriggeredScheduledExecutorService();
        this.batchCache = new TestableBatchMetadataCache(new DefaultBatchBackingStore(), scheduler);
        this.batchCache.setParsingStrategy(parsingStrat);
        this.batchCache.setLoadingStrategy(metadataLoadingStrat);
        this.batchCache.setId("MockBatchCache");
        this.batchCache.setIdentifierExtractionStrategy(AuthorizationServerMetadata::getIssuer);
        this.batchCache.setCriteriaToIdentifierStrategy(crit -> {
            IssuerIDCriterion issuerId = (IssuerIDCriterion)crit.get(IssuerIDCriterion.class);
            if (issuerId != null) {
                return issuerId.getIssuerID();
            }
            return null;
        });
        this.batchCache.setMetadataFilterStrategy((metadata, context) -> metadata);
        this.batchCache.setRefreshDelayFactor(Float.valueOf(0.75f));
        this.batchCache.setMinRefreshDelay(Duration.ofMillis(1000L));
        this.batchCache.setMaxRefreshDelay(Duration.ofMillis(1000L));
        this.batchCache.setSourceMetadataValidPredicate((Predicate)Predicates.alwaysTrue());
        this.batchCache.setRefreshDelayFactor(Float.valueOf(0.75f));
        this.batchCache.setMetadataValidPredicate((Predicate)Predicates.alwaysTrue());
        this.batchCache.setSourceMetadataExpiryStrategy(n -> Instant.now().plus(Duration.ofMinutes(5L)));
    }

    private void setupDynamicGlobalCache() throws Exception {
        this.httpClient = (HttpClient)Mockito.mock(HttpClient.class);
        Mockito.when((Object)this.httpClient.execute((HttpUriRequest)ArgumentMatchers.any(HttpUriRequest.class), (ResponseHandler)ArgumentMatchers.any(ResponseHandler.class), (HttpContext)ArgumentMatchers.any(HttpContext.class))).thenReturn((Object)OIDCProviderMetadata.parse((String)GOOD_PROVIDER_CONFIGURATION_INFO));
        HTTPProviderConfigurationFetchingStrategy fetchingStrategy = new HTTPProviderConfigurationFetchingStrategy(this.httpClient, (ResponseHandler)new HTTPProviderConfigurationFetchingStrategy.OIDCProviderMetadataResponseHandler());
        fetchingStrategy.setId("Mock HTTP Fetching Strategy");
        fetchingStrategy.initialize();
        ManuallyTriggeredScheduledExecutorService scheduler = new ManuallyTriggeredScheduledExecutorService();
        this.dynCache = new TestableDynamicMetadataCache(new DefaultDynamicBackingStore(), scheduler);
        this.dynCache.setFetchStrategy((Function)fetchingStrategy);
        this.dynCache.setIdentifierExtractionStrategy(AuthorizationServerMetadata::getIssuer);
        this.dynCache.setMetadataExpirationTimeStrategy(ctx -> ctx.getNow().plus(Duration.ofMinutes(5L)));
        this.dynCache.setCriteriaToIdentifierStrategy(crit -> {
            IssuerIDCriterion issuerId = (IssuerIDCriterion)crit.get(IssuerIDCriterion.class);
            if (issuerId != null) {
                return issuerId.getIssuerID();
            }
            return null;
        });
        this.dynCache.setCleanupTaskInterval(Duration.ofSeconds(100L));
        this.dynCache.setInitialCleanupTaskDelay(Duration.ofSeconds(1L));
        this.dynCache.setMaxIdleEntityData(Duration.ofMinutes(10L));
        this.dynCache.setRemoveIdleEntityData(true);
        this.dynCache.setRefreshDelayFactor(Float.valueOf(0.75f));
        this.dynCache.setMinCacheDuration(Duration.ofMinutes(10L));
        this.dynCache.setMaxCacheDuration(Duration.ofMinutes(20L));
        this.dynCache.setMetadataFilterStrategy((metadata, context) -> metadata);
        this.dynCache.setMetadataValidPredicate((Predicate)Predicates.alwaysTrue());
        this.dynCache.setId("MockDynCache");
    }

    @AfterMethod
    public void tearDown() {
        if (this.dynResolver != null) {
            this.dynResolver.destroy();
        }
        if (this.batchResolver != null) {
            this.batchResolver.destroy();
        }
    }

    @Test
    void testBatchResolve() throws Exception {
        this.batchCache.initialize();
        Iterable found = this.batchResolver.resolve(new CriteriaSet(new Criterion[]{new IssuerIDCriterion(new Issuer("https://example.oidc.op.org"))}));
        Assert.assertNotNull((Object)found);
        Assert.assertTrue((boolean)found.iterator().hasNext());
        Assert.assertTrue((boolean)((OIDCProviderMetadata)found.iterator().next()).getIssuer().equals((Object)new Issuer("https://example.oidc.op.org")));
    }

    @Test
    void testLookupFails_InvalidMetadata() throws Exception {
        this.dynCache.setMetadataValidPredicate((Predicate)Predicates.alwaysFalse());
        this.dynCache.initialize();
        Issuer iss = new Issuer("https://example.oidc.op.org");
        MetadataManagementData mgmtData = this.dynCache.getBackingStore().computeManagementDataIfAbsent((Object)iss, MetadataManagementData::new);
        Instant now = Instant.now();
        mgmtData.setLastUpdateTime(now.minus(Duration.ofMinutes(10L)));
        mgmtData.setExpirationTime(now.plus(Duration.ofMinutes(10L)));
        mgmtData.setRefreshTriggerTime(now.plus(Duration.ofMinutes(10L)));
        OIDCProviderMetadata metadata = OIDCProviderMetadata.parse((String)GOOD_PROVIDER_CONFIGURATION_INFO);
        this.dynCache.getBackingStore().getOrderedValues().add(metadata);
        this.dynCache.getBackingStore().getIndexedValues().put(iss, List.of(metadata));
        Iterable found = this.dynResolver.resolve(new CriteriaSet(new Criterion[]{new IssuerIDCriterion(new Issuer("https://example.oidc.op.org"))}));
        Assert.assertNotNull((Object)found);
        Assert.assertFalse((boolean)found.iterator().hasNext());
    }

    @Test
    void testLookupEventualSuccess_InvalidMetadata() throws Exception {
        AtomicInteger count = new AtomicInteger();
        this.dynCache.setMetadataValidPredicate(m -> {
            int counter = count.getAndIncrement();
            return counter != 0 && counter != 1;
        });
        this.dynCache.initialize();
        Issuer iss = new Issuer("https://example.oidc.op.org");
        MetadataManagementData mgmtData = this.dynCache.getBackingStore().computeManagementDataIfAbsent((Object)iss, MetadataManagementData::new);
        Instant now = Instant.now();
        Instant firstUpdateTime = now.minus(Duration.ofMinutes(10L));
        mgmtData.setLastUpdateTime(firstUpdateTime);
        mgmtData.setExpirationTime(now.plus(Duration.ofMinutes(10L)));
        mgmtData.setRefreshTriggerTime(now.plus(Duration.ofMinutes(10L)));
        OIDCProviderMetadata metadata = OIDCProviderMetadata.parse((String)GOOD_PROVIDER_CONFIGURATION_INFO);
        this.dynCache.getBackingStore().getOrderedValues().add(metadata);
        this.dynCache.getBackingStore().getIndexedValues().put(iss, List.of(metadata));
        Iterable found = this.dynResolver.resolve(new CriteriaSet(new Criterion[]{new IssuerIDCriterion(new Issuer("https://example.oidc.op.org"))}));
        Assert.assertNotNull((Object)found);
        Assert.assertTrue((boolean)found.iterator().hasNext());
        Assert.assertTrue((boolean)mgmtData.getLastUpdateTime().isAfter(firstUpdateTime));
    }

    @Test
    void testDynResolve() throws ResolverException, IOException, ComponentInitializationException {
        this.dynCache.initialize();
        Iterable found = this.dynResolver.resolve(new CriteriaSet(new Criterion[]{new IssuerIDCriterion(new Issuer("https://example.oidc.op.org"))}));
        Assert.assertNotNull((Object)found);
        Assert.assertTrue((boolean)found.iterator().hasNext());
    }

    @Test
    void testDynResolve_Filter() throws ResolverException, IOException, ComponentInitializationException {
        this.dynCache.initialize();
        Iterable found = this.dynResolver.resolve(new CriteriaSet(new Criterion[]{new IssuerIDCriterion(new Issuer("https://example.oidc.op.org")), new AlwaysFilterEvaluableMetadataCriterion(OIDCProviderMetadata.class, true)}));
        Assert.assertNotNull((Object)found);
        Assert.assertTrue((!found.iterator().hasNext() ? 1 : 0) != 0);
    }

    @Test
    void testDynResolve_MetadataNeedsRefresh() throws ResolverException, IOException, ParseException, ComponentInitializationException {
        this.dynCache.initialize();
        Issuer iss = new Issuer("https://example.oidc.op.org");
        MetadataManagementData mgmtData = this.dynCache.getBackingStore().computeManagementDataIfAbsent((Object)iss, MetadataManagementData::new);
        Instant now = Instant.now();
        mgmtData.setLastUpdateTime(now);
        mgmtData.setExpirationTime(now.plus(Duration.ofMinutes(1L)));
        mgmtData.setRefreshTriggerTime(now.minus(Duration.ofMinutes(1L)));
        OIDCProviderMetadata metadata = OIDCProviderMetadata.parse((String)GOOD_PROVIDER_CONFIGURATION_INFO);
        this.dynCache.getBackingStore().getOrderedValues().add(metadata);
        this.dynCache.getBackingStore().getIndexedValues().put(iss, List.of(metadata));
        Iterable found = this.dynResolver.resolve(new CriteriaSet(new Criterion[]{new IssuerIDCriterion(iss)}));
        Assert.assertNotNull((Object)found);
        Assert.assertTrue((boolean)found.iterator().hasNext());
    }

    @Test
    void testDynResolve_Filter_WrongMetadataType() throws ResolverException, IOException, ComponentInitializationException {
        this.dynCache.initialize();
        Iterable found = this.dynResolver.resolve(new CriteriaSet(new Criterion[]{new IssuerIDCriterion(new Issuer("https://example.oidc.op.org")), new WrongTypeEvaluableMetadataCriterion(EntityDescriptor.class, true)}));
        Assert.assertNotNull((Object)found);
        Assert.assertTrue((boolean)found.iterator().hasNext());
    }

    @Test
    void testDynResolve_Filter_WrongClassType() throws ResolverException, IOException, ComponentInitializationException {
        this.dynCache.initialize();
        Iterable found = this.dynResolver.resolve(new CriteriaSet(new Criterion[]{new IssuerIDCriterion(new Issuer("https://example.oidc.op.org")), new WrongTypeOfCriterion()}));
        Assert.assertNotNull((Object)found);
        Assert.assertTrue((boolean)found.iterator().hasNext());
    }

    @Test
    void testResponseHandler() throws IOException {
        HTTPProviderConfigurationFetchingStrategy.OIDCProviderMetadataResponseHandler handler = new HTTPProviderConfigurationFetchingStrategy.OIDCProviderMetadataResponseHandler();
        BasicHttpResponse httpResponse = new BasicHttpResponse(new ProtocolVersion("HTTP", 1, 1), 200, "OK");
        ByteArrayEntity entity = new ByteArrayEntity(GOOD_PROVIDER_CONFIGURATION_INFO.getBytes());
        entity.setContentType((Header)new BasicHeader("Content-Type", "application/json"));
        httpResponse.setEntity((HttpEntity)entity);
        OIDCProviderMetadata metadata = handler.handleResponse((HttpResponse)httpResponse);
        Assert.assertNotNull((Object)metadata);
        Assert.assertTrue((boolean)"https://example.oidc.op.org".equals(metadata.getIssuer().getValue()));
    }

    @Test
    void testResponseHandler_WrongMIMEType() throws IOException {
        HTTPProviderConfigurationFetchingStrategy.OIDCProviderMetadataResponseHandler handler = new HTTPProviderConfigurationFetchingStrategy.OIDCProviderMetadataResponseHandler();
        BasicHttpResponse httpResponse = new BasicHttpResponse(new ProtocolVersion("HTTP", 1, 1), 200, "OK");
        ByteArrayEntity entity = new ByteArrayEntity(GOOD_PROVIDER_CONFIGURATION_INFO.getBytes());
        entity.setContentType((Header)new BasicHeader("Content-Type", "application/not_json"));
        httpResponse.setEntity((HttpEntity)entity);
        OIDCProviderMetadata metadata = handler.handleResponse((HttpResponse)httpResponse);
        Assert.assertNull((Object)metadata);
    }

    @Test
    void testResolve_FromCache() throws ResolverException, IOException, ComponentInitializationException {
        this.dynCache.initialize();
        Assert.assertFalse((boolean)this.dynCache.getBackingStore().getIndexedValues().containsKey(new Issuer("https://example.oidc.op.org")));
        Iterable found = this.dynResolver.resolve(new CriteriaSet(new Criterion[]{new IssuerIDCriterion(new Issuer("https://example.oidc.op.org"))}));
        Assert.assertNotNull((Object)found);
        Assert.assertTrue((boolean)found.iterator().hasNext());
        Assert.assertTrue((boolean)this.dynCache.getBackingStore().getIndexedValues().containsKey(new Issuer("https://example.oidc.op.org")));
        Mockito.when((Object)this.httpClient.execute((HttpUriRequest)ArgumentMatchers.any(HttpUriRequest.class), (ResponseHandler)ArgumentMatchers.any(ResponseHandler.class), (HttpContext)ArgumentMatchers.any(HttpContext.class))).thenReturn(null);
        Iterable foundFromCache = this.dynResolver.resolve(new CriteriaSet(new Criterion[]{new IssuerIDCriterion(new Issuer("https://example.oidc.op.org"))}));
        Assert.assertNotNull((Object)foundFromCache);
        Assert.assertTrue((boolean)foundFromCache.iterator().hasNext());
    }

    @Test
    void testResolve_NullResponse() throws ResolverException, IOException, ComponentInitializationException {
        this.dynCache.initialize();
        Mockito.when((Object)this.httpClient.execute((HttpUriRequest)ArgumentMatchers.any(HttpUriRequest.class), (ResponseHandler)ArgumentMatchers.any(ResponseHandler.class), (HttpContext)ArgumentMatchers.any(HttpContext.class))).thenReturn(null);
        Iterable found = this.dynResolver.resolve(new CriteriaSet(new Criterion[]{new IssuerIDCriterion(new Issuer("https://example.oidc.op.org"))}));
        Assert.assertNotNull((Object)found);
        Assert.assertFalse((boolean)found.iterator().hasNext());
    }

    class TestableBatchMetadataCache<IdentifierType, MetadataType>
    extends BatchMetadataCache<IdentifierType, MetadataType> {
        TestableBatchMetadataCache(@Nullable BatchBackingStore<IdentifierType, MetadataType> store, ScheduledExecutorService executor) {
            super(store, executor);
        }

        public BatchBackingStore<IdentifierType, MetadataType> getBackingStore() {
            return super.getBackingStore();
        }
    }

    class TestableDynamicMetadataCache<IdentifierType, MetadataType>
    extends DynamicMetadataCache<IdentifierType, MetadataType> {
        TestableDynamicMetadataCache(DynamicBackingStore<IdentifierType, MetadataType> store, ScheduledExecutorService executor) {
            super(store, executor);
        }

        public DynamicBackingStore<IdentifierType, MetadataType> getBackingStore() {
            return super.getBackingStore();
        }
    }

    class WrongTypeOfCriterion
    implements Criterion {
        WrongTypeOfCriterion() {
        }
    }

    class WrongTypeEvaluableMetadataCriterion
    extends AbstractEvaluableMetadataCriterion<EntityDescriptor> {
        protected WrongTypeEvaluableMetadataCriterion(Class<EntityDescriptor> claz, boolean defaultResult) {
            super(claz, defaultResult);
        }

        public boolean doTest(EntityDescriptor metadata) {
            return false;
        }
    }

    class AlwaysFilterEvaluableMetadataCriterion
    extends AbstractEvaluableMetadataCriterion<OIDCProviderMetadata> {
        protected AlwaysFilterEvaluableMetadataCriterion(Class<OIDCProviderMetadata> claz, boolean defaultResult) {
            super(claz, defaultResult);
        }

        public boolean doTest(OIDCProviderMetadata metadata) {
            return false;
        }
    }
}

