/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.oidc.metadata.impl;

import com.nimbusds.oauth2.sdk.ResponseType;
import com.nimbusds.oauth2.sdk.Scope;
import com.nimbusds.oauth2.sdk.id.ClientID;
import com.nimbusds.openid.connect.sdk.OIDCResponseTypeValue;
import com.nimbusds.openid.connect.sdk.OIDCScopeValue;
import com.nimbusds.openid.connect.sdk.rp.OIDCClientInformation;
import java.net.URI;
import java.util.Set;
import net.shibboleth.oidc.metadata.criterion.ClientIDCriterion;
import net.shibboleth.oidc.metadata.impl.FilesystemClientInformationResolver;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import net.shibboleth.utilities.java.support.resolver.Criterion;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.testng.Assert;
import org.testng.annotations.Test;

public class FilesystemClientInformationResolverTest {
    FilesystemClientInformationResolver resolver;
    String clientId;
    String clientId2;
    URI redirectUri;
    URI redirectUri2;

    public void initTest(String filename) throws Exception {
        this.initTest(filename, true);
    }

    public void initTest(String filename, boolean failFastInitialization) throws Exception {
        this.clientId = "demo_rp";
        this.clientId2 = "demo_rp2";
        ClassPathResource file = new ClassPathResource(filename);
        this.resolver = new FilesystemClientInformationResolver((Resource)file);
        this.resolver.setId("mockId");
        this.resolver.setFailFastInitialization(failFastInitialization);
        this.resolver.initialize();
        this.redirectUri = new URI("https://192.168.0.150/static");
        this.redirectUri2 = new URI("https://192.168.0.150/static2");
    }

    @Test
    public void testNotFound() throws Exception {
        this.initTest("/net/shibboleth/oidc/metadata/impl/oidc-client.json");
        ClientIDCriterion criterion = new ClientIDCriterion(new ClientID("not_found"));
        OIDCClientInformation clientInfo = this.resolver.resolveSingle(new CriteriaSet(new Criterion[]{criterion}));
        Assert.assertNull((Object)clientInfo);
    }

    @Test(expectedExceptions={ComponentInitializationException.class})
    public void testInvalidJsonFailFast() throws Exception {
        this.initTest("/net/shibboleth/oidc/metadata/impl/client-secret-test.properties");
    }

    @Test
    public void testInvalidJsonNoFailFast() throws Exception {
        this.initTest("/net/shibboleth/oidc/metadata/impl/client-secret-test.properties", false);
        ClientIDCriterion criterion = new ClientIDCriterion(new ClientID(this.clientId));
        OIDCClientInformation clientInfo = this.resolver.resolveSingle(new CriteriaSet(new Criterion[]{criterion}));
        Assert.assertNull((Object)clientInfo);
    }

    @Test
    public void testSingleSuccess() throws Exception {
        this.initTest("/net/shibboleth/oidc/metadata/impl/oidc-client.json");
        ClientIDCriterion criterion = new ClientIDCriterion(new ClientID(this.clientId));
        OIDCClientInformation clientInfo = this.resolver.resolveSingle(new CriteriaSet(new Criterion[]{criterion}));
        Assert.assertNotNull((Object)clientInfo);
        Assert.assertEquals((String)clientInfo.getID().getValue(), (String)this.clientId);
        Set redirectUris = clientInfo.getOIDCMetadata().getRedirectionURIs();
        Assert.assertEquals((int)redirectUris.size(), (int)1);
        Assert.assertTrue((boolean)redirectUris.contains(this.redirectUri));
        FilesystemClientInformationResolverTest.testScope(clientInfo.getOIDCMetadata().getScope());
        Set responseTypes = clientInfo.getOIDCMetadata().getResponseTypes();
        Assert.assertEquals((int)responseTypes.size(), (int)2);
        Assert.assertTrue((boolean)responseTypes.contains(new ResponseType(new ResponseType.Value[]{OIDCResponseTypeValue.ID_TOKEN})));
    }

    @Test
    public void testArraySuccess() throws Exception {
        this.initTest("/net/shibboleth/oidc/metadata/impl/oidc-clients.json");
        ClientIDCriterion criterion = new ClientIDCriterion(new ClientID(this.clientId2));
        OIDCClientInformation clientInfo = this.resolver.resolveSingle(new CriteriaSet(new Criterion[]{criterion}));
        Assert.assertNotNull((Object)clientInfo);
        Assert.assertEquals((String)clientInfo.getID().getValue(), (String)this.clientId2);
        Set redirectUris = clientInfo.getOIDCMetadata().getRedirectionURIs();
        Assert.assertEquals((int)redirectUris.size(), (int)1);
        Assert.assertTrue((boolean)redirectUris.contains(this.redirectUri2));
        FilesystemClientInformationResolverTest.testScope(clientInfo.getOIDCMetadata().getScope());
        Set responseTypes = clientInfo.getOIDCMetadata().getResponseTypes();
        Assert.assertEquals((int)responseTypes.size(), (int)2);
        Assert.assertTrue((boolean)responseTypes.contains(new ResponseType(new ResponseType.Value[]{OIDCResponseTypeValue.ID_TOKEN})));
    }

    protected static void testScope(Scope scope) {
        Assert.assertEquals((int)scope.size(), (int)6);
        Assert.assertTrue((boolean)scope.contains((Object)OIDCScopeValue.OPENID));
        Assert.assertTrue((boolean)scope.contains((Object)OIDCScopeValue.ADDRESS));
        Assert.assertTrue((boolean)scope.contains((Object)OIDCScopeValue.EMAIL));
        Assert.assertTrue((boolean)scope.contains((Object)OIDCScopeValue.PHONE));
        Assert.assertTrue((boolean)scope.contains((Object)OIDCScopeValue.PROFILE));
        Assert.assertTrue((boolean)scope.contains("info"));
    }
}

