/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.oidc.metadata.impl;

import net.shibboleth.oidc.metadata.criterion.ClientSecretReferenceCriterion;
import net.shibboleth.oidc.metadata.impl.AbstractClientSecretValueResolver;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.DestroyedComponentException;
import net.shibboleth.utilities.java.support.component.UninitializedComponentException;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import net.shibboleth.utilities.java.support.resolver.Criterion;
import net.shibboleth.utilities.java.support.resolver.ResolverException;
import org.testng.annotations.Test;

public abstract class BaseClientSecretValueResolverTest<T extends AbstractClientSecretValueResolver> {
    T resolver;

    @Test(expectedExceptions={UninitializedComponentException.class})
    public void resolveSingle_shouldThrowIfCalledBeforeInit() throws ResolverException, ComponentInitializationException {
        this.resolver = this.buildResolver(false);
        this.resolver.resolveSingle((Object)this.buildCriteriaSet("ignored"));
    }

    @Test(expectedExceptions={DestroyedComponentException.class})
    public void resolveSingle_shouldThrowIfCalledAfterDestroy() throws ResolverException, ComponentInitializationException {
        this.resolver = this.buildResolver(true);
        this.resolver.destroy();
        this.resolver.resolveSingle((Object)this.buildCriteriaSet("ignored"));
    }

    @Test(expectedExceptions={UninitializedComponentException.class})
    public void resolve_shouldThrowIfCalledBeforeInit() throws ResolverException, ComponentInitializationException {
        this.resolver = this.buildResolver(false);
        this.resolver.resolve((Object)this.buildCriteriaSet("ignored"));
    }

    @Test(expectedExceptions={DestroyedComponentException.class})
    public void resolve_shouldThrowIfCalledAfterDestroy() throws ResolverException, ComponentInitializationException {
        this.resolver = this.buildResolver(true);
        this.resolver.destroy();
        this.resolver.resolve((Object)this.buildCriteriaSet("ignored"));
    }

    protected CriteriaSet buildCriteriaSet(String secretReference) {
        ClientSecretReferenceCriterion criterion = new ClientSecretReferenceCriterion(secretReference);
        return new CriteriaSet(new Criterion[]{criterion});
    }

    protected abstract T buildResolver(boolean var1) throws ComponentInitializationException;
}

