/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.oidc.metadata.cache.impl;

import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Delayed;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.Nonnull;

public class ScheduledTask<T>
implements ScheduledFuture<T> {
    private final Callable<T> callable;
    private final long delay;
    private final long period;
    private final CompletableFuture<T> result;

    public ScheduledTask(Callable<T> callable, long delay) {
        this(callable, delay, 0L);
    }

    public ScheduledTask(Callable<T> callable, long delay, long period) {
        this.callable = Objects.requireNonNull(callable);
        this.result = new CompletableFuture();
        this.delay = delay;
        this.period = period;
    }

    public boolean isPeriodic() {
        return this.period > 0L;
    }

    public void execute() {
        if (!this.result.isDone()) {
            if (!this.isPeriodic()) {
                try {
                    this.result.complete(this.callable.call());
                }
                catch (Exception e) {
                    this.result.completeExceptionally(e);
                }
            } else {
                try {
                    this.callable.call();
                }
                catch (Exception e) {
                    this.result.completeExceptionally(e);
                }
            }
        }
    }

    @Override
    public long getDelay(TimeUnit unit) {
        return unit.convert(this.delay, TimeUnit.MILLISECONDS);
    }

    @Override
    public int compareTo(Delayed o) {
        return Long.compare(this.getDelay(TimeUnit.MILLISECONDS), o.getDelay(TimeUnit.MILLISECONDS));
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        return this.result.cancel(mayInterruptIfRunning);
    }

    @Override
    public boolean isCancelled() {
        return this.result.isCancelled();
    }

    @Override
    public boolean isDone() {
        return this.result.isDone();
    }

    @Override
    public T get() throws InterruptedException, ExecutionException {
        return this.result.get();
    }

    @Override
    public T get(long timeout, @Nonnull TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.result.get(timeout, unit);
    }

    public Callable<T> getCallable() {
        return this.callable;
    }
}

