/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.oidc.metadata.cache.impl;

import java.io.IOException;
import java.time.Duration;
import java.time.Instant;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import net.shibboleth.ext.spring.util.AnnotationParameterNameDiscoverer;
import net.shibboleth.oidc.metadata.cache.CacheLoadingContext;
import net.shibboleth.oidc.metadata.cache.LoadingStrategy;
import net.shibboleth.oidc.metadata.cache.impl.BatchMetadataCacheBuilderSpec;
import net.shibboleth.oidc.metadata.cache.impl.MetadataPolicyLookupStrategyFactory;
import net.shibboleth.oidc.metadata.policy.MetadataPolicy;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import org.springframework.context.support.GenericXmlApplicationContext;
import org.springframework.core.ParameterNameDiscoverer;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class MetadataPolicyLookupStrategyFactoryTest {
    private MetadataPolicyLookupStrategyFactory factory;
    private BatchMetadataCacheBuilderSpec<String, Map<String, MetadataPolicy>> spec;

    @BeforeMethod
    public void setup() {
        this.factory = new MetadataPolicyLookupStrategyFactory();
        this.spec = new BatchMetadataCacheBuilderSpec();
        this.spec.setIdentifierExtractionStrategy(key -> "");
        this.spec.setMinRefreshDelay(Duration.ofMinutes(5L));
        this.spec.setMaxRefreshDelay(Duration.ofMinutes(10L));
        this.spec.setSourceMetadataExpiryStrategy(b -> Instant.now().plus(Duration.ofMinutes(5L)));
        this.spec.setCriteriaToIdentifierStrategy(crit -> "");
        this.spec.setCacheId("Mock Batch Cache");
        this.spec.setRefreshDelayFactor(Float.valueOf(0.75f));
        this.spec.setMetadataFilterStrategy((metadata, context) -> metadata);
        this.spec.setLoadingStrategy(new LoadingStrategy(){

            public byte[] load(CacheLoadingContext t) {
                return "test".getBytes();
            }

            public String getSourceIdentifier() {
                return "Mock loading source";
            }
        });
        this.spec.setParsingStrategy(bytesIn -> Collections.emptyList());
    }

    @Test
    public void testFactoryBuild_FileBased_Success() throws ComponentInitializationException, IOException {
        Function createdFunction = this.factory.buildFileLoadingMetadataPolicyResolver(null, this.spec, null, "Mock");
        Assert.assertNotNull((Object)createdFunction);
    }

    @Test
    public void testXMLDefinitionLoads() {
        GenericXmlApplicationContext context = new GenericXmlApplicationContext();
        context.load(new String[]{"net/shibboleth/oidc/metadata/impl/metadata-policy-lookup-strategy-factory-test.xml"});
        context.getDefaultListableBeanFactory().setParameterNameDiscoverer((ParameterNameDiscoverer)new AnnotationParameterNameDiscoverer());
        context.refresh();
        Assert.assertNotNull((Object)context.getId());
        Object stratOne = context.getBean("shibboleth.oidc.test.MetadataPolicyLookupStrategyOne");
        Assert.assertNotNull((Object)stratOne);
        Object stratTwo = context.getBean("shibboleth.oidc.test.MetadataPolicyLookupStrategyTwo");
        Assert.assertNotNull((Object)stratTwo);
        context.close();
    }
}

