/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.oidc.metadata.cache.impl;

import com.google.common.base.Predicates;
import com.nimbusds.oauth2.sdk.as.AuthorizationServerMetadata;
import com.nimbusds.oauth2.sdk.id.Issuer;
import com.nimbusds.openid.connect.sdk.SubjectType;
import com.nimbusds.openid.connect.sdk.op.OIDCProviderMetadata;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.shibboleth.oidc.metadata.cache.MetadataCacheException;
import net.shibboleth.oidc.metadata.cache.impl.FetchThroughMetadataCache;
import net.shibboleth.oidc.metadata.criterion.IssuerIDCriterion;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import net.shibboleth.utilities.java.support.resolver.Criterion;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class FetchThroughMetadataCacheTest {
    private FetchThroughMetadataCache<Issuer, OIDCProviderMetadata> cache;
    @Nonnull
    private Function<CriteriaSet, OIDCProviderMetadata> defaultFetchStrategy;

    @BeforeMethod
    void setup() throws Exception {
        this.defaultFetchStrategy = crit -> {
            try {
                return new OIDCProviderMetadata(new Issuer("https://op.example.com"), List.of(SubjectType.PUBLIC), new URI("https://op.example.com/metadata"));
            }
            catch (URISyntaxException e) {
                return null;
            }
        };
        this.cache = new FetchThroughMetadataCache();
        this.cache.setFetchStrategy(this.defaultFetchStrategy);
        this.cache.setIdentifierExtractionStrategy(AuthorizationServerMetadata::getIssuer);
        this.cache.setCriteriaToIdentifierStrategy(crit -> {
            IssuerIDCriterion issuerId = (IssuerIDCriterion)crit.get(IssuerIDCriterion.class);
            if (issuerId != null) {
                return issuerId.getIssuerID();
            }
            return null;
        });
        this.cache.setRefreshDelayFactor(Float.valueOf(0.75f));
        this.cache.setMetadataValidPredicate((Predicate)Predicates.alwaysTrue());
        this.cache.setMetadataFilterStrategy((metadata, context) -> metadata);
        this.cache.setId("MockCache");
    }

    @Test
    public void testSuccessfullFetch() throws Exception {
        this.cache.initialize();
        Issuer iss = new Issuer("https://op.example.com");
        List metadata = this.cache.get(new CriteriaSet(new Criterion[]{new IssuerIDCriterion(iss)}));
        Assert.assertEquals((int)metadata.size(), (int)1);
        Assert.assertTrue((boolean)((OIDCProviderMetadata)metadata.get(0)).getIssuer().equals((Object)iss));
    }

    @Test(expectedExceptions={MetadataCacheException.class})
    public void testNotInitialized() throws Exception {
        Issuer iss = new Issuer("https://not-op.example.com");
        this.cache.get(new CriteriaSet(new Criterion[]{new IssuerIDCriterion(iss)}));
    }

    @Test
    public void testUnSuccessfullFetch() throws Exception {
        this.cache.initialize();
        Issuer iss = new Issuer("https://not-op.example.com");
        List metadata = this.cache.get(new CriteriaSet(new Criterion[]{new IssuerIDCriterion(iss)}));
        Assert.assertEquals((int)metadata.size(), (int)0);
    }

    @Test
    public void testFilteredMetadata() throws Exception {
        this.cache.setMetadataFilterStrategy((metadata, context) -> null);
        this.cache.initialize();
        Issuer iss = new Issuer("https://op.example.com");
        List metadata2 = this.cache.get(new CriteriaSet(new Criterion[]{new IssuerIDCriterion(iss)}));
        Assert.assertEquals((int)metadata2.size(), (int)0);
    }

    @Test
    public void testIdentifierExtractionFailed() throws Exception {
        this.cache.setIdentifierExtractionStrategy(metadata -> null);
        this.cache.initialize();
        Issuer iss = new Issuer("https://op.example.com");
        List metadata2 = this.cache.get(new CriteriaSet(new Criterion[]{new IssuerIDCriterion(iss)}));
        Assert.assertEquals((int)metadata2.size(), (int)0);
    }

    @Test
    public void testCriteriaToIdentifierNull() throws Exception {
        this.cache.setCriteriaToIdentifierStrategy(c -> null);
        this.cache.initialize();
        Issuer iss = new Issuer("https://op.example.com");
        List metadata = this.cache.get(new CriteriaSet(new Criterion[]{new IssuerIDCriterion(iss)}));
        Assert.assertEquals((int)metadata.size(), (int)0);
    }

    @Test
    public void testMetadataNotValid() throws Exception {
        this.cache.setMetadataValidPredicate(m -> false);
        this.cache.initialize();
        Issuer iss = new Issuer("https://op.example.com");
        List metadata = this.cache.get(new CriteriaSet(new Criterion[]{new IssuerIDCriterion(iss)}));
        Assert.assertEquals((int)metadata.size(), (int)0);
    }
}

