/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.oidc.metadata.cache.impl;

import com.google.common.io.ByteStreams;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.List;
import net.shibboleth.oidc.metadata.cache.impl.DefaultOIDCProviderMetadataParsingStrategy;
import org.springframework.core.io.ClassPathResource;
import org.testng.Assert;
import org.testng.annotations.Test;

public class DefaultOIDCProviderMetadataParsingStrategyTest {
    @Test
    public void testParsing_Success() throws IOException {
        DefaultOIDCProviderMetadataParsingStrategy strategy = new DefaultOIDCProviderMetadataParsingStrategy();
        ClassPathResource metadata = new ClassPathResource("/net/shibboleth/oidc/metadata/impl/openid-configuration.json");
        byte[] metadataAsBytes = ByteStreams.toByteArray((InputStream)metadata.getInputStream());
        List metadataParsed = strategy.apply(metadataAsBytes);
        Assert.assertNotNull((Object)metadataParsed);
        Assert.assertEquals((int)metadataParsed.size(), (int)1);
    }

    @Test
    public void testParsing_BadJson_Fail() throws IOException {
        DefaultOIDCProviderMetadataParsingStrategy strategy = new DefaultOIDCProviderMetadataParsingStrategy();
        byte[] metadataAsBytes = "bad json".getBytes(StandardCharsets.UTF_8);
        List metadataParsed = strategy.apply(metadataAsBytes);
        Assert.assertNotNull((Object)metadataParsed);
        Assert.assertEquals((int)metadataParsed.size(), (int)0);
    }

    @Test
    public void testParsing_NullBytes_Success() throws IOException {
        DefaultOIDCProviderMetadataParsingStrategy strategy = new DefaultOIDCProviderMetadataParsingStrategy();
        List metadataParsed = strategy.apply(null);
        Assert.assertNotNull((Object)metadataParsed);
        Assert.assertEquals((int)metadataParsed.size(), (int)0);
    }
}

