/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.oidc.metadata.cache.impl;

import com.google.common.base.Predicates;
import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.as.AuthorizationServerMetadata;
import com.nimbusds.oauth2.sdk.id.Issuer;
import com.nimbusds.openid.connect.sdk.SubjectType;
import com.nimbusds.openid.connect.sdk.op.OIDCProviderMetadata;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.time.Duration;
import java.time.Instant;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Predicate;
import net.shibboleth.oidc.metadata.BatchBackingStore;
import net.shibboleth.oidc.metadata.cache.CacheLoadingContext;
import net.shibboleth.oidc.metadata.cache.LoadingStrategy;
import net.shibboleth.oidc.metadata.cache.MetadataCacheException;
import net.shibboleth.oidc.metadata.cache.impl.BatchMetadataCache;
import net.shibboleth.oidc.metadata.cache.impl.ManuallyTriggeredScheduledExecutorService;
import net.shibboleth.oidc.metadata.criterion.IssuerIDCriterion;
import net.shibboleth.oidc.metadata.impl.DefaultBatchBackingStore;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import net.shibboleth.utilities.java.support.resolver.Criterion;
import org.opensaml.core.criterion.EntityIdCriterion;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class BatchMetadataCacheTest {
    private BatchMetadataCache<Issuer, OIDCProviderMetadata> cache;
    private ManuallyTriggeredScheduledExecutorService scheduler;
    private LoadingStrategy defaultLoadingStrategy;
    private Function<byte[], List<OIDCProviderMetadata>> defaultParsingStrategy;

    @BeforeMethod
    void setup() throws Exception {
        this.defaultLoadingStrategy = new LoadingStrategy(){

            public byte[] load(CacheLoadingContext t) {
                try {
                    return new OIDCProviderMetadata(new Issuer("http://www.example.org"), List.of(SubjectType.PUBLIC), new URI("http://www.example.org/metadata")).toJSONObject().toJSONString().getBytes();
                }
                catch (URISyntaxException e) {
                    return null;
                }
            }

            public String getSourceIdentifier() {
                return "Mock loading source";
            }
        };
        this.defaultParsingStrategy = in -> {
            try {
                return List.of(OIDCProviderMetadata.parse((String)new String((byte[])in, "UTF-8")));
            }
            catch (ParseException | UnsupportedEncodingException e) {
                return null;
            }
        };
        this.scheduler = new ManuallyTriggeredScheduledExecutorService();
        this.cache = new BatchMetadataCache((BatchBackingStore)new DefaultBatchBackingStore(), (ScheduledExecutorService)this.scheduler);
        this.cache.setSourceMetadataExpiryStrategy(b -> Instant.now().plus(Duration.ofMinutes(5L)));
        this.cache.setParsingStrategy(this.defaultParsingStrategy);
        this.cache.setLoadingStrategy(this.defaultLoadingStrategy);
        this.cache.setIdentifierExtractionStrategy(AuthorizationServerMetadata::getIssuer);
        this.cache.setMinRefreshDelay(Duration.ofMinutes(5L));
        this.cache.setMaxRefreshDelay(Duration.ofMinutes(10L));
        this.cache.setCriteriaToIdentifierStrategy(crit -> {
            IssuerIDCriterion issuerId = (IssuerIDCriterion)crit.get(IssuerIDCriterion.class);
            if (issuerId != null) {
                return issuerId.getIssuerID();
            }
            return null;
        });
        this.cache.setRefreshDelayFactor(Float.valueOf(0.75f));
        this.cache.setMetadataFilterStrategy((metadata, context) -> metadata);
        this.cache.setMetadataValidPredicate((Predicate)Predicates.alwaysTrue());
        this.cache.setSourceMetadataValidPredicate((Predicate)Predicates.alwaysTrue());
        this.cache.setId("MockRefreshableCache");
    }

    @AfterMethod
    public void tearDown() {
        if (this.cache != null) {
            this.cache.destroy();
        }
    }

    @Test(enabled=false)
    public void testNormalRefreshDelay() throws ComponentInitializationException, InterruptedException {
        BatchMetadataCache localCache = new BatchMetadataCache((BatchBackingStore)new DefaultBatchBackingStore());
        localCache.setParsingStrategy(this.defaultParsingStrategy);
        localCache.setLoadingStrategy(this.defaultLoadingStrategy);
        localCache.setSourceMetadataExpiryStrategy(b -> Instant.now().plus(Duration.ofSeconds(1L)));
        localCache.setIdentifierExtractionStrategy(AuthorizationServerMetadata::getIssuer);
        localCache.setMinRefreshDelay(Duration.ofMillis(100L));
        localCache.setMaxRefreshDelay(Duration.ofMillis(200L));
        localCache.setSourceMetadataValidPredicate((Predicate)Predicates.alwaysTrue());
        localCache.setCriteriaToIdentifierStrategy(crit -> {
            IssuerIDCriterion issuerId = (IssuerIDCriterion)crit.get(IssuerIDCriterion.class);
            if (issuerId != null) {
                return issuerId.getIssuerID();
            }
            return null;
        });
        localCache.setRefreshDelayFactor(Float.valueOf(0.75f));
        localCache.setMetadataFilterStrategy((metadata, context) -> metadata);
        localCache.setMetadataValidPredicate((Predicate)Predicates.alwaysTrue());
        localCache.setId("MockLocalRefreshableCache");
        localCache.initialize();
        Thread.sleep(2000L);
    }

    @Test
    public void testGetWithNullReturnFromLoadingStrategy() throws Exception {
        LoadingStrategy simpleLoadingStrategy = new LoadingStrategy(){

            public byte[] load(CacheLoadingContext t) {
                return null;
            }

            public String getSourceIdentifier() {
                return "Mock loading source";
            }
        };
        Function<byte[], List> simpleParsingStrategy = in -> null;
        this.cache.setParsingStrategy(simpleParsingStrategy);
        this.cache.setLoadingStrategy(simpleLoadingStrategy);
        this.cache.initialize();
        List allMetadata = this.cache.get(new CriteriaSet(new Criterion[]{new IssuerIDCriterion(new Issuer("http://entityid.com"))}));
        Assert.assertEquals((int)allMetadata.size(), (int)0);
    }

    @Test
    public void testFetchAllNoDirectMatch() throws ComponentInitializationException, InterruptedException, MetadataCacheException {
        LoadingStrategy simpleLoadingStrategy = new LoadingStrategy(){

            public byte[] load(CacheLoadingContext t) {
                return "".getBytes();
            }

            public String getSourceIdentifier() {
                return "Mock loading source";
            }
        };
        Function<byte[], List> simpleParsingStrategy = in -> {
            try {
                return List.of(new OIDCProviderMetadata(new Issuer("http://www.example.one.org"), List.of(SubjectType.PUBLIC), new URI("http://example.one.oidc.op.org")), new OIDCProviderMetadata(new Issuer("http://www.example.two.org"), List.of(SubjectType.PUBLIC), new URI("http://example.two.oidc.op.org")));
            }
            catch (URISyntaxException e) {
                return null;
            }
        };
        BatchMetadataCache localCache = new BatchMetadataCache((BatchBackingStore)new DefaultBatchBackingStore(), (ScheduledExecutorService)this.scheduler);
        localCache.setParsingStrategy(simpleParsingStrategy);
        localCache.setLoadingStrategy(simpleLoadingStrategy);
        localCache.setSourceMetadataExpiryStrategy(b -> Instant.now().plus(Duration.ofMinutes(5L)));
        localCache.setIdentifierExtractionStrategy(AuthorizationServerMetadata::getIssuer);
        localCache.setMinRefreshDelay(Duration.ofMillis(100L));
        localCache.setMaxRefreshDelay(Duration.ofMillis(200L));
        localCache.setCriteriaToIdentifierStrategy(crit -> {
            IssuerIDCriterion issuerId = (IssuerIDCriterion)crit.get(IssuerIDCriterion.class);
            if (issuerId != null) {
                return issuerId.getIssuerID();
            }
            return null;
        });
        localCache.setRefreshDelayFactor(Float.valueOf(0.75f));
        localCache.setMetadataFilterStrategy((metadata, context) -> metadata);
        localCache.setMetadataValidPredicate((Predicate)Predicates.alwaysTrue());
        localCache.setSourceMetadataValidPredicate((Predicate)Predicates.alwaysTrue());
        localCache.setId("MockLocalRefreshableCache");
        localCache.setMatchOnIdentifierRequired(false);
        localCache.initialize();
        List allMetadata = localCache.get(new CriteriaSet(new Criterion[]{new EntityIdCriterion("http://entityid.com")}));
        Assert.assertEquals((int)allMetadata.size(), (int)2);
    }

    @Test(expectedExceptions={ComponentInitializationException.class})
    public void testInitialLoadFails() throws ComponentInitializationException, MetadataCacheException {
        this.cache.setLoadingStrategy(new LoadingStrategy(){

            public byte[] load(CacheLoadingContext t) {
                throw new RuntimeException("Could not load metadata");
            }

            public String getSourceIdentifier() {
                return "Mock loading source";
            }
        });
        this.cache.setSourceMetadataExpiryStrategy(b -> {
            throw new NullPointerException("Input bytes are null!");
        });
        this.cache.initialize();
    }

    @Test
    public void testMetadataExpiryBelowMinDelay_UseMinDelay() throws Exception {
        this.cache.setMinRefreshDelay(Duration.ofMinutes(10L));
        this.cache.setSourceMetadataExpiryStrategy(b -> Instant.now().plus(Duration.ofMinutes(1L)));
        this.cache.setRefreshDelayFactor(Float.valueOf(0.99f));
        this.cache.initialize();
        Assert.assertTrue((boolean)(this.cache.getExecutorService() instanceof ManuallyTriggeredScheduledExecutorService));
        ManuallyTriggeredScheduledExecutorService manSchedular = (ManuallyTriggeredScheduledExecutorService)this.cache.getExecutorService();
        Assert.assertNotNull(manSchedular.getAllScheduledTasks());
        Assert.assertEquals((int)manSchedular.getAllScheduledTasks().size(), (int)1);
        long delay = manSchedular.getAllScheduledTasks().get(0).getDelay(TimeUnit.SECONDS);
        if (delay <= 590L || delay >= 610L) {
            Assert.fail();
        }
    }

    @Test
    public void testMetadataExpiryGreaterThanMin_UseMetadataDelay() throws ComponentInitializationException, MetadataCacheException {
        this.cache.setMinRefreshDelay(Duration.ofMinutes(10L));
        this.cache.setRefreshDelayFactor(Float.valueOf(0.99f));
        this.cache.setSourceMetadataExpiryStrategy(b -> Instant.now().plus(Duration.ofMinutes(20L)));
        this.cache.initialize();
        Assert.assertTrue((boolean)(this.cache.getExecutorService() instanceof ManuallyTriggeredScheduledExecutorService));
        ManuallyTriggeredScheduledExecutorService manSchedular = (ManuallyTriggeredScheduledExecutorService)this.cache.getExecutorService();
        Assert.assertNotNull(manSchedular.getAllScheduledTasks());
        Assert.assertEquals((int)manSchedular.getAllScheduledTasks().size(), (int)1);
        long delay = manSchedular.getAllScheduledTasks().get(0).getDelay(TimeUnit.SECONDS);
        if (delay <= 1100L || delay >= 1300L) {
            Assert.fail();
        }
    }

    @Test
    public void testMetadataExpiryIsBeforeNow_UseMaxDelay() throws ComponentInitializationException, MetadataCacheException {
        this.cache.setMaxRefreshDelay(Duration.ofMinutes(10L));
        this.cache.setRefreshDelayFactor(Float.valueOf(0.99f));
        this.cache.setSourceMetadataExpiryStrategy(b -> Instant.now().minus(Duration.ofMinutes(20L)));
        this.cache.initialize();
        Assert.assertTrue((boolean)(this.cache.getExecutorService() instanceof ManuallyTriggeredScheduledExecutorService));
        ManuallyTriggeredScheduledExecutorService manSchedular = (ManuallyTriggeredScheduledExecutorService)this.cache.getExecutorService();
        Assert.assertNotNull(manSchedular.getAllScheduledTasks());
        Assert.assertEquals((int)manSchedular.getAllScheduledTasks().size(), (int)1);
        long delay = manSchedular.getAllScheduledTasks().get(0).getDelay(TimeUnit.SECONDS);
        if (delay <= 590L || delay >= 610L) {
            Assert.fail();
        }
    }

    @Test
    public void testNoUsableIdentifierInCriteria_EmptyList() throws Exception {
        this.cache.initialize();
        List metadata = this.cache.get(new CriteriaSet(new Criterion[]{new EntityIdCriterion("http://entityid.com")}));
        Assert.assertTrue((metadata.isEmpty() ? 1 : 0) != 0);
    }

    @Test
    public void testGetNotCached_Success() throws Exception {
        this.cache.initialize();
        List metadata = this.cache.get(new CriteriaSet(new Criterion[]{new IssuerIDCriterion(new Issuer("http://www.example.org"))}));
        Assert.assertTrue((!metadata.isEmpty() ? 1 : 0) != 0);
    }

    @Test
    public void testSourceNotValid_Success() throws ComponentInitializationException, MetadataCacheException {
        this.cache.setSourceMetadataValidPredicate((Predicate)Predicates.alwaysFalse());
        this.cache.initialize();
        List metadata = this.cache.get(new CriteriaSet(new Criterion[]{new IssuerIDCriterion(new Issuer("http://www.example.org"))}));
        Assert.assertTrue((metadata.isEmpty() ? 1 : 0) != 0);
    }

    @Test
    public void testSourceNotValidMetadaNotValid_EntryAllreadyExist_Success() throws Exception {
        Issuer iss = new Issuer("http://www.example.org");
        this.cache.getBackingStore().getIndexedValues().put(iss, List.of(new OIDCProviderMetadata(new Issuer("http://www.example.org"), List.of(SubjectType.PUBLIC), new URI("http://www.example.org/metadata"))));
        this.cache.setSourceMetadataValidPredicate((Predicate)Predicates.alwaysFalse());
        this.cache.setMetadataValidPredicate((Predicate)Predicates.alwaysFalse());
        this.cache.initialize();
        List metadata = this.cache.get(new CriteriaSet(new Criterion[]{new IssuerIDCriterion(iss)}));
        Assert.assertTrue((metadata.isEmpty() ? 1 : 0) != 0);
    }

    @Test
    public void testGetNotCached_RefreshAHead_Success() throws MetadataCacheException, ComponentInitializationException {
        this.cache.initialize();
        this.scheduler.triggerScheduledTasks();
        List metadata = this.cache.get(new CriteriaSet(new Criterion[]{new IssuerIDCriterion(new Issuer("http://www.example.org"))}));
        Assert.assertTrue((!metadata.isEmpty() ? 1 : 0) != 0);
    }

    @Test(enabled=false)
    public void testLoadGetRaceCondition() throws Exception {
        this.cache.initialize();
        ExecutorService service = Executors.newFixedThreadPool(3);
        Future<List> futureTwo = service.submit(() -> this.cache.get(new CriteriaSet(new Criterion[]{new IssuerIDCriterion(new Issuer("http://www.example.org"))})));
        Future<List> futureThree = service.submit(() -> this.cache.get(new CriteriaSet(new Criterion[]{new IssuerIDCriterion(new Issuer("http://www.example.org"))})));
        Future<?> futureOne = service.submit(() -> {
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.scheduler.triggerScheduledTasks();
        });
        Thread.sleep(10000L);
    }

    @Test
    public void testGetAndLoad_Success() throws Exception {
        this.cache.initialize();
        ExecutorService service = Executors.newFixedThreadPool(3);
        Future<List> futureOne = service.submit(() -> this.cache.get(new CriteriaSet(new Criterion[]{new IssuerIDCriterion(new Issuer("http://www.example.org"))})));
        this.scheduler.triggerScheduledTasks();
        List firstMetadata = futureOne.get();
        Assert.assertTrue((firstMetadata.size() == 1 ? 1 : 0) != 0);
    }
}

