/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.oidc.metadata;

import java.time.Instant;
import java.util.concurrent.locks.StampedLock;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.utilities.java.support.logic.Constraint;

public class MetadataManagementData<MetadataIdentifier> {
    @Nonnull
    private final MetadataIdentifier id;
    @Nullable
    private Instant lastUpdateTime;
    private Instant expirationTime;
    private Instant refreshTriggerTime;
    private Instant lastAccessedTime;
    private final StampedLock stmpLock;

    public MetadataManagementData(@Nonnull MetadataIdentifier identifier) {
        Instant now;
        this.id = Constraint.isNotNull(identifier, (String)"ID was null");
        this.lastAccessedTime = now = Instant.now();
        this.stmpLock = new StampedLock();
    }

    @Nonnull
    public MetadataIdentifier getID() {
        return this.id;
    }

    @Nullable
    public Instant getLastUpdateTime() {
        return this.lastUpdateTime;
    }

    public void setLastUpdateTime(@Nonnull Instant dateTime) {
        this.lastUpdateTime = dateTime;
    }

    @Nullable
    public Instant getExpirationTime() {
        return this.expirationTime;
    }

    public void setExpirationTime(@Nonnull Instant dateTime) {
        this.expirationTime = (Instant)Constraint.isNotNull((Object)dateTime, (String)"Expiration time may not be null");
    }

    @Nullable
    public Instant getRefreshTriggerTime() {
        return this.refreshTriggerTime;
    }

    public void setRefreshTriggerTime(@Nonnull Instant dateTime) {
        this.refreshTriggerTime = (Instant)Constraint.isNotNull((Object)dateTime, (String)"Refresh trigger time may not be null");
    }

    @Nullable
    public Instant getLastAccessedTime() {
        return this.lastAccessedTime;
    }

    public void recordEntityAccess() {
        this.lastAccessedTime = Instant.now();
    }

    @Nonnull
    public StampedLock getStampLock() {
        return this.stmpLock;
    }
}

