/*
 * Licensed to the University Corporation for Advanced Internet Development,
 * Inc. (UCAID) under one or more contributor license agreements.  See the
 * NOTICE file distributed with this work for additional information regarding
 * copyright ownership. The UCAID licenses this file to You under the Apache
 * License, Version 2.0 (the "License"); you may not use this file except in
 * compliance with the License.  You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.shibboleth.oidc.metadata;

import java.time.Instant;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.nimbusds.oauth2.sdk.client.ClientInformation;
import com.nimbusds.oauth2.sdk.id.ClientID;
import com.nimbusds.openid.connect.sdk.rp.OIDCClientInformation;

/**
 * A manager that is capable of managing {@link ClientInformation} instances.
 */
public interface ClientInformationManager {

    /**
     * Store a {@link ClientInformation} object.
     * 
     * <p>This method is deprecated, and is equivalent to calling the replacement method
     * with replace set to false.</p>
     * 
     * @param clientInformation The client information to be stored
     * @param expiration The expiration for record, or null
     * 
     * @throws ClientInformationManagerException If the client information cannot be stored.
     * 
     * @deprecated
     */
    @Deprecated(since="1.2.0", forRemoval=true)
    @Nonnull void storeClientInformation(@Nonnull final OIDCClientInformation clientInformation, 
            @Nullable final Instant expiration) throws ClientInformationManagerException;

    /**
     * Store a {@link ClientInformation} object.
     * 
     * @param clientInformation The client information to be stored
     * @param expiration The expiration for record, or null
     * @param replace whether to replace an existing entry
     * 
     * @throws ClientInformationManagerException If the client information cannot be stored.
     */
    @Nonnull default void storeClientInformation(@Nonnull final OIDCClientInformation clientInformation, 
            @Nullable final Instant expiration, final boolean replace) throws ClientInformationManagerException {
        storeClientInformation(clientInformation, expiration);
    }
    
    /**
     * Invalidates or otherwise removes a {@link ClientInformation} from persistent storage.
     * 
     * @param clientId the unique ID of the client information to destroy.
     * @throws ClientInformationManagerException If the client information cannot be destroyed.
     */
    void destroyClientInformation(@Nonnull final ClientID clientId) throws ClientInformationManagerException;
    
}