/*
 * Licensed to the University Corporation for Advanced Internet Development,
 * Inc. (UCAID) under one or more contributor license agreements.  See the
 * NOTICE file distributed with this work for additional information regarding
 * copyright ownership. The UCAID licenses this file to You under the Apache
 * License, Version 2.0 (the "License"); you may not use this file except in
 * compliance with the License.  You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.shibboleth.oidc.metadata;

import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;

/**
 * A backing store that holds cached objects.
 * 
 * @param <I> the identifier type
 * @param <T> the type of object stored, referenced by the key.
 */
public interface BackingStore<I, T> {
    
    /**
     * Get the index - mapping keys to values. 
     * 
     * @return the index.
     */
    @Nonnull Map<I, List<T>> getIndexedValues();
    
    /**
     * Get the list of ordered values.
     * 
     * @return the list of ordered values.
     */
    @Nonnull List<T> getOrderedValues();
    
    
    
    

}
