/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.profile.impl;

import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.shibboleth.idp.plugin.oidc.op.messaging.context.OIDCAuthenticationResponseConsentContext;
import net.shibboleth.idp.plugin.oidc.op.profile.context.navigate.TokenRequestConsentedAttributesLookupFunction;
import net.shibboleth.idp.plugin.oidc.op.profile.impl.AbstractOIDCResponseAction;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SetConsentFromTokenToResponseContext
extends AbstractOIDCResponseAction {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(SetConsentFromTokenToResponseContext.class);
    @Nonnull
    private Function<ProfileRequestContext, List<Object>> consentedAttributesLookupStrategy = new TokenRequestConsentedAttributesLookupFunction();

    public void setConsentedAttributesLookupStrategy(@Nonnull Function<ProfileRequestContext, List<Object>> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.consentedAttributesLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Lookup strategy cannot be null");
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        List<Object> consentedAttributes = this.consentedAttributesLookupStrategy.apply(profileRequestContext);
        if (consentedAttributes != null) {
            OIDCAuthenticationResponseConsentContext consentClaimsCtx = (OIDCAuthenticationResponseConsentContext)this.getOidcResponseContext().getSubcontext(OIDCAuthenticationResponseConsentContext.class, true);
            consentClaimsCtx.getConsentedAttributes().addAll(consentedAttributes);
        }
    }
}

