/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.profile.impl;

import com.nimbusds.openid.connect.sdk.op.OIDCProviderMetadata;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.plugin.oidc.op.messaging.JSONSuccessResponse;
import net.shibboleth.idp.plugin.oidc.op.metadata.resolver.ProviderMetadataResolver;
import net.shibboleth.idp.profile.AbstractProfileAction;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullAfterInit;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.resolver.ResolverException;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FormOutboundDiscoveryResponse
extends AbstractProfileAction {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(FormOutboundDiscoveryResponse.class);
    @NonnullAfterInit
    private ProviderMetadataResolver metadataResolver;
    @Nullable
    private OIDCProviderMetadata metadata;

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.metadataResolver == null) {
            throw new ComponentInitializationException("The metadata resolver cannot be null!");
        }
    }

    public void setMetadataResolver(@Nonnull ProviderMetadataResolver resolver) {
        this.metadataResolver = (ProviderMetadataResolver)Constraint.isNotNull((Object)resolver, (String)"The metadata resolver cannot be null!");
    }

    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (!super.doPreExecute(profileRequestContext)) {
            return false;
        }
        try {
            this.metadata = (OIDCProviderMetadata)this.metadataResolver.resolveSingle((Object)profileRequestContext);
        }
        catch (ResolverException e) {
            this.log.error("{} Could not resolve provider metadata", (Object)this.getLogPrefix(), (Object)e);
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InputOutputError");
            return false;
        }
        if (this.metadata == null) {
            this.log.error("{} Could not resolve provider metadata", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InputOutputError");
            return false;
        }
        return true;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        profileRequestContext.getOutboundMessageContext().setMessage((Object)new JSONSuccessResponse(this.metadata.toJSONObject()));
    }
}

