/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.profile.logic;

import com.google.common.base.Predicates;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import net.shibboleth.ext.spring.testing.MockApplicationContext;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.StringAttributeValue;
import net.shibboleth.idp.attribute.context.AttributeContext;
import net.shibboleth.idp.attribute.transcoding.BasicNamingFunction;
import net.shibboleth.idp.attribute.transcoding.TranscodingRule;
import net.shibboleth.idp.attribute.transcoding.impl.AttributeTranscoderRegistryImpl;
import net.shibboleth.idp.plugin.oidc.op.profile.logic.AttributeResolutionSubjectLookupFunction;
import net.shibboleth.idp.profile.context.RelyingPartyContext;
import net.shibboleth.idp.profile.context.navigate.WebflowRequestContextProfileRequestContextLookup;
import net.shibboleth.idp.profile.testing.RequestContextBuilder;
import net.shibboleth.idp.saml.attribute.transcoding.AbstractSAML2AttributeTranscoder;
import net.shibboleth.idp.saml.attribute.transcoding.impl.SAML2StringAttributeTranscoder;
import net.shibboleth.oidc.attribute.transcoding.AbstractOIDCAttributeTranscoder;
import net.shibboleth.oidc.attribute.transcoding.impl.OIDCStringAttributeTranscoder;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.logic.ConstraintViolationException;
import net.shibboleth.utilities.java.support.service.ReloadableService;
import net.shibboleth.utilities.java.support.service.ServiceableComponent;
import net.shibboleth.utilities.java.support.test.service.MockReloadableService;
import org.opensaml.core.testing.OpenSAMLInitBaseTestCase;
import org.opensaml.messaging.context.BaseContext;
import org.opensaml.profile.context.ProfileRequestContext;
import org.springframework.context.ApplicationContext;
import org.springframework.webflow.execution.RequestContext;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class AttributeResolutionSubjectLookupFunctionTest
extends OpenSAMLInitBaseTestCase {
    private AttributeTranscoderRegistryImpl registry;
    private AttributeResolutionSubjectLookupFunction lookup;
    protected ProfileRequestContext prc;

    @BeforeMethod
    public void setup() throws ComponentInitializationException {
        this.registry = new AttributeTranscoderRegistryImpl();
        this.registry.setId("test");
        OIDCStringAttributeTranscoder transcoder = new OIDCStringAttributeTranscoder();
        transcoder.initialize();
        HashMap<String, String> rule1 = new HashMap<String, String>();
        rule1.put("id", "test1");
        rule1.put("transcoder", (String)transcoder);
        rule1.put("oidc.name", "test1");
        HashMap<String, String> rule2 = new HashMap<String, String>();
        rule2.put("id", "test2");
        rule2.put("transcoder", (String)transcoder);
        rule2.put("oidc.name", "sub");
        OIDCStringAttributeTranscoder offTranscoder = new OIDCStringAttributeTranscoder();
        offTranscoder.setActivationCondition((Predicate)Predicates.alwaysFalse());
        offTranscoder.initialize();
        HashMap<String, String> rule3 = new HashMap<String, String>();
        rule3.put("id", "test3");
        rule3.put("transcoder", (String)offTranscoder);
        rule3.put("oidc.name", "sub");
        SAML2StringAttributeTranscoder samlTranscoder = new SAML2StringAttributeTranscoder();
        samlTranscoder.initialize();
        HashMap<String, String> rule4 = new HashMap<String, String>();
        rule4.put("id", "test4");
        rule4.put("transcoder", (String)samlTranscoder);
        rule4.put("saml2.name", "sub");
        this.registry.setNamingRegistry(List.of(new BasicNamingFunction(transcoder.getEncodedType(), (Function)new AbstractOIDCAttributeTranscoder.NamingFunction()), new BasicNamingFunction(samlTranscoder.getEncodedType(), (Function)new AbstractSAML2AttributeTranscoder.NamingFunction())));
        IdPAttribute attribute1 = new IdPAttribute("test1");
        ArrayList<StringAttributeValue> stringAttributeValues1 = new ArrayList<StringAttributeValue>();
        stringAttributeValues1.add(new StringAttributeValue("value1"));
        stringAttributeValues1.add(new StringAttributeValue("value2"));
        attribute1.setValues(stringAttributeValues1);
        IdPAttribute attribute2 = new IdPAttribute("test2");
        ArrayList<StringAttributeValue> stringAttributeValues2 = new ArrayList<StringAttributeValue>();
        stringAttributeValues2.add(new StringAttributeValue("joe"));
        attribute2.setValues(stringAttributeValues2);
        this.registry.setTranscoderRegistry(List.of(new TranscodingRule(rule1), new TranscodingRule(rule2), new TranscodingRule(rule3), new TranscodingRule(rule4)));
        this.registry.setApplicationContext((ApplicationContext)new MockApplicationContext());
        this.registry.initialize();
        this.lookup = new AttributeResolutionSubjectLookupFunction();
        this.lookup.setTranscoderRegistry((ReloadableService)new MockReloadableService((ServiceableComponent)this.registry));
        RequestContext requestCtx = new RequestContextBuilder().buildRequestContext();
        this.prc = new WebflowRequestContextProfileRequestContextLookup().apply(requestCtx);
        AttributeContext attributeCtx = new AttributeContext();
        ArrayList<IdPAttribute> attributes = new ArrayList<IdPAttribute>();
        attributes.add(attribute1);
        attributes.add(attribute2);
        attributeCtx.setIdPAttributes(attributes);
        ((RelyingPartyContext)this.prc.getSubcontext(RelyingPartyContext.class, true)).addSubcontext((BaseContext)attributeCtx);
    }

    @AfterMethod
    public void tearDown() {
        this.registry.destroy();
        this.registry = null;
    }

    @Test
    public void testSuccess() {
        Assert.assertEquals((String)this.lookup.apply(this.prc), (String)"joe");
    }

    @Test
    public void testNoAttributeCtx() {
        ((RelyingPartyContext)this.prc.getSubcontext(RelyingPartyContext.class)).removeSubcontext(AttributeContext.class);
        Assert.assertNull((Object)this.lookup.apply(this.prc));
    }

    @Test
    public void testNoAttributes() {
        ((AttributeContext)((RelyingPartyContext)this.prc.getSubcontext(RelyingPartyContext.class, true)).getSubcontext(AttributeContext.class)).setIdPAttributes(null);
        Assert.assertNull((Object)this.lookup.apply(this.prc));
    }

    @Test(expectedExceptions={ConstraintViolationException.class})
    public void testFailNullStrategy() {
        this.lookup = new AttributeResolutionSubjectLookupFunction();
        this.lookup.setAttributeContextLookupStrategy(null);
    }

    @Test
    public void testOnlyActive() {
        ((RelyingPartyContext)this.prc.getSubcontext(RelyingPartyContext.class)).removeSubcontext(AttributeContext.class);
        IdPAttribute attribute1 = new IdPAttribute("test3");
        ArrayList<StringAttributeValue> stringAttributeValues1 = new ArrayList<StringAttributeValue>();
        stringAttributeValues1.add(new StringAttributeValue("passiveJoe"));
        attribute1.setValues(stringAttributeValues1);
        IdPAttribute attribute2 = new IdPAttribute("test4");
        ArrayList<StringAttributeValue> stringAttributeValues2 = new ArrayList<StringAttributeValue>();
        stringAttributeValues2.add(new StringAttributeValue("saml2Joe"));
        attribute2.setValues(stringAttributeValues2);
        IdPAttribute attribute3 = new IdPAttribute("test5");
        ArrayList<StringAttributeValue> stringAttributeValues3 = new ArrayList<StringAttributeValue>();
        stringAttributeValues3.add(new StringAttributeValue("noencodersJoe"));
        AttributeContext attributeCtx = new AttributeContext();
        ArrayList<IdPAttribute> attributes = new ArrayList<IdPAttribute>();
        attributes.add(attribute1);
        attributes.add(attribute2);
        attributes.add(attribute3);
        attributeCtx.setIdPAttributes(attributes);
        ((RelyingPartyContext)this.prc.getSubcontext(RelyingPartyContext.class)).addSubcontext((BaseContext)attributeCtx);
        Assert.assertNull((Object)this.lookup.apply(this.prc));
    }
}

