/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.profile.impl;

import com.nimbusds.oauth2.sdk.ParseException;
import java.net.URISyntaxException;
import java.time.Instant;
import java.util.function.Function;
import net.shibboleth.idp.plugin.oidc.op.profile.context.navigate.DefaultComputeAuthorizationCodeHashFunction;
import net.shibboleth.idp.plugin.oidc.op.profile.context.navigate.ResponseContextAuthorizationCodeLookupFunction;
import net.shibboleth.idp.plugin.oidc.op.profile.impl.AddAuthorizationCodeHashToIDToken;
import net.shibboleth.idp.plugin.oidc.op.profile.impl.BaseOIDCResponseActionTest;
import net.shibboleth.idp.profile.testing.ActionTestingSupport;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import org.opensaml.messaging.context.BaseContext;
import org.opensaml.security.credential.Credential;
import org.opensaml.xmlsec.SignatureSigningParameters;
import org.opensaml.xmlsec.context.SecurityParametersContext;
import org.springframework.webflow.execution.Event;
import org.testng.Assert;
import org.testng.annotations.Test;

public class AddAuthorizationCodeHashToIDTokenTest
extends BaseOIDCResponseActionTest {
    private AddAuthorizationCodeHashToIDToken action;
    SecurityParametersContext spCtx;

    private void init(String algo, Credential credential) throws ComponentInitializationException, URISyntaxException {
        this.spCtx = new SecurityParametersContext();
        SignatureSigningParameters params = new SignatureSigningParameters();
        this.spCtx.setSignatureSigningParameters(params);
        params.setSigningCredential(credential);
        params.setSignatureAlgorithm(algo);
        this.profileRequestCtx.addSubcontext((BaseContext)this.spCtx);
        this.setIdTokenToResponseContext("iss", "sub", "aud", Instant.now(), Instant.now());
        this.respCtx.setAuthorizationCode("authcode");
        DefaultComputeAuthorizationCodeHashFunction hashFunction = new DefaultComputeAuthorizationCodeHashFunction();
        hashFunction.setAuthorizationCodeLookupStrategy((Function)new ResponseContextAuthorizationCodeLookupFunction());
        hashFunction.setSecurityParametersLookupStrategy(prc -> this.spCtx);
        this.action = new AddAuthorizationCodeHashToIDToken();
        this.action.setCodeHashCalculationStrategy((Function)hashFunction);
        this.action.initialize();
    }

    @Test
    public void testNoIdToken() throws ComponentInitializationException, ParseException, URISyntaxException {
        this.init("RS256", this.credentialRSA);
        this.respCtx.setIDToken(null);
        Event event = this.action.execute(this.requestCtx);
        ActionTestingSupport.assertEvent((Event)event, (String)"InvalidMessageContext");
    }

    @Test
    public void testNoAuthorizationCode() throws ComponentInitializationException, ParseException, URISyntaxException {
        this.init("RS256", this.credentialRSA);
        this.respCtx.setAuthorizationCode(null);
        Event event = this.action.execute(this.requestCtx);
        ActionTestingSupport.assertEvent((Event)event, (String)"InvalidSecurityConfiguration");
    }

    @Test
    public void testSuccess() throws ComponentInitializationException, ParseException, URISyntaxException {
        this.init("RS256", this.credentialRSA);
        Event event = this.action.execute(this.requestCtx);
        ActionTestingSupport.assertProceedEvent((Event)event);
        Assert.assertNotNull((Object)this.respCtx.getIDToken().getStringClaim("c_hash"));
    }
}

