/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.profile.impl;

import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.openid.connect.sdk.claims.ACR;
import java.time.Instant;
import net.shibboleth.idp.plugin.oidc.op.profile.impl.AddAcrToIDToken;
import net.shibboleth.idp.plugin.oidc.op.profile.impl.BaseOIDCResponseActionTest;
import net.shibboleth.idp.profile.testing.ActionTestingSupport;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import org.springframework.webflow.execution.Event;
import org.testng.Assert;
import org.testng.annotations.Test;

public class AddAcrToIDTokenTest
extends BaseOIDCResponseActionTest {
    private AddAcrToIDToken action;

    private void init() throws ComponentInitializationException {
        this.action = new AddAcrToIDToken();
        this.action.initialize();
    }

    @Test
    public void testNoCtx() throws ComponentInitializationException {
        this.init();
        Event event = this.action.execute(this.requestCtx);
        ActionTestingSupport.assertEvent((Event)event, (String)"InvalidMessageContext");
    }

    @Test
    public void testSuccess() throws ComponentInitializationException, ParseException {
        this.init();
        this.setIdTokenToResponseContext("iss", "sub", "aud", Instant.now(), Instant.now());
        Event event = this.action.execute(this.requestCtx);
        ActionTestingSupport.assertProceedEvent((Event)event);
        Assert.assertNull((Object)this.respCtx.getIDToken().getACR());
    }

    @Test
    public void testSuccess2() throws ComponentInitializationException, ParseException {
        this.init();
        this.setIdTokenToResponseContext("iss", "sub", "aud", Instant.now(), Instant.now());
        this.respCtx.setAcr("acrValue");
        Event event = this.action.execute(this.requestCtx);
        ActionTestingSupport.assertProceedEvent((Event)event);
        Assert.assertEquals((Object)this.respCtx.getIDToken().getACR(), (Object)new ACR("acrValue"));
    }
}

