/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.profile.flow;

import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jwt.JWT;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.SignedJWT;
import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.Scope;
import com.nimbusds.oauth2.sdk.auth.ClientAuthenticationMethod;
import com.nimbusds.oauth2.sdk.token.BearerAccessToken;
import com.nimbusds.openid.connect.sdk.UserInfoSuccessResponse;
import com.nimbusds.openid.connect.sdk.claims.ClaimsSet;
import com.nimbusds.openid.connect.sdk.claims.UserInfo;
import java.io.IOException;
import java.net.URISyntaxException;
import java.security.NoSuchAlgorithmException;
import net.shibboleth.idp.plugin.oidc.op.profile.flow.AbstractOidcApiFlowTest;
import net.shibboleth.idp.plugin.oidc.op.storage.RevocationCacheContexts;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.security.DataSealerException;
import org.opensaml.storage.RevocationCache;
import org.opensaml.storage.StorageService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.webflow.context.ExternalContext;
import org.springframework.webflow.executor.FlowExecutionResult;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class UserInfoTest
extends AbstractOidcApiFlowTest {
    public static final String FLOW_ID = "oidc/userinfo";
    String clientId = "mockClientId";
    String clientIdSaml = "mockSamlClientId";
    String subject = "mockSubject";
    Scope scope = Scope.parse((String)"openid profile email");
    @Autowired
    @Qualifier(value="shibboleth.StorageService")
    StorageService storageService;
    @Autowired
    @Qualifier(value="shibboleth.oidc.RevocationCache")
    private RevocationCache revocationCache;

    public UserInfoTest() {
        super(FLOW_ID);
    }

    @BeforeMethod
    public void init() throws IOException {
        this.request.setMethod("GET");
        this.removeMetadata(this.storageService, this.clientId);
    }

    @AfterMethod
    public void tearDown() throws IOException {
        this.removeMetadata(this.storageService, this.clientId);
    }

    @Test
    public void testNoAccessToken() {
        FlowExecutionResult result = this.flowExecutor.launchExecution(FLOW_ID, null, (ExternalContext)this.externalContext);
        this.assertErrorCode(result, "invalid_request");
        this.assertErrorDescriptionContains(result, "UnableToDecode");
    }

    @Test
    public void testUnparseableAccessToken() {
        this.request.addHeader("Authorization", (Object)"Bearer mockAccessToken");
        FlowExecutionResult result = this.flowExecutor.launchExecution(FLOW_ID, null, (ExternalContext)this.externalContext);
        this.assertErrorCode(result, "invalid_grant");
    }

    @Test
    public void testFailsUntrustedClient() throws URISyntaxException, NoSuchAlgorithmException, DataSealerException, ComponentInitializationException {
        BearerAccessToken token = this.buildToken(this.idGenerator.generateIdentifier(), this.subject, new Scope());
        this.request.addHeader("Authorization", (Object)token.toAuthorizationHeader());
        FlowExecutionResult result = this.flowExecutor.launchExecution(FLOW_ID, null, (ExternalContext)this.externalContext);
        this.assertErrorCode(result, "unauthorized_client");
    }

    @Test
    public void testSuccessOnlySubject() throws URISyntaxException, NoSuchAlgorithmException, DataSealerException, ComponentInitializationException, IOException {
        BearerAccessToken token = this.buildToken(this.clientId, this.subject, new Scope(new String[]{"openid"}));
        this.storeMetadata(this.storageService, this.clientId, "mockSecret", this.scope, new String[0]);
        this.request.addHeader("Authorization", (Object)token.toAuthorizationHeader());
        FlowExecutionResult result = this.flowExecutor.launchExecution(FLOW_ID, null, (ExternalContext)this.externalContext);
        UserInfoSuccessResponse response = this.parseSuccessResponse(result, UserInfoSuccessResponse.class);
        Assert.assertEquals((String)response.getUserInfo().getSubject().getValue(), (String)this.subject);
        UserInfo userInfo = response.getUserInfo();
        Assert.assertNotNull((Object)userInfo);
        Assert.assertNull((Object)userInfo.getEmailAddress());
        Assert.assertNull((Object)userInfo.getNickname());
        Assert.assertNull((Object)response.getUserInfoJWT());
    }

    @Test
    public void testSuccessOnlySubjectWithLegacyToken() throws URISyntaxException, NoSuchAlgorithmException, DataSealerException, ComponentInitializationException, IOException, ParseException {
        BearerAccessToken token = this.buildLegacyToken(this.clientId, this.subject, new Scope(new String[]{"openid"}), new String[0]);
        this.storeMetadata(this.storageService, this.clientId, "mockSecret", this.scope, new String[0]);
        this.request.addHeader("Authorization", (Object)token.toAuthorizationHeader());
        FlowExecutionResult result = this.flowExecutor.launchExecution(FLOW_ID, null, (ExternalContext)this.externalContext);
        UserInfoSuccessResponse response = this.parseSuccessResponse(result, UserInfoSuccessResponse.class);
        Assert.assertEquals((String)response.getUserInfo().getSubject().getValue(), (String)this.subject);
        UserInfo userInfo = response.getUserInfo();
        Assert.assertNotNull((Object)userInfo);
        Assert.assertNull((Object)userInfo.getEmailAddress());
        Assert.assertNull((Object)userInfo.getNickname());
        Assert.assertNull((Object)response.getUserInfoJWT());
    }

    @Test
    public void testSuccessOnlySubjectSaml() throws URISyntaxException, NoSuchAlgorithmException, DataSealerException, ComponentInitializationException, IOException {
        BearerAccessToken token = this.buildToken(this.clientIdSaml, this.subject, new Scope(new String[]{"openid"}));
        this.request.addHeader("Authorization", (Object)token.toAuthorizationHeader());
        FlowExecutionResult result = this.flowExecutor.launchExecution(FLOW_ID, null, (ExternalContext)this.externalContext);
        UserInfoSuccessResponse response = this.parseSuccessResponse(result, UserInfoSuccessResponse.class);
        Assert.assertEquals((String)response.getUserInfo().getSubject().getValue(), (String)this.subject);
        UserInfo userInfo = response.getUserInfo();
        Assert.assertNotNull((Object)userInfo);
        Assert.assertNull((Object)userInfo.getEmailAddress());
        Assert.assertNull((Object)userInfo.getNickname());
        Assert.assertNull((Object)response.getUserInfoJWT());
    }

    @Test
    public void testSuccessEmailResolution() throws URISyntaxException, NoSuchAlgorithmException, DataSealerException, ComponentInitializationException, IOException {
        BearerAccessToken token = this.buildToken(this.clientId, this.subject, new Scope(new String[]{"openid", "email", "profile"}));
        this.storeMetadata(this.storageService, this.clientId, "mockSecret", this.scope, new String[0]);
        this.storeConsent(this.storageService, "jdoe", this.clientId, "mail");
        this.request.addHeader("Authorization", (Object)token.toAuthorizationHeader());
        FlowExecutionResult result = this.flowExecutor.launchExecution(FLOW_ID, null, (ExternalContext)this.externalContext);
        UserInfoSuccessResponse response = this.parseSuccessResponse(result, UserInfoSuccessResponse.class);
        UserInfo userInfo = response.getUserInfo();
        Assert.assertNotNull((Object)userInfo);
        Assert.assertEquals((String)userInfo.getSubject().getValue(), (String)this.subject);
        Assert.assertEquals((String)userInfo.getEmailAddress(), (String)"jdoe@example.org");
        Assert.assertNull((Object)userInfo.getNickname());
        Assert.assertNull((Object)response.getUserInfoJWT());
    }

    @Test
    public void testSuccessEmailResolutionWithLegacyToken() throws URISyntaxException, NoSuchAlgorithmException, DataSealerException, ComponentInitializationException, IOException, ParseException {
        BearerAccessToken token = this.buildLegacyToken(this.clientId, this.subject, new Scope(new String[]{"openid", "email", "profile"}), new String[0]);
        this.storeMetadata(this.storageService, this.clientId, "mockSecret", this.scope, new String[0]);
        this.storeConsent(this.storageService, "jdoe", this.clientId, "mail");
        this.request.addHeader("Authorization", (Object)token.toAuthorizationHeader());
        FlowExecutionResult result = this.flowExecutor.launchExecution(FLOW_ID, null, (ExternalContext)this.externalContext);
        UserInfoSuccessResponse response = this.parseSuccessResponse(result, UserInfoSuccessResponse.class);
        UserInfo userInfo = response.getUserInfo();
        Assert.assertNotNull((Object)userInfo);
        Assert.assertEquals((String)userInfo.getSubject().getValue(), (String)this.subject);
        Assert.assertEquals((String)userInfo.getEmailAddress(), (String)"jdoe@example.org");
        Assert.assertNull((Object)userInfo.getNickname());
        Assert.assertNull((Object)response.getUserInfoJWT());
    }

    @Test
    public void testSuccessEmailResolutionWithLegacyConsentToken() throws URISyntaxException, NoSuchAlgorithmException, DataSealerException, ComponentInitializationException, IOException, ParseException {
        BearerAccessToken token = this.buildLegacyToken(this.clientId, this.subject, new Scope(new String[]{"openid", "email", "profile"}), "mail");
        this.storeMetadata(this.storageService, this.clientId, "mockSecret", this.scope, new String[0]);
        this.storeConsent(this.storageService, "jdoe", this.clientId, "mail");
        this.request.addHeader("Authorization", (Object)token.toAuthorizationHeader());
        FlowExecutionResult result = this.flowExecutor.launchExecution(FLOW_ID, null, (ExternalContext)this.externalContext);
        UserInfoSuccessResponse response = this.parseSuccessResponse(result, UserInfoSuccessResponse.class);
        UserInfo userInfo = response.getUserInfo();
        Assert.assertNotNull((Object)userInfo);
        Assert.assertEquals((String)userInfo.getSubject().getValue(), (String)this.subject);
        Assert.assertEquals((String)userInfo.getEmailAddress(), (String)"jdoe@example.org");
        Assert.assertNull((Object)userInfo.getNickname());
        Assert.assertNull((Object)response.getUserInfoJWT());
    }

    @Test
    public void testNotConsentedEmailResolutionWithLegacyConsentToken() throws URISyntaxException, NoSuchAlgorithmException, DataSealerException, ComponentInitializationException, IOException, ParseException {
        BearerAccessToken token = this.buildLegacyToken(this.clientId, this.subject, new Scope(new String[]{"openid", "email", "profile"}), "not_mail");
        this.storeMetadata(this.storageService, this.clientId, "mockSecret", this.scope, new String[0]);
        this.storeConsent(this.storageService, "jdoe", this.clientId, "mail");
        this.request.addHeader("Authorization", (Object)token.toAuthorizationHeader());
        FlowExecutionResult result = this.flowExecutor.launchExecution(FLOW_ID, null, (ExternalContext)this.externalContext);
        UserInfoSuccessResponse response = this.parseSuccessResponse(result, UserInfoSuccessResponse.class);
        UserInfo userInfo = response.getUserInfo();
        Assert.assertNotNull((Object)userInfo);
        Assert.assertEquals((String)userInfo.getSubject().getValue(), (String)this.subject);
        Assert.assertNull((Object)userInfo.getEmailAddress());
        Assert.assertNull((Object)userInfo.getNickname());
        Assert.assertNull((Object)response.getUserInfoJWT());
    }

    @Test
    public void testSuccessNicknameInToken() throws URISyntaxException, NoSuchAlgorithmException, DataSealerException, ComponentInitializationException, IOException {
        ClaimsSet set = new ClaimsSet();
        set.setClaim("nickname", (Object)"mockNickname");
        BearerAccessToken token = this.buildToken(this.clientId, this.subject, new Scope(new String[]{"openid", "profile"}), set);
        this.storeMetadata(this.storageService, this.clientId, "mockSecret", this.scope, new String[0]);
        this.request.addHeader("Authorization", (Object)token.toAuthorizationHeader());
        FlowExecutionResult result = this.flowExecutor.launchExecution(FLOW_ID, null, (ExternalContext)this.externalContext);
        UserInfoSuccessResponse response = this.parseSuccessResponse(result, UserInfoSuccessResponse.class);
        UserInfo userInfo = response.getUserInfo();
        Assert.assertNotNull((Object)userInfo);
        Assert.assertEquals((String)userInfo.getSubject().getValue(), (String)this.subject);
        Assert.assertNull((Object)userInfo.getEmailAddress());
        Assert.assertEquals((String)userInfo.getNickname(), (String)"mockNickname");
        Assert.assertNull((Object)response.getUserInfoJWT());
    }

    @Test
    public void testSuccessEmailResolutionAndIssuerWithSignedResponse() throws URISyntaxException, NoSuchAlgorithmException, DataSealerException, ComponentInitializationException, IOException, java.text.ParseException {
        BearerAccessToken token = this.buildToken(this.clientId, this.subject, new Scope(new String[]{"openid", "email", "profile"}));
        this.storeMetadata(this.storageService, this.clientId, "mockSecret", this.scope, null, ClientAuthenticationMethod.CLIENT_SECRET_BASIC, JWSAlgorithm.RS256, new String[0]);
        this.storeConsent(this.storageService, "jdoe", this.clientId, "mail");
        this.request.addHeader("Authorization", (Object)token.toAuthorizationHeader());
        FlowExecutionResult result = this.flowExecutor.launchExecution(FLOW_ID, null, (ExternalContext)this.externalContext);
        UserInfoSuccessResponse response = this.parseSuccessResponse(result, UserInfoSuccessResponse.class);
        Assert.assertNull((Object)response.getUserInfo());
        JWT userInfoJwt = response.getUserInfoJWT();
        Assert.assertNotNull((Object)userInfoJwt);
        Assert.assertTrue((boolean)(userInfoJwt instanceof SignedJWT));
        JWTClaimsSet claimsSet = userInfoJwt.getJWTClaimsSet();
        Assert.assertEquals((String)claimsSet.getSubject(), (String)this.subject);
        Assert.assertEquals((Object)claimsSet.getClaim("email"), (Object)"jdoe@example.org");
        Assert.assertEquals((Object)claimsSet.getClaim("iss"), (Object)"https://op.example.org");
    }

    @Test
    public void testRevokedSingleToken() throws URISyntaxException, NoSuchAlgorithmException, DataSealerException, ComponentInitializationException, IOException {
        String rootId = this.idGenerator.generateIdentifier();
        String jti = this.idGenerator.generateIdentifier();
        this.revocationCache.revoke(RevocationCacheContexts.SINGLE_ACCESS_OR_REFRESH_TOKENS, jti);
        BearerAccessToken token = this.buildToken(this.clientId, this.subject, new Scope(new String[]{"openid"}), null, jti, rootId);
        this.storeMetadata(this.storageService, this.clientId, "mockSecret", this.scope, new String[0]);
        this.request.addHeader("Authorization", (Object)token.toAuthorizationHeader());
        FlowExecutionResult result = this.flowExecutor.launchExecution(FLOW_ID, null, (ExternalContext)this.externalContext);
        this.assertErrorCode(result, "invalid_grant");
    }

    @Test
    public void testRevokedChain() throws URISyntaxException, NoSuchAlgorithmException, DataSealerException, ComponentInitializationException, IOException {
        String rootId = this.idGenerator.generateIdentifier();
        String jti = this.idGenerator.generateIdentifier();
        this.revocationCache.revoke(RevocationCacheContexts.AUTHORIZATION_CODE, rootId);
        BearerAccessToken token = this.buildToken(this.clientId, this.subject, new Scope(new String[]{"openid"}), null, jti, rootId);
        this.storeMetadata(this.storageService, this.clientId, "mockSecret", this.scope, new String[0]);
        this.request.addHeader("Authorization", (Object)token.toAuthorizationHeader());
        FlowExecutionResult result = this.flowExecutor.launchExecution(FLOW_ID, null, (ExternalContext)this.externalContext);
        this.assertErrorCode(result, "invalid_grant");
    }

    @Test
    public void testRevokedChainViaJti() throws URISyntaxException, NoSuchAlgorithmException, DataSealerException, ComponentInitializationException, IOException {
        String jti = this.idGenerator.generateIdentifier();
        this.revocationCache.revoke(RevocationCacheContexts.AUTHORIZATION_CODE, jti);
        BearerAccessToken token = this.buildToken(this.clientId, this.subject, new Scope(new String[]{"openid"}), null, jti, null);
        this.storeMetadata(this.storageService, this.clientId, "mockSecret", this.scope, new String[0]);
        this.request.addHeader("Authorization", (Object)token.toAuthorizationHeader());
        FlowExecutionResult result = this.flowExecutor.launchExecution(FLOW_ID, null, (ExternalContext)this.externalContext);
        this.assertErrorCode(result, "invalid_grant");
    }
}

