/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.metadata.impl;

import net.minidev.json.JSONObject;
import net.shibboleth.idp.plugin.oidc.op.metadata.impl.FilesystemMetadataValueResolver;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.testng.Assert;
import org.testng.annotations.Test;

public class FilesystemMetadataValueResolverTest {
    public FilesystemMetadataValueResolver initTests(String filename) throws Exception {
        ClassPathResource file = new ClassPathResource(filename);
        FilesystemMetadataValueResolver resolver = new FilesystemMetadataValueResolver((Resource)file);
        resolver.setId("mockId");
        resolver.initialize();
        return resolver;
    }

    @Test
    public void testString() throws Exception {
        FilesystemMetadataValueResolver resolver = this.initTests("/net/shibboleth/idp/oidc/metadata/impl/dyn-value1.json");
        Object value = resolver.resolveSingle(null);
        Assert.assertNotNull((Object)value);
        Assert.assertTrue((boolean)(value instanceof String));
        Assert.assertEquals((Object)value, (Object)"mockValue");
    }

    @Test
    public void testJson() throws Exception {
        FilesystemMetadataValueResolver resolver = this.initTests("/net/shibboleth/idp/oidc/metadata/impl/dyn-value2.json");
        Object value = resolver.resolveSingle(null);
        Assert.assertNotNull((Object)value);
        Assert.assertTrue((boolean)(value instanceof JSONObject));
        JSONObject jsonValue = (JSONObject)value;
        Assert.assertEquals((int)jsonValue.size(), (int)1);
        Assert.assertEquals((Object)jsonValue.get((Object)"mockKey"), (Object)"mockValue");
    }
}

