/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.decoding.impl;

import com.google.common.io.Files;
import com.nimbusds.oauth2.sdk.http.HTTPRequest;
import com.nimbusds.openid.connect.sdk.rp.OIDCClientRegistrationRequest;
import java.io.File;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import net.shibboleth.idp.plugin.oidc.op.decoding.impl.OIDCClientRegistrationRequestDecoder;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.decoder.MessageDecodingException;
import org.springframework.mock.web.MockHttpServletRequest;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class OIDCClientRegistrationRequestDecoderTest {
    private MockHttpServletRequest httpRequest;
    private OIDCClientRegistrationRequestDecoder decoder;

    @BeforeMethod
    protected void setUp() throws Exception {
        this.httpRequest = new MockHttpServletRequest();
        this.httpRequest.setMethod(HTTPRequest.Method.POST.toString());
        this.decoder = new OIDCClientRegistrationRequestDecoder();
        this.decoder.setHttpServletRequest((HttpServletRequest)this.httpRequest);
        this.decoder.initialize();
    }

    @Test(expectedExceptions={MessageDecodingException.class})
    public void testWrongMethod() throws MessageDecodingException {
        this.httpRequest.setMethod(HTTPRequest.Method.GET.toString());
        this.decoder.decode();
    }

    @Test(expectedExceptions={MessageDecodingException.class})
    public void testInvalidJson() throws MessageDecodingException {
        this.httpRequest.setContent("\"test\" : \"test\" }".getBytes());
        this.httpRequest.setContentType("application/json");
        this.decoder.decode();
    }

    @Test
    public void testRequestDecoding() throws MessageDecodingException, IOException {
        byte[] bytes = Files.toByteArray((File)new File("src/test/resources/net/shibboleth/idp/oidc/decoding/impl/client-registration-request.json"));
        this.httpRequest.setContent(bytes);
        this.httpRequest.setContentType("application/json");
        this.decoder.decode();
        MessageContext messageContext = this.decoder.getMessageContext();
        OIDCClientRegistrationRequest message = (OIDCClientRegistrationRequest)messageContext.getMessage();
        Assert.assertEquals((String)message.getClientMetadata().getName(), (String)"My Example");
    }
}

