/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.attribute.filter.spring.matcher.impl;

import net.shibboleth.ext.spring.context.FilesystemGenericApplicationContext;
import net.shibboleth.idp.attribute.filter.AttributeRule;
import net.shibboleth.idp.attribute.filter.Matcher;
import net.shibboleth.idp.attribute.filter.spring.testing.BaseAttributeFilterParserTest;
import net.shibboleth.idp.plugin.oidc.op.attribute.filter.matcher.impl.AttributeInOIDCRequestedClaimsMatcher;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import org.springframework.context.support.GenericApplicationContext;
import org.testng.Assert;
import org.testng.annotations.Test;

public class AttributeInOIDCRequestedClaimsRuleParserTest
extends BaseAttributeFilterParserTest {
    protected static final String OIDC_MATCHER_PATH = "/net/shibboleth/idp/oidc/attribute/filter/matcher/";

    @Test
    public void policy() throws ComponentInitializationException {
        AttributeInOIDCRequestedClaimsMatcher rule = (AttributeInOIDCRequestedClaimsMatcher)this.getOIDCMatcher("requestedClaims.xml");
        Assert.assertEquals((boolean)rule.getMatchIRequestedClaimsSilent(), (boolean)true);
        Assert.assertEquals((boolean)rule.getMatchOnlyIDToken(), (boolean)false);
        Assert.assertEquals((boolean)rule.getMatchOnlyUserInfo(), (boolean)true);
        Assert.assertEquals((boolean)rule.getOnlyIfEssential(), (boolean)true);
    }

    protected Matcher getOIDCMatcher(String fileName) throws ComponentInitializationException {
        FilesystemGenericApplicationContext context = new FilesystemGenericApplicationContext();
        context.setDisplayName("ApplicationContext: Matcher");
        this.setTestContext((GenericApplicationContext)context);
        String path = OIDC_MATCHER_PATH + fileName;
        AttributeRule rule = (AttributeRule)this.getBean(path, AttributeRule.class, (GenericApplicationContext)context);
        rule.initialize();
        return rule.getMatcher();
    }
}

