/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.userinfo.profile.impl;

import com.nimbusds.jose.JOSEObjectType;
import com.nimbusds.jwt.JWT;
import com.nimbusds.jwt.SignedJWT;
import com.nimbusds.oauth2.sdk.token.AccessToken;
import java.text.ParseException;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.plugin.oidc.op.token.support.AccessTokenClaimsSet;
import net.shibboleth.idp.plugin.oidc.op.token.support.TokenClaimsSet;
import net.shibboleth.idp.plugin.oidc.op.userinfo.profile.impl.AbstractOIDCUserInfoValidationResponseAction;
import net.shibboleth.oidc.security.impl.JWTSignatureValidationUtil;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullAfterInit;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import net.shibboleth.utilities.java.support.resolver.Criterion;
import net.shibboleth.utilities.java.support.resolver.ResolverException;
import net.shibboleth.utilities.java.support.security.DataSealer;
import net.shibboleth.utilities.java.support.security.DataSealerException;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.security.credential.CredentialResolver;
import org.opensaml.security.credential.UsageType;
import org.opensaml.security.criteria.UsageCriterion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParseAccessToken
extends AbstractOIDCUserInfoValidationResponseAction {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(ParseAccessToken.class);
    @NonnullAfterInit
    private DataSealer dataSealer;
    @Nullable
    private CredentialResolver credentialResolver;
    @Nullable
    private SignedJWT signedJWT;

    public void setDataSealer(@Nonnull DataSealer sealer) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.dataSealer = (DataSealer)Constraint.isNotNull((Object)sealer, (String)"DataSealer cannot be null");
    }

    public void setCredentialResolver(@Nullable CredentialResolver resolver) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.credentialResolver = resolver;
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.dataSealer == null) {
            throw new ComponentInitializationException("DataSealer cannot be null");
        }
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        AccessToken token = this.getUserInfoRequest().getAccessToken();
        if (token == null) {
            this.log.error("{} Token missing from request", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidGrant");
            return;
        }
        AccessTokenClaimsSet accessTokenClaimsSet = this.parseAccessToken(token);
        if (accessTokenClaimsSet == null) {
            this.log.warn("{} Unable to parse/decode token for validation", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidGrant");
            return;
        }
        this.log.debug("{} Access token unwrapped: {}", (Object)this.getLogPrefix(), (Object)accessTokenClaimsSet.serialize());
        if (this.signedJWT != null) {
            JOSEObjectType typ = this.signedJWT.getHeader().getType();
            if (typ == null || !"at+jwt".equals(typ.getType())) {
                this.log.warn("{} Missing or invalid token type: {}", (Object)this.getLogPrefix(), (Object)(typ != null ? typ.getType() : "null"));
                ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidGrant");
                return;
            }
            if (this.credentialResolver == null) {
                this.log.error("{} No CredentialResolver available, can't verify JWT signature", (Object)this.getLogPrefix());
                ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidGrant");
                return;
            }
            this.log.debug("{} Checking JWT signature", (Object)this.getLogPrefix());
            ArrayList credList = new ArrayList();
            CriteriaSet criteriaSet = new CriteriaSet(new Criterion[]{new UsageCriterion(UsageType.SIGNING)});
            try {
                Iterable creds = this.credentialResolver.resolve((Object)criteriaSet);
                if (creds != null) {
                    creds.forEach(credList::add);
                }
            }
            catch (ResolverException e) {
                this.log.error("{} Failure resolving signing credentials, can't verify JWT signature", (Object)this.getLogPrefix(), (Object)e);
                ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidGrant");
                return;
            }
            String errorEventId = JWTSignatureValidationUtil.validateSignatureEx(credList, (SignedJWT)this.signedJWT, (String)"InvalidGrant");
            if (errorEventId != null) {
                this.log.warn("{} Signature on token ID '{}' invalid", (Object)this.getLogPrefix(), (Object)accessTokenClaimsSet.getID());
                ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)errorEventId);
                return;
            }
        }
        this.log.debug("{} Access token {} parsed", (Object)this.getLogPrefix(), (Object)accessTokenClaimsSet.getID());
        this.getOidcResponseContext().setAuthorizationGrantClaimsSet((TokenClaimsSet)accessTokenClaimsSet);
    }

    @Nullable
    protected AccessTokenClaimsSet parseAccessToken(@Nonnull @NotEmpty AccessToken token) {
        try {
            this.signedJWT = SignedJWT.parse((String)token.getValue());
            return AccessTokenClaimsSet.parse((JWT)this.signedJWT, (DataSealer)this.dataSealer);
        }
        catch (ParseException | DataSealerException throwable) {
            try {
                return AccessTokenClaimsSet.parse((String)token.getValue(), (DataSealer)this.dataSealer);
            }
            catch (ParseException | DataSealerException throwable2) {
                return null;
            }
        }
    }
}

