/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.attribute.filter.policyrule.impl;

import java.util.List;
import javax.annotation.Nonnull;
import net.shibboleth.idp.attribute.filter.PolicyRequirementRule;
import net.shibboleth.idp.attribute.filter.context.AttributeFilterContext;
import net.shibboleth.idp.attribute.filter.policyrule.impl.AbstractStringPolicyRule;
import net.shibboleth.idp.plugin.oidc.op.messaging.context.OIDCAuthenticationResponseContext;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import org.opensaml.messaging.context.BaseContext;
import org.opensaml.messaging.context.navigate.RecursiveTypedParentContextLookup;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AttributeOIDCScopePolicyRule
extends AbstractStringPolicyRule {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(AttributeOIDCScopePolicyRule.class);

    public PolicyRequirementRule.Tristate matches(@Nonnull AttributeFilterContext filterContext) {
        ComponentSupport.ifNotInitializedThrowUninitializedComponentException((InitializableComponent)this);
        ProfileRequestContext profileRequestContext = (ProfileRequestContext)new RecursiveTypedParentContextLookup(ProfileRequestContext.class).apply((BaseContext)filterContext);
        if (profileRequestContext == null || profileRequestContext.getOutboundMessageContext() == null) {
            this.log.trace("{} No outbound message context", (Object)this.getLogPrefix());
            return PolicyRequirementRule.Tristate.FALSE;
        }
        OIDCAuthenticationResponseContext ctx = (OIDCAuthenticationResponseContext)profileRequestContext.getOutboundMessageContext().getSubcontext(OIDCAuthenticationResponseContext.class, false);
        if (ctx == null || ctx.getScope() == null) {
            this.log.trace("{} No verified requested scopes for oidc found", (Object)this.getLogPrefix());
            return PolicyRequirementRule.Tristate.FALSE;
        }
        List scopes = ctx.getScope().toStringList();
        if (scopes == null || scopes.isEmpty()) {
            this.log.warn("{} No scopes in oidc request, should not happen", (Object)this.getLogPrefix());
            return PolicyRequirementRule.Tristate.FAIL;
        }
        for (String scope : scopes) {
            this.log.debug("{} evaluating scope {}", (Object)this.getLogPrefix(), (Object)scope);
            if (this.stringCompare(scope) != PolicyRequirementRule.Tristate.TRUE) continue;
            return PolicyRequirementRule.Tristate.TRUE;
        }
        return PolicyRequirementRule.Tristate.FALSE;
    }
}

