/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.profile.impl;

import com.nimbusds.oauth2.sdk.AuthorizationGrant;
import com.nimbusds.oauth2.sdk.GrantType;
import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.RefreshTokenGrant;
import com.nimbusds.oauth2.sdk.TokenRequest;
import com.nimbusds.oauth2.sdk.id.ClientID;
import com.nimbusds.oauth2.sdk.token.RefreshToken;
import com.nimbusds.openid.connect.sdk.rp.OIDCClientInformation;
import com.nimbusds.openid.connect.sdk.rp.OIDCClientMetadata;
import java.net.URI;
import java.util.Collections;
import java.util.HashSet;
import net.shibboleth.idp.plugin.oidc.op.profile.impl.BaseOIDCResponseActionTest;
import net.shibboleth.idp.plugin.oidc.op.profile.impl.ValidateGrantType;
import net.shibboleth.idp.profile.config.ProfileConfiguration;
import net.shibboleth.idp.profile.context.RelyingPartyContext;
import net.shibboleth.idp.profile.testing.ActionTestingSupport;
import net.shibboleth.oidc.metadata.context.OIDCMetadataContext;
import net.shibboleth.oidc.profile.oauth2.config.OAuth2TokenConfiguration;
import org.springframework.webflow.execution.Event;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class ValidateGrantTypeTest
extends BaseOIDCResponseActionTest {
    private ValidateGrantType action;
    private OIDCClientMetadata metaData;

    @Override
    @BeforeMethod
    protected void setUp() throws Exception {
        super.setUp();
        this.action = new ValidateGrantType();
        this.action.initialize();
        OIDCMetadataContext oidcCtx = (OIDCMetadataContext)this.profileRequestCtx.getInboundMessageContext().getSubcontext(OIDCMetadataContext.class, true);
        this.metaData = new OIDCClientMetadata();
        HashSet<GrantType> grantTypes = new HashSet<GrantType>();
        grantTypes.add(GrantType.parse((String)"refresh_token"));
        grantTypes.add(GrantType.parse((String)"authorization_code"));
        this.metaData.setGrantTypes(grantTypes);
        this.metaData.setRedirectionURI(new URI("https://notmatching.org"));
        OIDCClientInformation information = new OIDCClientInformation(new ClientID("test"), null, this.metaData, null, null, null);
        oidcCtx.setClientInformation(information);
        TokenRequest req = new TokenRequest(new URI("https://notmatching.org"), (AuthorizationGrant)new RefreshTokenGrant(new RefreshToken()));
        this.setTokenRequest(req);
    }

    @Test
    public void testSuccess() {
        Event event = this.action.execute(this.requestCtx);
        ActionTestingSupport.assertProceedEvent((Event)event);
    }

    @Test
    public void testSuccessNoMetadata() {
        this.profileRequestCtx.getInboundMessageContext().removeSubcontext(this.profileRequestCtx.getInboundMessageContext().getSubcontext(OIDCMetadataContext.class));
        Event event = this.action.execute(this.requestCtx);
        ActionTestingSupport.assertProceedEvent((Event)event);
    }

    @Test
    public void testFailureNoMetadata() {
        this.profileRequestCtx.getInboundMessageContext().removeSubcontext(this.profileRequestCtx.getInboundMessageContext().getSubcontext(OIDCMetadataContext.class));
        OAuth2TokenConfiguration config = new OAuth2TokenConfiguration();
        config.setGrantTypes(Collections.singleton(GrantType.AUTHORIZATION_CODE.toString()));
        ((RelyingPartyContext)this.profileRequestCtx.getSubcontext(RelyingPartyContext.class)).setProfileConfig((ProfileConfiguration)config);
        Event event = this.action.execute(this.requestCtx);
        ActionTestingSupport.assertEvent((Event)event, (String)"InvalidGrantType");
    }

    @Test
    public void testFailure() throws ParseException {
        HashSet<GrantType> grantTypes = new HashSet<GrantType>();
        grantTypes.add(GrantType.parse((String)"authorization_code"));
        this.metaData.setGrantTypes(grantTypes);
        Event event = this.action.execute(this.requestCtx);
        ActionTestingSupport.assertEvent((Event)event, (String)"InvalidGrantType");
    }
}

