/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.profile.impl;

import com.google.common.base.Predicates;
import com.nimbusds.oauth2.sdk.AuthorizationCode;
import com.nimbusds.oauth2.sdk.AuthorizationCodeGrant;
import com.nimbusds.oauth2.sdk.AuthorizationGrant;
import com.nimbusds.oauth2.sdk.ClientCredentialsGrant;
import com.nimbusds.oauth2.sdk.RefreshTokenGrant;
import com.nimbusds.oauth2.sdk.Scope;
import com.nimbusds.oauth2.sdk.TokenRequest;
import com.nimbusds.oauth2.sdk.auth.ClientAuthentication;
import com.nimbusds.oauth2.sdk.auth.ClientSecretBasic;
import com.nimbusds.oauth2.sdk.auth.Secret;
import com.nimbusds.oauth2.sdk.id.ClientID;
import com.nimbusds.oauth2.sdk.token.RefreshToken;
import com.nimbusds.openid.connect.sdk.claims.ClaimsSet;
import java.net.URI;
import java.security.NoSuchAlgorithmException;
import java.time.Duration;
import java.time.Instant;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minidev.json.JSONObject;
import net.shibboleth.idp.plugin.oidc.op.messaging.context.OIDCAuthenticationResponseContext;
import net.shibboleth.idp.plugin.oidc.op.profile.impl.BaseOIDCResponseActionTest;
import net.shibboleth.idp.plugin.oidc.op.profile.impl.ValidateGrant;
import net.shibboleth.idp.plugin.oidc.op.storage.RevocationCacheContexts;
import net.shibboleth.idp.plugin.oidc.op.token.support.AuthorizeCodeClaimsSet;
import net.shibboleth.idp.plugin.oidc.op.token.support.RefreshTokenClaimsSet;
import net.shibboleth.idp.plugin.oidc.op.token.support.TokenClaimsSet;
import net.shibboleth.idp.profile.testing.ActionTestingSupport;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.logic.ConstraintViolationException;
import net.shibboleth.utilities.java.support.security.IdentifierGenerationStrategy;
import net.shibboleth.utilities.java.support.security.impl.SecureRandomIdentifierGenerationStrategy;
import org.mockito.Mockito;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.storage.ReplayCache;
import org.opensaml.storage.RevocationCache;
import org.opensaml.storage.StorageService;
import org.opensaml.storage.impl.MemoryStorageService;
import org.springframework.webflow.execution.Event;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class ValidateGrantTest
extends BaseOIDCResponseActionTest {
    private ValidateGrant action;
    TokenClaimsSet acClaims;
    TokenClaimsSet rfClaims;
    AuthorizationGrant codeGrant;
    RefreshTokenGrant rfGrant;
    URI callback;
    MemoryStorageService storageService;
    String rootTokenId;

    @BeforeMethod
    protected void setupStorage() throws ComponentInitializationException {
        this.storageService = new MemoryStorageService();
        this.storageService.setId("id");
        this.storageService.initialize();
    }

    private void init() throws Exception {
        this.init(true);
    }

    private void init(boolean refreshTokensEnabled) throws Exception {
        this.init(refreshTokensEnabled, new BaseOIDCResponseActionTest.MockRevocationCache(this, false, true), null);
    }

    private void init(boolean refreshTokensEnabled, RevocationCache revocationCache, Function<ProfileRequestContext, Duration> revocationLifetimeLookup) throws Exception {
        Instant now = Instant.now();
        this.rootTokenId = "mockId" + now.toEpochMilli();
        this.acClaims = new AuthorizeCodeClaimsSet.Builder().setJWTID(this.idGenerator).setClientID(new ClientID(this.clientId)).setIssuer("issuer").setPrincipal("userPrin").setSubject("subject").setIssuedAt(Instant.now()).setExpiresAt(Instant.now().plusSeconds(100L)).setAuthenticationTime(Instant.now()).setRedirectURI(new URI("http://example.com")).setScope(new Scope()).build();
        this.rfClaims = new RefreshTokenClaimsSet.Builder(this.acClaims, now, now.plusSeconds(100L)).setRootTokenIdentifier(this.rootTokenId).build();
        AuthorizationCode code = new AuthorizationCode(this.acClaims.serialize(this.getDataSealer()));
        RefreshToken rfToken = new RefreshToken(this.rfClaims.serialize(this.getDataSealer()));
        this.callback = new URI("https://client.com/callback");
        this.codeGrant = new AuthorizationCodeGrant(code, this.callback);
        this.rfGrant = new RefreshTokenGrant(rfToken);
        TokenRequest req = new TokenRequest(this.callback, new ClientID(this.clientId), this.codeGrant);
        this.profileRequestCtx.getInboundMessageContext().setMessage((Object)req);
        this.action = new ValidateGrant(this.getDataSealer());
        if (revocationLifetimeLookup != null) {
            this.action.setChainRevocationLifetimeLookupStrategy(revocationLifetimeLookup);
        }
        this.action.setRevocationCache(revocationCache);
        ReplayCache replayCache = new ReplayCache();
        replayCache.setStorage((StorageService)this.storageService);
        this.action.setReplayCache(replayCache);
        if (refreshTokensEnabled) {
            this.action.setRefreshTokensEnabledPredicate((Predicate)Predicates.alwaysTrue());
        } else {
            this.action.setRefreshTokensEnabledPredicate((Predicate)Predicates.alwaysFalse());
        }
        this.action.initialize();
    }

    public static AuthorizationCode buildAuthorizationCode(String clientId, String issuer, String userPrincipal, String sub, String callbackUrl) throws Exception {
        return ValidateGrantTest.buildAuthorizationCode(clientId, issuer, userPrincipal, sub, callbackUrl, null);
    }

    public static AuthorizationCode buildAuthorizationCode(String clientId, String issuer, String userPrincipal, String sub, String callbackUrl, String scope) throws Exception {
        return ValidateGrantTest.buildAuthorizationCode(clientId, issuer, userPrincipal, sub, callbackUrl, null, scope);
    }

    public static AuthorizationCode buildAuthorizationCode(String clientId, String issuer, String userPrincipal, String sub, String callbackUrl, String codeChallenge, String scope) throws Exception {
        return ValidateGrantTest.buildAuthorizationCode(clientId, issuer, userPrincipal, sub, callbackUrl, codeChallenge, null, null, null, scope);
    }

    public static AuthorizationCode buildAuthorizationCode(String clientId, String issuer, String userPrincipal, String sub, String callbackUrl, String codeChallenge, JSONObject deliveryClaims, JSONObject deliveryClaimsIDToken, JSONObject deliveryClaimsUserInfo, String scope) throws Exception {
        TokenClaimsSet acClaims = ValidateGrantTest.buildTokenClaimsSet(clientId, issuer, userPrincipal, sub, callbackUrl, codeChallenge, deliveryClaims, deliveryClaimsIDToken, deliveryClaimsUserInfo, scope);
        return new AuthorizationCode(acClaims.serialize(new ValidateGrantTest().getDataSealer()));
    }

    public static TokenClaimsSet buildTokenClaimsSet(String clientId, String issuer, String userPrincipal, String sub, String callbackUrl, String codeChallenge, JSONObject deliveryClaims, JSONObject deliveryClaimsIDToken, JSONObject deliveryClaimsUserInfo, String scope) throws Exception {
        Instant now = Instant.now();
        AuthorizeCodeClaimsSet.Builder builder = new AuthorizeCodeClaimsSet.Builder();
        builder.setJWTID((IdentifierGenerationStrategy)new SecureRandomIdentifierGenerationStrategy()).setClientID(new ClientID(clientId)).setIssuer(issuer).setPrincipal(userPrincipal).setSubject(sub).setIssuedAt(now).setExpiresAt(now.plusSeconds(100L)).setAuthenticationTime(now).setRedirectURI(new URI(callbackUrl)).setScope(scope == null ? new Scope() : Scope.parse((String)scope));
        if (codeChallenge != null) {
            builder.setCodeChallenge(codeChallenge);
        }
        if (deliveryClaims != null) {
            builder.setDlClaims((ClaimsSet)new DeliveryClaimsSet(deliveryClaims));
        }
        if (deliveryClaimsIDToken != null) {
            builder.setDlClaimsID((ClaimsSet)new DeliveryClaimsSet(deliveryClaimsIDToken));
        }
        if (deliveryClaimsUserInfo != null) {
            builder.setDlClaimsUI((ClaimsSet)new DeliveryClaimsSet(deliveryClaimsUserInfo));
        }
        return builder.build();
    }

    @Test
    public void testAuthorizeCodeSuccess() throws Exception {
        this.init();
        ActionTestingSupport.assertProceedEvent((Event)this.action.execute(this.requestCtx));
        OIDCAuthenticationResponseContext arc = (OIDCAuthenticationResponseContext)this.profileRequestCtx.getOutboundMessageContext().getSubcontext(OIDCAuthenticationResponseContext.class);
        Assert.assertNotNull((Object)arc.getAuthorizationGrantClaimsSet());
    }

    @Test
    public void testAuthorizeCodeReplayed() throws Exception {
        this.init();
        ActionTestingSupport.assertProceedEvent((Event)this.action.execute(this.requestCtx));
        ActionTestingSupport.assertEvent((Event)this.action.execute(this.requestCtx), (String)"InvalidGrant");
    }

    @Test
    public void testRefreshTokenSuccess() throws Exception {
        this.init();
        TokenRequest req = new TokenRequest(this.callback, new ClientID(this.clientId), (AuthorizationGrant)this.rfGrant);
        this.profileRequestCtx.getInboundMessageContext().setMessage((Object)req);
        ActionTestingSupport.assertProceedEvent((Event)this.action.execute(this.requestCtx));
        OIDCAuthenticationResponseContext arc = (OIDCAuthenticationResponseContext)this.profileRequestCtx.getOutboundMessageContext().getSubcontext(OIDCAuthenticationResponseContext.class);
        Assert.assertNotNull((Object)arc.getAuthorizationGrantClaimsSet());
    }

    @Test
    public void testRefreshTokenNotEnabled() throws Exception {
        this.init(false);
        TokenRequest req = new TokenRequest(this.callback, new ClientID(this.clientId), (AuthorizationGrant)this.rfGrant);
        this.profileRequestCtx.getInboundMessageContext().setMessage((Object)req);
        ActionTestingSupport.assertEvent((Event)this.action.execute(this.requestCtx), (String)"InvalidGrant");
        OIDCAuthenticationResponseContext arc = (OIDCAuthenticationResponseContext)this.profileRequestCtx.getOutboundMessageContext().getSubcontext(OIDCAuthenticationResponseContext.class);
        Assert.assertNull((Object)arc.getAuthorizationGrantClaimsSet());
    }

    @Test
    public void testRefreshTokenReplayed() throws Exception {
        this.init();
        TokenRequest req = new TokenRequest(this.callback, new ClientID(this.clientId), (AuthorizationGrant)this.rfGrant);
        this.profileRequestCtx.getInboundMessageContext().setMessage((Object)req);
        ActionTestingSupport.assertProceedEvent((Event)this.action.execute(this.requestCtx));
        ActionTestingSupport.assertProceedEvent((Event)this.action.execute(this.requestCtx));
        OIDCAuthenticationResponseContext arc = (OIDCAuthenticationResponseContext)this.profileRequestCtx.getOutboundMessageContext().getSubcontext(OIDCAuthenticationResponseContext.class);
        Assert.assertNotNull((Object)arc.getAuthorizationGrantClaimsSet());
    }

    @Test
    public void testRefreshTokenAuthorizationGrantRevoked() throws Exception {
        RevocationCache revocationCache = new RevocationCache();
        revocationCache.setStorage((StorageService)this.storageService);
        this.init(true, revocationCache, null);
        Assert.assertTrue((boolean)revocationCache.revoke(RevocationCacheContexts.AUTHORIZATION_CODE, this.rfClaims.getRootTokenIdentifier()));
        TokenRequest req = new TokenRequest(this.callback, new ClientID(this.clientId), (AuthorizationGrant)this.rfGrant);
        this.profileRequestCtx.getInboundMessageContext().setMessage((Object)req);
        ActionTestingSupport.assertEvent((Event)this.action.execute(this.requestCtx), (String)"InvalidGrant");
        OIDCAuthenticationResponseContext arc = (OIDCAuthenticationResponseContext)this.profileRequestCtx.getOutboundMessageContext().getSubcontext(OIDCAuthenticationResponseContext.class);
        Assert.assertNull((Object)arc.getAuthorizationGrantClaimsSet());
    }

    @Test
    public void testRefreshTokenRevokedShouldRevokeAuthorizationCode() throws Exception {
        RevocationCache revocationCache = new RevocationCache();
        revocationCache.setStorage((StorageService)this.storageService);
        this.init(true, revocationCache, null);
        Assert.assertTrue((boolean)revocationCache.revoke(RevocationCacheContexts.SINGLE_ACCESS_OR_REFRESH_TOKENS, this.rfClaims.getID()));
        TokenRequest req = new TokenRequest(this.callback, new ClientID(this.clientId), (AuthorizationGrant)this.rfGrant);
        this.profileRequestCtx.getInboundMessageContext().setMessage((Object)req);
        ActionTestingSupport.assertEvent((Event)this.action.execute(this.requestCtx), (String)"InvalidGrant");
        OIDCAuthenticationResponseContext arc = (OIDCAuthenticationResponseContext)this.profileRequestCtx.getOutboundMessageContext().getSubcontext(OIDCAuthenticationResponseContext.class);
        Assert.assertNull((Object)arc.getAuthorizationGrantClaimsSet());
        Assert.assertTrue((boolean)revocationCache.isRevoked(RevocationCacheContexts.AUTHORIZATION_CODE, this.rfClaims.getRootTokenIdentifier()));
    }

    @Test
    public void testTokenRevocationViaRevokedTokenFailsReturnsInvalidProfileConfig() throws Exception {
        RevocationCache revocationCache = (RevocationCache)Mockito.mock(RevocationCache.class);
        Mockito.when((Object)revocationCache.isRevoked(Mockito.matches((String)RevocationCacheContexts.AUTHORIZATION_CODE), Mockito.anyString())).thenReturn((Object)false);
        Mockito.when((Object)revocationCache.isRevoked(Mockito.matches((String)RevocationCacheContexts.SINGLE_ACCESS_OR_REFRESH_TOKENS), Mockito.anyString())).thenReturn((Object)true);
        Mockito.when((Object)revocationCache.revoke(Mockito.anyString(), Mockito.anyString())).thenReturn((Object)false);
        this.init(true, revocationCache, prc -> null);
        TokenRequest req = new TokenRequest(this.callback, new ClientID(this.clientId), (AuthorizationGrant)this.rfGrant);
        this.profileRequestCtx.getInboundMessageContext().setMessage((Object)req);
        ActionTestingSupport.assertEvent((Event)this.action.execute(this.requestCtx), (String)"InvalidProfileConfiguration");
        OIDCAuthenticationResponseContext arc = (OIDCAuthenticationResponseContext)this.profileRequestCtx.getOutboundMessageContext().getSubcontext(OIDCAuthenticationResponseContext.class);
        Assert.assertNull((Object)arc.getAuthorizationGrantClaimsSet());
    }

    @Test
    public void testMixGrant() throws Exception {
        this.init();
        TokenRequest req = new TokenRequest(this.callback, new ClientID(this.clientId), (AuthorizationGrant)new RefreshTokenGrant(new RefreshToken(this.acClaims.serialize(this.getDataSealer()))));
        this.profileRequestCtx.getInboundMessageContext().setMessage((Object)req);
        ActionTestingSupport.assertEvent((Event)this.action.execute(this.requestCtx), (String)"InvalidGrant");
        OIDCAuthenticationResponseContext arc = (OIDCAuthenticationResponseContext)this.profileRequestCtx.getOutboundMessageContext().getSubcontext(OIDCAuthenticationResponseContext.class);
        Assert.assertNull((Object)arc.getAuthorizationGrantClaimsSet());
    }

    @Test
    public void testWrongClient() throws Exception {
        this.init();
        AuthorizationCode code = ValidateGrantTest.buildAuthorizationCode("clientIdWrong", "issuer", "userPrin", "subject", "http://example.com");
        TokenRequest req = new TokenRequest(this.callback, new ClientID(this.clientId), (AuthorizationGrant)new AuthorizationCodeGrant(code, this.callback));
        this.profileRequestCtx.getInboundMessageContext().setMessage((Object)req);
        ActionTestingSupport.assertEvent((Event)this.action.execute(this.requestCtx), (String)"InvalidGrant");
        OIDCAuthenticationResponseContext arc = (OIDCAuthenticationResponseContext)this.profileRequestCtx.getOutboundMessageContext().getSubcontext(OIDCAuthenticationResponseContext.class);
        Assert.assertNull((Object)arc.getAuthorizationGrantClaimsSet());
    }

    @Test
    public void testExpired() throws Exception {
        this.init();
        Instant now = Instant.now();
        this.rfClaims = new RefreshTokenClaimsSet.Builder(this.acClaims, now, now.minusMillis(10L)).build();
        TokenRequest req = new TokenRequest(this.callback, new ClientID(this.clientId), (AuthorizationGrant)new RefreshTokenGrant(new RefreshToken(this.rfClaims.serialize(this.getDataSealer()))));
        this.profileRequestCtx.getInboundMessageContext().setMessage((Object)req);
        ActionTestingSupport.assertEvent((Event)this.action.execute(this.requestCtx), (String)"InvalidGrant");
        OIDCAuthenticationResponseContext arc = (OIDCAuthenticationResponseContext)this.profileRequestCtx.getOutboundMessageContext().getSubcontext(OIDCAuthenticationResponseContext.class);
        Assert.assertNull((Object)arc.getAuthorizationGrantClaimsSet());
    }

    @Test
    public void testClientCredentialsSuccess() throws Exception {
        this.init();
        TokenRequest req = new TokenRequest(this.callback, (ClientAuthentication)new ClientSecretBasic(new ClientID(this.clientId), new Secret("foo")), (AuthorizationGrant)new ClientCredentialsGrant());
        this.profileRequestCtx.getInboundMessageContext().setMessage((Object)req);
        ActionTestingSupport.assertProceedEvent((Event)this.action.execute(this.requestCtx));
        OIDCAuthenticationResponseContext arc = (OIDCAuthenticationResponseContext)this.profileRequestCtx.getOutboundMessageContext().getSubcontext(OIDCAuthenticationResponseContext.class);
        Assert.assertNull((Object)arc.getAuthorizationGrantClaimsSet());
    }

    @Test(expectedExceptions={ComponentInitializationException.class})
    public void testNoRevocationCache() throws ComponentInitializationException, NoSuchAlgorithmException {
        this.action = new ValidateGrant(this.getDataSealer());
        ReplayCache replayCache = new ReplayCache();
        MemoryStorageService storageService = new MemoryStorageService();
        storageService.setId("mockId");
        storageService.initialize();
        replayCache.setStorage((StorageService)storageService);
        this.action.setReplayCache(replayCache);
        this.action.initialize();
    }

    @Test(expectedExceptions={ComponentInitializationException.class})
    public void testNoReplayCache() throws ComponentInitializationException, NoSuchAlgorithmException {
        this.action = new ValidateGrant(this.getDataSealer());
        this.action.setRevocationCache((RevocationCache)new BaseOIDCResponseActionTest.MockRevocationCache(this, false, true));
        this.action.initialize();
    }

    @Test(expectedExceptions={ConstraintViolationException.class})
    public void testNoDataSealer() {
        this.action = new ValidateGrant(null);
    }

    private static class DeliveryClaimsSet
    extends ClaimsSet {
        public DeliveryClaimsSet(JSONObject claims) {
            super(claims);
        }
    }
}

