/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.profile.impl;

import com.nimbusds.oauth2.sdk.Scope;
import com.nimbusds.oauth2.sdk.id.ClientID;
import com.nimbusds.openid.connect.sdk.claims.ClaimsSet;
import java.net.URI;
import java.net.URISyntaxException;
import java.time.Instant;
import net.shibboleth.idp.plugin.oidc.op.messaging.context.OIDCAuthenticationResponseTokenClaimsContext;
import net.shibboleth.idp.plugin.oidc.op.profile.impl.BaseOIDCResponseActionTest;
import net.shibboleth.idp.plugin.oidc.op.profile.impl.SetTokenDeliveryAttributesFromTokenToResponseContext;
import net.shibboleth.idp.plugin.oidc.op.token.support.AuthorizeCodeClaimsSet;
import net.shibboleth.idp.plugin.oidc.op.token.support.TokenClaimsSet;
import net.shibboleth.idp.profile.testing.ActionTestingSupport;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.logic.ConstraintViolationException;
import org.springframework.webflow.execution.Event;
import org.testng.Assert;
import org.testng.annotations.Test;

public class SetTokenDeliveryAttributesFromTokenToResponseContextTest
extends BaseOIDCResponseActionTest {
    private SetTokenDeliveryAttributesFromTokenToResponseContext action;

    private void init() throws ComponentInitializationException, URISyntaxException {
        this.action = new SetTokenDeliveryAttributesFromTokenToResponseContext();
        this.action.initialize();
        ClaimsSet dlClaims = new ClaimsSet();
        dlClaims.setClaim("deliveryClaim", (Object)"deliveryClaimValue");
        ClaimsSet dlClaimsUI = new ClaimsSet();
        dlClaimsUI.setClaim("deliveryClaimUI", (Object)"deliveryClaimUIValue");
        ClaimsSet dlClaimsID = new ClaimsSet();
        dlClaimsID.setClaim("deliveryClaimID", (Object)"deliveryClaimIDValue");
        AuthorizeCodeClaimsSet acClaims = (AuthorizeCodeClaimsSet)new AuthorizeCodeClaimsSet.Builder().setJWTID(this.idGenerator).setClientID(new ClientID()).setIssuer("issuer").setPrincipal("userPrin").setSubject(this.subject).setIssuedAt(Instant.now()).setExpiresAt(Instant.now().plusSeconds(100L)).setAuthenticationTime(Instant.now()).setRedirectURI(new URI("http://example.com")).setScope(new Scope()).setDlClaims(dlClaims).setDlClaimsID(dlClaimsID).setDlClaimsUI(dlClaimsUI).build();
        this.respCtx.setAuthorizationGrantClaimsSet((TokenClaimsSet)acClaims);
    }

    @Test
    public void testSuccess() throws ComponentInitializationException, URISyntaxException {
        this.init();
        Event event = this.action.execute(this.requestCtx);
        ActionTestingSupport.assertProceedEvent((Event)event);
        OIDCAuthenticationResponseTokenClaimsContext respTokenClaims = (OIDCAuthenticationResponseTokenClaimsContext)this.respCtx.getSubcontext(OIDCAuthenticationResponseTokenClaimsContext.class);
        Assert.assertNotNull((Object)respTokenClaims);
        Assert.assertEquals((Object)respTokenClaims.getUserinfoClaims().getClaim("deliveryClaimUI"), (Object)"deliveryClaimUIValue");
        Assert.assertEquals((Object)respTokenClaims.getIdtokenClaims().getClaim("deliveryClaimID"), (Object)"deliveryClaimIDValue");
        Assert.assertEquals((Object)respTokenClaims.getClaims().getClaim("deliveryClaim"), (Object)"deliveryClaimValue");
    }

    @Test
    public void testSuccessNoInput() throws ComponentInitializationException, URISyntaxException {
        this.init();
        this.respCtx.setAuthorizationGrantClaimsSet(null);
        Event event = this.action.execute(this.requestCtx);
        ActionTestingSupport.assertProceedEvent((Event)event);
        OIDCAuthenticationResponseTokenClaimsContext respTokenClaims = (OIDCAuthenticationResponseTokenClaimsContext)this.respCtx.getSubcontext(OIDCAuthenticationResponseTokenClaimsContext.class);
        Assert.assertNull((Object)respTokenClaims);
    }

    @Test(expectedExceptions={ConstraintViolationException.class})
    public void testNullStrategyDClaims() {
        this.action = new SetTokenDeliveryAttributesFromTokenToResponseContext();
        this.action.setDeliveryClaimsLookupStrategy(null);
    }

    @Test
    public void testNullStrategyIDTokenDClaims() throws ComponentInitializationException, URISyntaxException {
        this.init();
        this.action = new SetTokenDeliveryAttributesFromTokenToResponseContext();
        this.action.setIDTokenDeliveryClaimsLookupStrategy(null);
        this.action.initialize();
        Event event = this.action.execute(this.requestCtx);
        ActionTestingSupport.assertProceedEvent((Event)event);
        OIDCAuthenticationResponseTokenClaimsContext respTokenClaims = (OIDCAuthenticationResponseTokenClaimsContext)this.respCtx.getSubcontext(OIDCAuthenticationResponseTokenClaimsContext.class);
        Assert.assertNotNull((Object)respTokenClaims);
        Assert.assertEquals((Object)respTokenClaims.getUserinfoClaims().getClaim("deliveryClaimUI"), (Object)"deliveryClaimUIValue");
        Assert.assertNull((Object)respTokenClaims.getIdtokenClaims().getClaim("deliveryClaimID"));
        Assert.assertEquals((Object)respTokenClaims.getClaims().getClaim("deliveryClaim"), (Object)"deliveryClaimValue");
    }

    @Test
    public void testNullStrategyUIDClaims() throws ComponentInitializationException, URISyntaxException {
        this.init();
        this.action = new SetTokenDeliveryAttributesFromTokenToResponseContext();
        this.action.setUserinfoDeliveryClaimsLookupStrategy(null);
        this.action.initialize();
        Event event = this.action.execute(this.requestCtx);
        ActionTestingSupport.assertProceedEvent((Event)event);
        OIDCAuthenticationResponseTokenClaimsContext respTokenClaims = (OIDCAuthenticationResponseTokenClaimsContext)this.respCtx.getSubcontext(OIDCAuthenticationResponseTokenClaimsContext.class);
        Assert.assertNotNull((Object)respTokenClaims);
        Assert.assertNull((Object)respTokenClaims.getUserinfoClaims().getClaim("deliveryClaimUI"));
        Assert.assertEquals((Object)respTokenClaims.getIdtokenClaims().getClaim("deliveryClaimID"), (Object)"deliveryClaimIDValue");
        Assert.assertEquals((Object)respTokenClaims.getClaims().getClaim("deliveryClaim"), (Object)"deliveryClaimValue");
    }
}

