/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.profile.impl;

import com.nimbusds.oauth2.sdk.Scope;
import com.nimbusds.oauth2.sdk.id.ClientID;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.NoSuchAlgorithmException;
import java.time.Instant;
import java.util.function.Function;
import net.shibboleth.idp.plugin.oidc.op.profile.context.navigate.TokenRequestSubjectLookupFunction;
import net.shibboleth.idp.plugin.oidc.op.profile.impl.BaseOIDCResponseActionTest;
import net.shibboleth.idp.plugin.oidc.op.profile.impl.SetSubjectToResponseContext;
import net.shibboleth.idp.plugin.oidc.op.token.support.AccessTokenClaimsSet;
import net.shibboleth.idp.plugin.oidc.op.token.support.TokenClaimsSet;
import net.shibboleth.idp.profile.testing.ActionTestingSupport;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.UnmodifiableComponentException;
import net.shibboleth.utilities.java.support.logic.ConstraintViolationException;
import org.springframework.webflow.execution.Event;
import org.testng.Assert;
import org.testng.annotations.Test;

public class SetSubjectToResponseContextTest
extends BaseOIDCResponseActionTest {
    private SetSubjectToResponseContext action;

    private void init() throws ComponentInitializationException {
        this.action = new SetSubjectToResponseContext();
        this.action.initialize();
    }

    @Test
    public void testNoSubject() throws ComponentInitializationException {
        this.init();
        Event event = this.action.execute(this.requestCtx);
        ActionTestingSupport.assertEvent((Event)event, (String)"InvalidSubject");
    }

    @Test(expectedExceptions={ConstraintViolationException.class})
    public void testNoStrategy() {
        this.action = new SetSubjectToResponseContext();
        this.action.setSubjectLookupStrategy(null);
    }

    @Test(expectedExceptions={UnmodifiableComponentException.class})
    public void testInitialized() throws NoSuchAlgorithmException, ComponentInitializationException {
        this.init();
        this.action.setSubjectLookupStrategy((Function)new TokenRequestSubjectLookupFunction());
    }

    @Test
    public void testSuccess() throws ComponentInitializationException, URISyntaxException {
        this.init();
        TokenClaimsSet claims = new AccessTokenClaimsSet.Builder().setJWTID(this.idGenerator).setClientID(new ClientID()).setIssuer("issuer").setPrincipal("userPrin").setSubject("subject").setIssuedAt(Instant.now()).setExpiresAt(Instant.now()).setAuthenticationTime(Instant.now()).setRedirectURI(new URI("http://example.com")).setScope(new Scope()).build();
        this.respCtx.setAuthorizationGrantClaimsSet(claims);
        Event event = this.action.execute(this.requestCtx);
        ActionTestingSupport.assertProceedEvent((Event)event);
        Assert.assertEquals((String)this.respCtx.getSubject(), (String)"subject");
    }
}

