/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.profile.impl;

import com.nimbusds.jwt.JWT;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.PlainJWT;
import com.nimbusds.oauth2.sdk.ResponseType;
import com.nimbusds.oauth2.sdk.Scope;
import com.nimbusds.oauth2.sdk.id.ClientID;
import com.nimbusds.oauth2.sdk.id.State;
import com.nimbusds.openid.connect.sdk.AuthenticationRequest;
import com.nimbusds.openid.connect.sdk.OIDCClaimsRequest;
import com.nimbusds.openid.connect.sdk.claims.ClaimRequirement;
import com.nimbusds.openid.connect.sdk.claims.ClaimsSetRequest;
import java.net.URI;
import net.shibboleth.idp.plugin.oidc.op.profile.impl.BaseOIDCResponseActionTest;
import net.shibboleth.idp.plugin.oidc.op.profile.impl.SetRequestedSubjectToResponseContext;
import net.shibboleth.idp.profile.testing.ActionTestingSupport;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import org.springframework.webflow.execution.Event;
import org.testng.Assert;
import org.testng.annotations.Test;

public class SetRequestedSubjectToResponseContextTest
extends BaseOIDCResponseActionTest {
    private SetRequestedSubjectToResponseContext action;

    private void init() throws ComponentInitializationException {
        this.action = new SetRequestedSubjectToResponseContext();
        this.action.initialize();
    }

    @Test
    public void testNoReqSubject() throws ComponentInitializationException {
        this.init();
        this.respCtx.setRequestedSubject(null);
        Event event = this.action.execute(this.requestCtx);
        ActionTestingSupport.assertProceedEvent((Event)event);
        Assert.assertNull((Object)this.respCtx.getRequestedSubject());
    }

    @Test
    public void testIdTokenHint() throws ComponentInitializationException {
        this.init();
        PlainJWT idTokenHint = new PlainJWT(new JWTClaimsSet.Builder().subject("reqsubidtokenhint").build());
        AuthenticationRequest req = new AuthenticationRequest.Builder(new ResponseType(new String[]{"code"}), new Scope(new String[]{"openid"}), new ClientID("000123"), URI.create("https://example.com/callback")).idTokenHint((JWT)idTokenHint).state(new State()).build();
        this.setAuthenticationRequest(req);
        Event event = this.action.execute(this.requestCtx);
        ActionTestingSupport.assertProceedEvent((Event)event);
        Assert.assertEquals((String)this.respCtx.getRequestedSubject(), (String)"reqsubidtokenhint");
    }

    @Test
    public void testClaimsRequest() throws ComponentInitializationException {
        this.init();
        ClaimsSetRequest.Entry entry = new ClaimsSetRequest.Entry("sub").withClaimRequirement(ClaimRequirement.ESSENTIAL).withValue("reqsubclaims");
        OIDCClaimsRequest claims = new OIDCClaimsRequest().withIDTokenClaimsRequest(new ClaimsSetRequest().add(entry));
        AuthenticationRequest req = new AuthenticationRequest.Builder(new ResponseType(new String[]{"code"}), new Scope(new String[]{"openid"}), new ClientID("000123"), URI.create("https://example.com/callback")).claims(claims).state(new State()).build();
        this.setAuthenticationRequest(req);
        this.respCtx.setRequestedClaims(claims);
        Event event = this.action.execute(this.requestCtx);
        ActionTestingSupport.assertProceedEvent((Event)event);
        Assert.assertEquals((String)this.respCtx.getRequestedSubject(), (String)"reqsubclaims");
    }

    @Test
    public void testMixed() throws ComponentInitializationException {
        this.init();
        ClaimsSetRequest.Entry entry = new ClaimsSetRequest.Entry("sub").withClaimRequirement(ClaimRequirement.ESSENTIAL).withValue("reqsubclaims");
        PlainJWT idTokenHint = new PlainJWT(new JWTClaimsSet.Builder().subject("reqsubidtokenhint").build());
        OIDCClaimsRequest claims = new OIDCClaimsRequest().withIDTokenClaimsRequest(new ClaimsSetRequest().add(entry));
        AuthenticationRequest req = new AuthenticationRequest.Builder(new ResponseType(new String[]{"code"}), new Scope(new String[]{"openid"}), new ClientID("000123"), URI.create("https://example.com/callback")).idTokenHint((JWT)idTokenHint).claims(claims).state(new State()).build();
        this.setAuthenticationRequest(req);
        this.respCtx.setRequestedClaims(claims);
        Event event = this.action.execute(this.requestCtx);
        ActionTestingSupport.assertProceedEvent((Event)event);
        Assert.assertEquals((String)this.respCtx.getRequestedSubject(), (String)"reqsubclaims");
    }
}

