/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.profile.impl;

import com.google.common.base.Predicates;
import java.security.NoSuchAlgorithmException;
import java.util.function.Predicate;
import net.shibboleth.idp.plugin.oidc.op.profile.impl.BaseOIDCResponseActionTest;
import net.shibboleth.idp.plugin.oidc.op.profile.impl.PopulateOIDCEncryptionParameters;
import net.shibboleth.idp.profile.context.RelyingPartyContext;
import net.shibboleth.idp.profile.testing.ActionTestingSupport;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.logic.ConstraintViolationException;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import net.shibboleth.utilities.java.support.resolver.ResolverException;
import org.opensaml.saml.saml2.profile.context.EncryptionContext;
import org.opensaml.xmlsec.EncryptionParameters;
import org.opensaml.xmlsec.EncryptionParametersResolver;
import org.springframework.webflow.execution.Event;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class PopulateOIDCEncryptionParametersTest
extends BaseOIDCResponseActionTest {
    private PopulateOIDCEncryptionParameters action;
    private MockEncryptionParametersResolver resolver;

    @BeforeMethod
    private void init() throws ComponentInitializationException {
        this.action = new PopulateOIDCEncryptionParameters();
        this.resolver = new MockEncryptionParametersResolver();
        this.action.setEncryptionParametersResolver((EncryptionParametersResolver)this.resolver);
        this.action.initialize();
    }

    @Test
    public void testSuccessEncryption() throws NoSuchAlgorithmException, ComponentInitializationException {
        ActionTestingSupport.assertProceedEvent((Event)this.action.execute(this.requestCtx));
        Assert.assertNotNull((Object)((EncryptionContext)((RelyingPartyContext)this.profileRequestCtx.getSubcontext(RelyingPartyContext.class)).getSubcontext(EncryptionContext.class)).getAssertionEncryptionParameters());
    }

    @Test
    public void testSuccessDecryption() throws NoSuchAlgorithmException, ComponentInitializationException {
        this.action = new PopulateOIDCEncryptionParameters();
        this.action.setForDecryption(true);
        this.action.setEncryptionParametersResolver((EncryptionParametersResolver)new MockEncryptionParametersResolver());
        this.action.initialize();
        ActionTestingSupport.assertProceedEvent((Event)this.action.execute(this.requestCtx));
        Assert.assertNotNull((Object)((EncryptionContext)((RelyingPartyContext)this.profileRequestCtx.getSubcontext(RelyingPartyContext.class)).getSubcontext(EncryptionContext.class)).getAttributeEncryptionParameters());
    }

    @Test
    public void testSuccessFailsToResolve() throws NoSuchAlgorithmException, ComponentInitializationException {
        this.resolver.resolve = false;
        this.action = new PopulateOIDCEncryptionParameters();
        this.action.setEncryptionOptionalPredicate((Predicate)Predicates.alwaysTrue());
        this.action.setEncryptionParametersResolver((EncryptionParametersResolver)this.resolver);
        this.action.initialize();
        ActionTestingSupport.assertProceedEvent((Event)this.action.execute(this.requestCtx));
        Assert.assertNull((Object)((EncryptionContext)((RelyingPartyContext)this.profileRequestCtx.getSubcontext(RelyingPartyContext.class)).getSubcontext(EncryptionContext.class)).getAssertionEncryptionParameters());
    }

    @Test
    public void testFailureFailsToResolve() throws NoSuchAlgorithmException, ComponentInitializationException {
        this.resolver.resolve = false;
        this.action = new PopulateOIDCEncryptionParameters();
        this.action.setEncryptionOptionalPredicate((Predicate)Predicates.alwaysFalse());
        this.action.setEncryptionParametersResolver((EncryptionParametersResolver)this.resolver);
        this.action.initialize();
        ActionTestingSupport.assertEvent((Event)this.action.execute(this.requestCtx), (String)"InvalidSecurityConfiguration");
    }

    @Test(expectedExceptions={ConstraintViolationException.class})
    public void testFailureNullStrategyConf() {
        this.action = new PopulateOIDCEncryptionParameters();
        this.action.setConfigurationLookupStrategy(null);
    }

    @Test(expectedExceptions={ConstraintViolationException.class})
    public void testFailureNullStrategyEncrContext() {
        this.action = new PopulateOIDCEncryptionParameters();
        this.action.setEncryptionContextLookupStrategy(null);
    }

    @Test(expectedExceptions={ConstraintViolationException.class})
    public void testFailureNullStrategyMetadataContext() {
        this.action = new PopulateOIDCEncryptionParameters();
        this.action.setOidcMetadataContextLookupStrategy(null);
    }

    @Test(expectedExceptions={ConstraintViolationException.class})
    public void testFailureNullStrategyEncrParamas() {
        this.action = new PopulateOIDCEncryptionParameters();
        this.action.setEncryptionParametersResolver(null);
    }

    public class MockEncryptionParametersResolver
    implements EncryptionParametersResolver {
        public boolean resolve = true;

        public Iterable<EncryptionParameters> resolve(CriteriaSet criteria) throws ResolverException {
            return null;
        }

        public EncryptionParameters resolveSingle(CriteriaSet criteria) throws ResolverException {
            return this.resolve ? new EncryptionParameters() : null;
        }
    }
}

