/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.profile.impl;

import com.nimbusds.openid.connect.sdk.rp.OIDCClientMetadata;
import java.util.Map;
import net.minidev.json.JSONObject;
import net.shibboleth.idp.plugin.oidc.op.messaging.context.OIDCClientRegistrationMetadataPolicyContext;
import net.shibboleth.idp.plugin.oidc.op.profile.impl.AbstractOIDCClientMetadataPopulationAction;
import net.shibboleth.idp.plugin.oidc.op.profile.impl.AddRemainingClaimsToClientMetadata;
import net.shibboleth.idp.plugin.oidc.op.profile.impl.BaseOIDCClientMetadataPopulationTest;
import net.shibboleth.oidc.metadata.policy.MetadataPolicy;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class AddRemainingClaimsToClientMetadataTest
extends BaseOIDCClientMetadataPopulationTest {
    AddRemainingClaimsToClientMetadata action;

    @BeforeMethod
    public void setUp() throws ComponentInitializationException {
        this.action = new AddRemainingClaimsToClientMetadata();
        this.action.initialize();
    }

    @Override
    protected AbstractOIDCClientMetadataPopulationAction constructAction() {
        return new AddRemainingClaimsToClientMetadata();
    }

    protected void setUpContext(OIDCClientMetadata input, OIDCClientMetadata output, Map<String, MetadataPolicy> metadataPolicy) throws ComponentInitializationException {
        super.setUpContext(input, output);
        OIDCClientRegistrationMetadataPolicyContext policyCtx = (OIDCClientRegistrationMetadataPolicyContext)this.profileRequestCtx.getInboundMessageContext().getSubcontext(OIDCClientRegistrationMetadataPolicyContext.class);
        policyCtx.setMetadataPolicy(metadataPolicy);
    }

    @Test
    public void testUnknownNotIncludedWhenNullPolicy() throws ComponentInitializationException {
        OIDCClientMetadata request = new OIDCClientMetadata();
        request.setCustomField("nonStandardField", (Object)"mockValue");
        OIDCClientMetadata result = new OIDCClientMetadata();
        this.setUpContext(request, result);
        Assert.assertNull((Object)this.action.execute(this.requestCtx));
        JSONObject resultJson = result.toJSONObject(true);
        Assert.assertFalse((boolean)resultJson.containsKey((Object)"nonStandardField"));
    }

    @Test
    public void testUnknownNotIncludedWhenEmptyPolicy() throws ComponentInitializationException {
        OIDCClientMetadata request = new OIDCClientMetadata();
        request.setCustomField("nonStandardField", (Object)"mockValue");
        OIDCClientMetadata result = new OIDCClientMetadata();
        this.setUpContext(request, result, Map.of());
        Assert.assertNull((Object)this.action.execute(this.requestCtx));
        JSONObject resultJson = result.toJSONObject(true);
        Assert.assertFalse((boolean)resultJson.containsKey((Object)"nonStandardField"));
    }

    @Test
    public void testUnknownNotIncludedWhenNotInPolicy() throws ComponentInitializationException {
        OIDCClientMetadata request = new OIDCClientMetadata();
        request.setCustomField("nonStandardField", (Object)"mockValue");
        OIDCClientMetadata result = new OIDCClientMetadata();
        this.setUpContext(request, result, Map.of("anotherField", new MetadataPolicy()));
        Assert.assertNull((Object)this.action.execute(this.requestCtx));
        JSONObject resultJson = result.toJSONObject(true);
        Assert.assertFalse((boolean)resultJson.containsKey((Object)"nonStandardField"));
    }

    @Test
    public void testKnownIncluded() throws ComponentInitializationException {
        OIDCClientMetadata request = new OIDCClientMetadata();
        request.setCustomField("nonStandardField", (Object)"mockValue");
        OIDCClientMetadata result = new OIDCClientMetadata();
        this.setUpContext(request, result, Map.of("nonStandardField", new MetadataPolicy()));
        Assert.assertNull((Object)this.action.execute(this.requestCtx));
        JSONObject resultJson = result.toJSONObject(true);
        Assert.assertTrue((boolean)resultJson.containsKey((Object)"nonStandardField"));
    }

    @Test
    public void testOnlyKnownOnesAreIncluded() throws ComponentInitializationException {
        OIDCClientMetadata request = new OIDCClientMetadata();
        request.setCustomField("nonStandardField1", (Object)"mockValue1");
        request.setCustomField("nonStandardField2", (Object)"mockValue2");
        request.setCustomField("nonStandardField3", (Object)"mockValue3");
        request.setCustomField("nonStandardField4", (Object)"mockValue4");
        OIDCClientMetadata result = new OIDCClientMetadata();
        this.setUpContext(request, result, Map.of("nonStandardField1", new MetadataPolicy(), "nonStandardField4", new MetadataPolicy()));
        Assert.assertNull((Object)this.action.execute(this.requestCtx));
        JSONObject resultJson = result.toJSONObject(true);
        Assert.assertTrue((boolean)resultJson.containsKey((Object)"nonStandardField1"));
        Assert.assertEquals((Object)resultJson.get((Object)"nonStandardField1"), (Object)"mockValue1");
        Assert.assertFalse((boolean)resultJson.containsKey((Object)"nonStandardField2"));
        Assert.assertFalse((boolean)resultJson.containsKey((Object)"nonStandardField3"));
        Assert.assertTrue((boolean)resultJson.containsKey((Object)"nonStandardField4"));
        Assert.assertEquals((Object)resultJson.get((Object)"nonStandardField4"), (Object)"mockValue4");
    }
}

