/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.oauth2.profile.impl;

import com.nimbusds.oauth2.sdk.AuthorizationCode;
import com.nimbusds.oauth2.sdk.AuthorizationCodeGrant;
import com.nimbusds.oauth2.sdk.AuthorizationGrant;
import com.nimbusds.oauth2.sdk.ClientCredentialsGrant;
import com.nimbusds.oauth2.sdk.Scope;
import com.nimbusds.oauth2.sdk.TokenRequest;
import com.nimbusds.oauth2.sdk.auth.ClientAuthentication;
import com.nimbusds.oauth2.sdk.auth.ClientSecretBasic;
import com.nimbusds.oauth2.sdk.auth.Secret;
import com.nimbusds.oauth2.sdk.id.ClientID;
import com.nimbusds.openid.connect.sdk.claims.ACR;
import com.nimbusds.openid.connect.sdk.rp.OIDCClientInformation;
import com.nimbusds.openid.connect.sdk.rp.OIDCClientMetadata;
import java.net.URI;
import java.net.URISyntaxException;
import java.time.Instant;
import java.util.Collection;
import java.util.List;
import net.shibboleth.idp.plugin.oidc.op.oauth2.profile.impl.ValidateAudience;
import net.shibboleth.idp.plugin.oidc.op.profile.impl.BaseOIDCResponseActionTest;
import net.shibboleth.idp.plugin.oidc.op.token.support.AuthorizeCodeClaimsSet;
import net.shibboleth.idp.plugin.oidc.op.token.support.TokenClaimsSet;
import net.shibboleth.idp.profile.testing.ActionTestingSupport;
import net.shibboleth.oidc.metadata.context.OIDCMetadataContext;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import org.springframework.webflow.execution.Event;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class ValidateAudienceTest
extends BaseOIDCResponseActionTest {
    private ValidateAudience action;
    private OIDCClientMetadata metaData;

    @BeforeMethod
    private void init() throws ComponentInitializationException, URISyntaxException {
        this.action = new ValidateAudience();
        this.action.initialize();
        OIDCMetadataContext oidcCtx = (OIDCMetadataContext)this.profileRequestCtx.getInboundMessageContext().getSubcontext(OIDCMetadataContext.class, true);
        this.metaData = new OIDCClientMetadata();
        this.metaData.setCustomField("audience", List.of("https://sp.example.org", "https://sp2.example.org"));
        OIDCClientInformation information = new OIDCClientInformation(new ClientID("test"), null, this.metaData, null, null, null);
        oidcCtx.setClientInformation(information);
    }

    @Test
    public void testTokenNoneAllowed() throws ComponentInitializationException, URISyntaxException {
        TokenRequest req = new TokenRequest(new URI("http://localhost"), (ClientAuthentication)new ClientSecretBasic(new ClientID("s6BhdRkqt3"), new Secret("foo")), (AuthorizationGrant)new ClientCredentialsGrant(), null, List.of(new URI("https://sp3.example.org")), null);
        this.setTokenRequest(req);
        Event event = this.action.execute(this.requestCtx);
        ActionTestingSupport.assertEvent((Event)event, (String)"InvalidTarget");
    }

    @Test
    public void testTokenSuccess() throws ComponentInitializationException, URISyntaxException {
        TokenRequest req = new TokenRequest(new URI("http://localhost"), (ClientAuthentication)new ClientSecretBasic(new ClientID("s6BhdRkqt3"), new Secret("foo")), (AuthorizationGrant)new ClientCredentialsGrant(), null, List.of(new URI("https://sp.example.org"), new URI("https://sp3.example.org"), new URI("https://sp2.example.org")), null);
        this.setTokenRequest(req);
        Event event = this.action.execute(this.requestCtx);
        ActionTestingSupport.assertProceedEvent((Event)event);
        Assert.assertEquals((Collection)this.respCtx.getAudience(), List.of("https://sp.example.org", "https://sp2.example.org"));
    }

    @Test
    public void testTokenFirstAudience() throws ComponentInitializationException, URISyntaxException {
        TokenRequest req = new TokenRequest(new URI("http://localhost"), (ClientAuthentication)new ClientSecretBasic(new ClientID("s6BhdRkqt3"), new Secret("foo")), (AuthorizationGrant)new ClientCredentialsGrant(), null);
        this.setTokenRequest(req);
        Event event = this.action.execute(this.requestCtx);
        ActionTestingSupport.assertProceedEvent((Event)event);
        Assert.assertEquals((Collection)this.respCtx.getAudience(), List.of("https://sp.example.org"));
    }

    @Test
    public void testTokenFailNonePrevGranted() throws ComponentInitializationException, URISyntaxException {
        TokenRequest req = new TokenRequest(new URI("http://localhost"), (ClientAuthentication)new ClientSecretBasic(new ClientID("s6BhdRkqt3"), new Secret("foo")), (AuthorizationGrant)new AuthorizationCodeGrant(new AuthorizationCode("foo"), new URI("http://localhost")), null, List.of(new URI("https://sp.example.org")), null);
        this.setTokenRequest(req);
        AuthorizeCodeClaimsSet claims = (AuthorizeCodeClaimsSet)new AuthorizeCodeClaimsSet.Builder().setJWTID(this.idGenerator).setClientID(new ClientID("s6BhdRkqt3")).setIssuer("issuer").setPrincipal("userPrin").setSubject("subject").setIssuedAt(Instant.now()).setExpiresAt(Instant.now()).setAuthenticationTime(Instant.now()).setRedirectURI(new URI("http://localhost")).setACR(new ACR("0")).setScope(new Scope()).build();
        this.respCtx.setAuthorizationGrantClaimsSet((TokenClaimsSet)claims);
        Event event = this.action.execute(this.requestCtx);
        ActionTestingSupport.assertEvent((Event)event, (String)"InvalidTarget");
    }

    @Test
    public void testTokenFailPrevGranted() throws ComponentInitializationException, URISyntaxException {
        TokenRequest req = new TokenRequest(new URI("http://localhost"), (ClientAuthentication)new ClientSecretBasic(new ClientID("s6BhdRkqt3"), new Secret("foo")), (AuthorizationGrant)new AuthorizationCodeGrant(new AuthorizationCode("foo"), new URI("http://localhost")), null, List.of(new URI("https://sp3.example.org")), null);
        this.setTokenRequest(req);
        AuthorizeCodeClaimsSet claims = (AuthorizeCodeClaimsSet)new AuthorizeCodeClaimsSet.Builder().setJWTID(this.idGenerator).setClientID(new ClientID("s6BhdRkqt3")).setIssuer("issuer").setPrincipal("userPrin").setSubject("subject").setIssuedAt(Instant.now()).setExpiresAt(Instant.now()).setAuthenticationTime(Instant.now()).setRedirectURI(new URI("http://localhost")).setScope(Scope.parse((String)"openid email")).setAudience(List.of("https://sp3.example.org")).setACR(new ACR("0")).build();
        this.respCtx.setAuthorizationGrantClaimsSet((TokenClaimsSet)claims);
        Event event = this.action.execute(this.requestCtx);
        ActionTestingSupport.assertEvent((Event)event, (String)"InvalidTarget");
    }
}

