/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.attribute.filter.policyrule.impl;

import com.nimbusds.oauth2.sdk.Scope;
import net.shibboleth.idp.attribute.filter.PolicyRequirementRule;
import net.shibboleth.idp.attribute.filter.context.AttributeFilterContext;
import net.shibboleth.idp.plugin.oidc.op.attribute.filter.policyrule.impl.AttributeOIDCScopePolicyRule;
import net.shibboleth.idp.plugin.oidc.op.messaging.context.OIDCAuthenticationResponseContext;
import net.shibboleth.idp.profile.context.navigate.WebflowRequestContextProfileRequestContextLookup;
import net.shibboleth.idp.profile.testing.RequestContextBuilder;
import org.opensaml.messaging.context.BaseContext;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.profile.context.ProfileRequestContext;
import org.springframework.webflow.execution.RequestContext;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class AttributeOIDCScopePolicyRuleTest {
    private AttributeOIDCScopePolicyRule rule;
    private ProfileRequestContext prc;
    private AttributeFilterContext filtercontext;
    private OIDCAuthenticationResponseContext authRespCtx;
    private MessageContext msgCtx;

    @BeforeMethod
    private void setUp() throws Exception {
        this.rule = new AttributeOIDCScopePolicyRule();
        this.rule.setMatchString("test");
        this.rule.setId("componentId");
        this.rule.initialize();
        RequestContext requestCtx = new RequestContextBuilder().buildRequestContext();
        this.prc = new WebflowRequestContextProfileRequestContextLookup().apply(requestCtx);
        this.msgCtx = new MessageContext();
        this.prc.setOutboundMessageContext(this.msgCtx);
        this.filtercontext = (AttributeFilterContext)this.prc.getSubcontext(AttributeFilterContext.class, true);
        this.authRespCtx = new OIDCAuthenticationResponseContext();
        this.msgCtx.addSubcontext((BaseContext)this.authRespCtx);
        Scope scope = new Scope();
        scope.add("openid");
        scope.add("test");
        this.authRespCtx.setScope(scope);
    }

    @Test
    public void testMatch() throws Exception {
        Assert.assertEquals((Object)PolicyRequirementRule.Tristate.TRUE, (Object)this.rule.matches(this.filtercontext));
    }

    @Test
    public void testNoMatch() throws Exception {
        Scope scope = new Scope();
        scope.add("openid");
        scope.add("test_no_match");
        this.authRespCtx.setScope(scope);
        Assert.assertEquals((Object)PolicyRequirementRule.Tristate.FALSE, (Object)this.rule.matches(this.filtercontext));
    }

    @Test
    public void testNoOIDCRespCtx() throws Exception {
        this.msgCtx.removeSubcontext(OIDCAuthenticationResponseContext.class);
        Assert.assertEquals((Object)PolicyRequirementRule.Tristate.FALSE, (Object)this.rule.matches(this.filtercontext));
    }

    @Test
    public void testNoScope() throws Exception {
        Scope scope = new Scope();
        this.authRespCtx.setScope(scope);
        Assert.assertEquals((Object)PolicyRequirementRule.Tristate.FAIL, (Object)this.rule.matches(this.filtercontext));
    }
}

