/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.profile;

import com.nimbusds.oauth2.sdk.Scope;
import java.util.ArrayList;
import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.IdPAttributeValue;
import net.shibboleth.idp.attribute.StringAttributeValue;
import net.shibboleth.idp.attribute.resolver.ResolutionException;
import net.shibboleth.idp.attribute.resolver.scripted.ScriptedIdPAttribute;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ScopeUtil {
    private static Logger log = LoggerFactory.getLogger(ScopeUtil.class);

    private ScopeUtil() {
    }

    @Nonnull
    public static IdPAttribute buildAttribute(@Nonnull String attributeId, @Nullable Scope scope) {
        IdPAttribute attribute = new IdPAttribute(attributeId);
        if (scope == null || scope.isEmpty()) {
            return attribute;
        }
        ScopeUtil.setAttributeValues(attribute, scope);
        return attribute;
    }

    public static void setAttributeValues(@Nonnull IdPAttribute attribute, @Nullable Scope scope) {
        if (scope == null || scope.isEmpty()) {
            return;
        }
        ArrayList values = new ArrayList(scope.size());
        scope.forEach(value -> values.add(new StringAttributeValue(value.getValue())));
        attribute.setValues(values);
    }

    public static void populateScriptedAttribute(@Nonnull ScriptedIdPAttribute attribute, @Nullable Scope scope) {
        if (scope != null && !scope.isEmpty()) {
            scope.forEach(value -> {
                try {
                    attribute.addValue((Object)value.getValue());
                }
                catch (ResolutionException e) {
                    log.warn("Resolution exception catched when populating attribute", (Throwable)e);
                }
            });
        }
    }

    public static void populateScriptedAttribute(@Nonnull ScriptedIdPAttribute attribute, @Nullable ScriptedIdPAttribute source) throws ResolutionException {
        if (source != null && !source.getValues().isEmpty()) {
            source.getValues().forEach(value -> {
                try {
                    attribute.addValue(value);
                }
                catch (ResolutionException e) {
                    log.warn("Resolution exception catched when populating attribute", (Throwable)e);
                }
            });
        }
    }

    @Nonnull
    public static Scope buildScope(@Nullable IdPAttribute attribute) {
        Scope scope = new Scope();
        if (attribute == null || attribute.getValues().isEmpty()) {
            return scope;
        }
        for (IdPAttributeValue value : attribute.getValues()) {
            if (!(value instanceof StringAttributeValue)) continue;
            scope.add((Object)new Scope.Value(((StringAttributeValue)value).getValue()));
        }
        return scope;
    }

    @Nonnull
    public static Scope buildScope(@Nullable ScriptedIdPAttribute attribute) throws ResolutionException {
        Scope scope = new Scope();
        if (attribute == null) {
            return scope;
        }
        attribute.getValues().forEach(value -> scope.add((Object)new Scope.Value((String)value)));
        return scope;
    }

    @Nonnull
    public static Scope buildIntersectedScope(@Nullable IdPAttribute attribute, @Nullable Scope scope) {
        Scope attributeScope = ScopeUtil.buildScope(attribute);
        if (scope != null) {
            attributeScope.retainAll((Collection)scope);
        }
        return attributeScope;
    }

    @Nonnull
    public static Scope buildIntersectedScope(@Nullable ScriptedIdPAttribute attribute, @Nullable Scope scope) throws ResolutionException {
        Scope attributeScope = ScopeUtil.buildScope(attribute);
        if (scope != null) {
            attributeScope.retainAll((Collection)scope);
        }
        return attributeScope;
    }

    public static void removeValue(@Nonnull Scope scope, @Nonnull String value) {
        scope.remove((Object)new Scope.Value(value));
    }
}

