/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.profile.impl;

import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jwt.JWT;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.PlainJWT;
import com.nimbusds.jwt.SignedJWT;
import com.nimbusds.oauth2.sdk.ResponseType;
import com.nimbusds.oauth2.sdk.id.ClientID;
import java.text.ParseException;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.plugin.oidc.op.profile.impl.AbstractOIDCAuthenticationResponseAction;
import net.shibboleth.oidc.jwt.claims.ClaimsValidator;
import net.shibboleth.oidc.jwt.claims.JWTValidationException;
import net.shibboleth.oidc.security.impl.JWTSignatureValidationUtil;
import net.shibboleth.oidc.security.impl.OIDCSignatureValidationParameters;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullAfterInit;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.xmlsec.context.SecurityParametersContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValidateRequestObject
extends AbstractOIDCAuthenticationResponseAction {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(ValidateRequestObject.class);
    @Nullable
    private OIDCSignatureValidationParameters signatureValidationParameters;
    @Nonnull
    private Function<ProfileRequestContext, SecurityParametersContext> securityParametersLookupStrategy = new ChildContextLookup(SecurityParametersContext.class);
    @Nullable
    private JWT requestObject;
    @NonnullAfterInit
    private ClaimsValidator signedClaimsValidator;
    @NonnullAfterInit
    private ClaimsValidator plainClaimsValidator;

    public void setSecurityParametersLookupStrategy(@Nonnull Function<ProfileRequestContext, SecurityParametersContext> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.securityParametersLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"SecurityParameterContext lookup strategy cannot be null");
    }

    public void setSignedClaimsValidator(@Nonnull ClaimsValidator validator) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.signedClaimsValidator = (ClaimsValidator)Constraint.isNotNull((Object)validator, (String)"Signed claims validator cannot be null");
    }

    public void setPlainClaimsValidator(@Nonnull ClaimsValidator validator) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.plainClaimsValidator = (ClaimsValidator)Constraint.isNotNull((Object)validator, (String)"Plain claims validator cannot be null");
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.signedClaimsValidator == null) {
            throw new ComponentInitializationException("ClaimsValidator for signed requests cannot be null");
        }
        if (this.plainClaimsValidator == null) {
            throw new ComponentInitializationException("ClaimsValidator for plain requests cannot be null");
        }
    }

    @Override
    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (!super.doPreExecute(profileRequestContext)) {
            return false;
        }
        this.requestObject = this.getOidcResponseContext().getRequestObject();
        if (this.requestObject == null) {
            this.log.debug("{} No request object, nothing to do", (Object)this.getLogPrefix());
            return false;
        }
        return true;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        JWTClaimsSet claimsSet;
        SecurityParametersContext secParamCtx;
        String errorEventId;
        if (this.requestObject instanceof PlainJWT) {
            if (this.getMetadataContext() == null) {
                this.log.error("{} Request object unsigned, no client metadata", (Object)this.getLogPrefix());
                ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidRequestObject");
                return;
            }
            JWSAlgorithm requestObjectAlg = this.getMetadataContext().getClientInformation().getOIDCMetadata().getRequestObjectJWSAlg();
            if (requestObjectAlg != null && !"none".equals(requestObjectAlg.getName())) {
                this.log.error("{} Request object is not signed, registered alg is {}", (Object)this.getLogPrefix(), (Object)requestObjectAlg.getName());
                ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidRequestObject");
                return;
            }
        }
        if (!(this.requestObject instanceof PlainJWT) && (errorEventId = JWTSignatureValidationUtil.validateSignature((SecurityParametersContext)(secParamCtx = this.securityParametersLookupStrategy.apply(profileRequestContext)), (SignedJWT)((SignedJWT)this.requestObject), (String)"InvalidRequestObject")) != null) {
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)errorEventId);
            return;
        }
        try {
            claimsSet = this.requestObject.getJWTClaimsSet();
            if (claimsSet.getClaims().containsKey("client_id") && !this.getAuthenticationRequest().getClientID().equals((Object)new ClientID((String)claimsSet.getClaim("client_id")))) {
                this.log.error("{} client_id in request object not matching client_id request parameter", (Object)this.getLogPrefix());
                ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidRequestObject");
                return;
            }
            if (claimsSet.getClaims().containsKey("response_type") && !this.getAuthenticationRequest().getResponseType().equals((Object)new ResponseType(((String)this.requestObject.getJWTClaimsSet().getClaim("response_type")).split(" ")))) {
                this.log.error("{} response_type in request object not matching response_type request parameter", (Object)this.getLogPrefix());
                ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidRequestObject");
                return;
            }
        }
        catch (ParseException e) {
            this.log.error("{} Unable to parse request object {}", (Object)this.getLogPrefix(), (Object)e.getMessage());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidRequestObject");
            return;
        }
        try {
            if (this.requestObject instanceof SignedJWT) {
                this.signedClaimsValidator.validate(claimsSet, profileRequestContext);
            } else {
                this.plainClaimsValidator.validate(claimsSet, profileRequestContext);
            }
        }
        catch (JWTValidationException e) {
            this.log.warn("{} JWT validation failed: {}", (Object)this.getLogPrefix(), (Object)e.getMessage());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidRequestObject");
            return;
        }
    }
}

