/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.profile.impl;

import com.nimbusds.openid.connect.sdk.claims.ClaimsSet;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.plugin.oidc.op.messaging.context.OIDCAuthenticationResponseTokenClaimsContext;
import net.shibboleth.idp.plugin.oidc.op.profile.context.navigate.TokenRequestDeliveryClaimsLookupFunction;
import net.shibboleth.idp.plugin.oidc.op.profile.context.navigate.TokenRequestIDTokenDeliveryClaimsLookupFunction;
import net.shibboleth.idp.plugin.oidc.op.profile.context.navigate.TokenRequestUserInfoDeliveryClaimsLookupFunction;
import net.shibboleth.idp.plugin.oidc.op.profile.impl.AbstractOIDCResponseAction;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SetTokenDeliveryAttributesFromTokenToResponseContext
extends AbstractOIDCResponseAction {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(SetTokenDeliveryAttributesFromTokenToResponseContext.class);
    @Nonnull
    private Function<ProfileRequestContext, ClaimsSet> deliveryClaimsLookupStrategy = new TokenRequestDeliveryClaimsLookupFunction();
    @Nonnull
    private Function<ProfileRequestContext, ClaimsSet> idTokenDeliveryClaimsLookupStrategy = new TokenRequestIDTokenDeliveryClaimsLookupFunction();
    @Nonnull
    private Function<ProfileRequestContext, ClaimsSet> userinfoDeliveryClaimsLookupStrategy = new TokenRequestUserInfoDeliveryClaimsLookupFunction();

    public void setDeliveryClaimsLookupStrategy(@Nonnull Function<ProfileRequestContext, ClaimsSet> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.deliveryClaimsLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"DeliveryClaimsLookupStrategy lookup strategy cannot be null");
    }

    public void setIDTokenDeliveryClaimsLookupStrategy(@Nullable Function<ProfileRequestContext, ClaimsSet> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.idTokenDeliveryClaimsLookupStrategy = strategy;
    }

    public void setUserinfoDeliveryClaimsLookupStrategy(@Nullable Function<ProfileRequestContext, ClaimsSet> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.userinfoDeliveryClaimsLookupStrategy = strategy;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        OIDCAuthenticationResponseTokenClaimsContext tokenClaimsCtx;
        ClaimsSet claims = this.deliveryClaimsLookupStrategy.apply(profileRequestContext);
        if (claims != null) {
            tokenClaimsCtx = (OIDCAuthenticationResponseTokenClaimsContext)this.getOidcResponseContext().getSubcontext(OIDCAuthenticationResponseTokenClaimsContext.class, true);
            tokenClaimsCtx.getClaims().putAll(claims);
        }
        if (this.idTokenDeliveryClaimsLookupStrategy != null && (claims = this.idTokenDeliveryClaimsLookupStrategy.apply(profileRequestContext)) != null) {
            tokenClaimsCtx = (OIDCAuthenticationResponseTokenClaimsContext)this.getOidcResponseContext().getSubcontext(OIDCAuthenticationResponseTokenClaimsContext.class, true);
            tokenClaimsCtx.getIdtokenClaims().putAll(claims);
        }
        if (this.userinfoDeliveryClaimsLookupStrategy != null && (claims = this.userinfoDeliveryClaimsLookupStrategy.apply(profileRequestContext)) != null) {
            tokenClaimsCtx = (OIDCAuthenticationResponseTokenClaimsContext)this.getOidcResponseContext().getSubcontext(OIDCAuthenticationResponseTokenClaimsContext.class, true);
            tokenClaimsCtx.getUserinfoClaims().putAll(claims);
        }
    }
}

