/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.profile.impl;

import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.attribute.context.AttributeContext;
import net.shibboleth.idp.plugin.oidc.op.messaging.context.OIDCAuthenticationResponseConsentContext;
import net.shibboleth.idp.plugin.oidc.op.profile.impl.AbstractOIDCResponseAction;
import net.shibboleth.idp.profile.context.RelyingPartyContext;
import net.shibboleth.oidc.profile.config.logic.AttributeConsentFlowEnabledPredicate;
import net.shibboleth.oidc.profile.config.logic.EncodeConsentPredicate;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SetConsentToResponseContext
extends AbstractOIDCResponseAction {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(SetConsentToResponseContext.class);
    @Nonnull
    private Function<ProfileRequestContext, AttributeContext> attributeContextLookupStrategy = new ChildContextLookup(AttributeContext.class).compose((Function)new ChildContextLookup(RelyingPartyContext.class));
    @Nonnull
    private Predicate<ProfileRequestContext> consentEnabledPredicate = new AttributeConsentFlowEnabledPredicate();
    @Nonnull
    private Predicate<ProfileRequestContext> encodeConsentPredicate = new EncodeConsentPredicate();
    @Nullable
    private AttributeContext attributeCtx;

    SetConsentToResponseContext() {
    }

    public void setAttributeContextLookupStrategy(@Nonnull Function<ProfileRequestContext, AttributeContext> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.attributeContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"AttributeContext lookup strategy cannot be null");
    }

    public void setConsentEnabledPredicate(@Nonnull Predicate<ProfileRequestContext> predicate) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.consentEnabledPredicate = (Predicate)Constraint.isNotNull(predicate, (String)"Predicate cannot be null");
    }

    public void setEncodeConsentPredicate(@Nonnull Predicate<ProfileRequestContext> predicate) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.encodeConsentPredicate = (Predicate)Constraint.isNotNull(predicate, (String)"Predicate cannot be null");
    }

    @Override
    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (!super.doPreExecute(profileRequestContext)) {
            return false;
        }
        if (!this.consentEnabledPredicate.test(profileRequestContext)) {
            this.log.debug("{} Attribute consent has not been enabled, nothing to do", (Object)this.getLogPrefix());
            return false;
        }
        this.attributeCtx = this.attributeContextLookupStrategy.apply(profileRequestContext);
        if (this.attributeCtx == null) {
            this.log.debug("{} No AttributeSubcontext available, nothing to do", (Object)this.getLogPrefix());
            return false;
        }
        if (!this.attributeCtx.isConsented() && !this.encodeConsentPredicate.test(profileRequestContext)) {
            this.log.debug("{} Consent is not being encoded into tokens, nothing to do", (Object)this.getLogPrefix());
            return false;
        }
        return true;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        OIDCAuthenticationResponseConsentContext oidcConsentCtx = (OIDCAuthenticationResponseConsentContext)this.getOidcResponseContext().getSubcontext(OIDCAuthenticationResponseConsentContext.class, true);
        Map consented = this.attributeCtx.getIdPAttributes();
        oidcConsentCtx.getConsentedAttributes().addAll(consented.keySet());
        this.log.debug("{} Set to response context consented attributes {} and consentable attributes {}", (Object)this.getLogPrefix(), (Object)oidcConsentCtx.getConsentedAttributes().toJSONString());
    }
}

