/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.profile.impl;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWEAlgorithm;
import com.nimbusds.jose.JWEDecrypter;
import com.nimbusds.jose.crypto.AESDecrypter;
import com.nimbusds.jose.crypto.ECDHDecrypter;
import com.nimbusds.jose.crypto.RSADecrypter;
import com.nimbusds.jwt.EncryptedJWT;
import com.nimbusds.jwt.JWT;
import com.nimbusds.jwt.JWTParser;
import java.security.interfaces.ECPrivateKey;
import java.text.ParseException;
import java.util.Iterator;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.plugin.oidc.op.profile.impl.AbstractOIDCAuthenticationResponseAction;
import net.shibboleth.idp.profile.context.RelyingPartyContext;
import net.shibboleth.oidc.security.impl.OIDCDecryptionParameters;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.saml.saml2.profile.context.EncryptionContext;
import org.opensaml.security.credential.Credential;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DecryptRequestObject
extends AbstractOIDCAuthenticationResponseAction {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(DecryptRequestObject.class);
    @Nonnull
    private Function<ProfileRequestContext, EncryptionContext> encryptionContextLookupStrategy = new ChildContextLookup(EncryptionContext.class).compose((Function)new ChildContextLookup(RelyingPartyContext.class));
    @Nullable
    private OIDCDecryptionParameters params;
    @Nullable
    private JWT requestObject;

    public void setEncryptionContextLookupStrategy(@Nonnull Function<ProfileRequestContext, EncryptionContext> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.encryptionContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"EncryptionContext lookup strategy cannot be null");
    }

    @Override
    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (!super.doPreExecute(profileRequestContext)) {
            return false;
        }
        this.requestObject = this.getOidcResponseContext().getRequestObject();
        if (this.requestObject == null) {
            this.log.debug("{} No request object, nothing to do", (Object)this.getLogPrefix());
            return false;
        }
        if (!(this.requestObject instanceof EncryptedJWT)) {
            this.log.debug("{} Request object not encrypted, nothing to do", (Object)this.getLogPrefix());
            return false;
        }
        EncryptionContext encryptCtx = this.encryptionContextLookupStrategy.apply(profileRequestContext);
        if (encryptCtx == null || !(encryptCtx.getAttributeEncryptionParameters() instanceof OIDCDecryptionParameters)) {
            this.log.error("{} Encrypted request object but no EncryptionContext/OIDCDecryptionParameters available", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidSecurityConfiguration");
            return false;
        }
        this.params = (OIDCDecryptionParameters)encryptCtx.getAttributeEncryptionParameters();
        return true;
    }

    private JWT decryptRequestObject(@Nonnull EncryptedJWT encryptedObject) {
        if (!encryptedObject.getHeader().getAlgorithm().getName().equals(this.params.getKeyTransportEncryptionAlgorithm())) {
            this.log.error("{} Request object alg {} not matching expected {}", new Object[]{this.getLogPrefix(), encryptedObject.getHeader().getAlgorithm().getName(), this.params.getKeyTransportEncryptionAlgorithm()});
            return null;
        }
        if (!encryptedObject.getHeader().getEncryptionMethod().getName().equals(this.params.getDataEncryptionAlgorithm())) {
            this.log.error("{} Request object enc {} not matching expected {}", new Object[]{this.getLogPrefix(), encryptedObject.getHeader().getEncryptionMethod().getName(), this.params.getDataEncryptionAlgorithm()});
            return null;
        }
        JWEAlgorithm encAlg = encryptedObject.getHeader().getAlgorithm();
        Iterator it = this.params.getKeyTransportDecryptionCredentials().iterator();
        while (it.hasNext()) {
            Credential credential = (Credential)it.next();
            RSADecrypter decrypter = null;
            try {
                if (JWEAlgorithm.Family.RSA.contains((Object)encAlg)) {
                    decrypter = new RSADecrypter(credential.getPrivateKey());
                }
                if (JWEAlgorithm.Family.ECDH_ES.contains((Object)encAlg)) {
                    decrypter = new ECDHDecrypter((ECPrivateKey)credential.getPrivateKey());
                }
                if (JWEAlgorithm.Family.AES_GCM_KW.contains((Object)encAlg) || JWEAlgorithm.Family.AES_KW.contains((Object)encAlg)) {
                    decrypter = new AESDecrypter(credential.getSecretKey());
                }
                if (decrypter == null) {
                    this.log.error("{} No decrypter for request object for encAlg {}", (Object)this.getLogPrefix(), (Object)encryptedObject.getHeader().getEncryptionMethod().getName());
                    return null;
                }
                encryptedObject.decrypt((JWEDecrypter)decrypter);
                return JWTParser.parse((String)encryptedObject.getPayload().toString());
            }
            catch (JOSEException | ParseException e) {
                if (it.hasNext()) {
                    this.log.debug("{} Unable to decrypt request object with credential, {}, picking next key", (Object)this.getLogPrefix(), (Object)e.getMessage());
                    continue;
                }
                this.log.error("{} Unable to decrypt request object with credential, {}", (Object)this.getLogPrefix(), (Object)e.getMessage());
                return null;
            }
        }
        return null;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        this.requestObject = this.decryptRequestObject((EncryptedJWT)this.requestObject);
        if (this.requestObject == null) {
            this.log.error("{} Unable to decrypt request object", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidRequestObject");
            return;
        }
        this.getOidcResponseContext().setRequestObject(this.requestObject);
        this.log.debug("{} Request object decrypted as {}", (Object)this.getLogPrefix(), (Object)this.getOidcResponseContext().getRequestObject().serialize());
    }
}

