/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.attribute.filter.matcher.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import javax.annotation.Nonnull;
import net.shibboleth.idp.attribute.IdPAttribute;
import net.shibboleth.idp.attribute.IdPAttributeValue;
import net.shibboleth.idp.attribute.IdPRequestedAttribute;
import net.shibboleth.idp.attribute.filter.Matcher;
import net.shibboleth.idp.attribute.filter.context.AttributeFilterContext;
import net.shibboleth.idp.plugin.oidc.op.messaging.context.OIDCAuthenticationResponseContext;
import net.shibboleth.utilities.java.support.component.AbstractIdentifiableInitializableComponent;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import org.opensaml.messaging.context.BaseContext;
import org.opensaml.messaging.context.navigate.RecursiveTypedParentContextLookup;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AttributeInOIDCRequestedClaimsMatcher
extends AbstractIdentifiableInitializableComponent
implements Matcher {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(AttributeInOIDCRequestedClaimsMatcher.class);
    private boolean matchIfRequestedClaimsSilent;
    private boolean matchOnlyIDToken;
    private boolean matchOnlyUserInfo;
    private boolean onlyIfEssential;
    private String logPrefix;

    public boolean getOnlyIfEssential() {
        return this.onlyIfEssential;
    }

    public void setOnlyIfEssential(boolean flag) {
        this.onlyIfEssential = flag;
    }

    public boolean getMatchOnlyIDToken() {
        return this.matchOnlyIDToken;
    }

    public void setMatchOnlyIDToken(boolean flag) {
        this.matchOnlyIDToken = flag;
    }

    public boolean getMatchOnlyUserInfo() {
        return this.matchOnlyUserInfo;
    }

    public void setMatchOnlyUserInfo(boolean flag) {
        this.matchOnlyUserInfo = flag;
    }

    public boolean getMatchIRequestedClaimsSilent() {
        return this.matchIfRequestedClaimsSilent;
    }

    public void setMatchIfRequestedClaimsSilent(boolean flag) {
        this.matchIfRequestedClaimsSilent = flag;
    }

    public Set<IdPAttributeValue> getMatchingValues(@Nonnull IdPAttribute attribute, @Nonnull AttributeFilterContext filtercontext) {
        ComponentSupport.ifNotInitializedThrowUninitializedComponentException((InitializableComponent)this);
        ProfileRequestContext profileRequestContext = (ProfileRequestContext)new RecursiveTypedParentContextLookup(ProfileRequestContext.class).apply((BaseContext)filtercontext);
        if (profileRequestContext == null || profileRequestContext.getOutboundMessageContext() == null) {
            this.log.trace("{} No outbound message context", (Object)this.getLogPrefix());
            return null;
        }
        OIDCAuthenticationResponseContext respCtx = (OIDCAuthenticationResponseContext)profileRequestContext.getOutboundMessageContext().getSubcontext(OIDCAuthenticationResponseContext.class);
        if (respCtx == null) {
            this.log.debug("{} No oidc response ctx for this comparison", (Object)this.getLogPrefix());
            return null;
        }
        if (respCtx.getMappedIdTokenRequestedClaims() == null && respCtx.getMappedUserinfoRequestedClaims() == null) {
            this.log.debug("{} No requested claims", (Object)this.getLogPrefix());
            if (this.getMatchIRequestedClaimsSilent()) {
                this.log.debug("{} all values matched as in silent mode", (Object)this.getLogPrefix());
                return Set.copyOf(attribute.getValues());
            }
            this.log.debug("{} none of the values matched as not silent mode", (Object)this.getLogPrefix());
            return Collections.emptySet();
        }
        if (respCtx.getMappedIdTokenRequestedClaims() != null && !this.getMatchOnlyUserInfo() && respCtx.getMappedIdTokenRequestedClaims().get().containsKey((Object)attribute.getId()) && this.verifyEssentiality(respCtx.getMappedIdTokenRequestedClaims().get().get((Object)attribute.getId()))) {
            this.log.debug("{} All values matched, as {} is a requested ID token claim", (Object)this.getLogPrefix(), (Object)attribute.getId());
            return Set.copyOf(attribute.getValues());
        }
        if (respCtx.getMappedUserinfoRequestedClaims() != null && !this.getMatchOnlyIDToken() && respCtx.getMappedUserinfoRequestedClaims().get().containsKey((Object)attribute.getId()) && this.verifyEssentiality(respCtx.getMappedUserinfoRequestedClaims().get().get((Object)attribute.getId()))) {
            this.log.debug("{} All values matched, as {} is a requested Userinfo claim", (Object)this.getLogPrefix(), (Object)attribute.getId());
            return Set.copyOf(attribute.getValues());
        }
        this.log.debug("{} Attribute {} was not a requested claim, none of the values matched", (Object)this.getLogPrefix(), (Object)attribute.getId());
        return Collections.emptySet();
    }

    private boolean verifyEssentiality(Collection<IdPAttribute> claims) {
        if (this.onlyIfEssential) {
            return claims.stream().filter(IdPRequestedAttribute.class::isInstance).map(IdPRequestedAttribute.class::cast).anyMatch(a -> a.isRequired());
        }
        return true;
    }

    @Nonnull
    protected String getLogPrefix() {
        String prefix = this.logPrefix;
        if (null == prefix) {
            StringBuilder builder = new StringBuilder("Attribute Filter '").append(this.getId()).append("':");
            prefix = builder.toString();
            if (null == this.logPrefix) {
                this.logPrefix = prefix;
            }
        }
        return prefix;
    }
}

