/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.servlet;

import java.util.Set;
import javax.annotation.Nonnull;
import javax.servlet.FilterRegistration;
import javax.servlet.ServletContainerInitializer;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.filter.DelegatingFilterProxy;

public class RegisterFilterServletContextInitializer
implements ServletContainerInitializer {
    public static final String SYSTEM_PROPERTY_ACTIVATION = RegisterFilterServletContextInitializer.class.getCanonicalName();
    public static final String SYSTEM_PROPERTY_MAPPINGS = SYSTEM_PROPERTY_ACTIVATION + ".mappings";
    public static final String FILTER_NAME_DYNAMIC_OIDC_RESPONSE_HEADER = "DynamicOidcResponseHeaderFilter";
    public static final String TARGET_BEAN_NAME = "shibboleth.oidc.ResponseHeaderFilter";
    public static final String DEFAULT_MAPPINGS = "/profile/oidc/* /profile/oauth2/*";
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(RegisterFilterServletContextInitializer.class);

    public void onStartup(Set<Class<?>> c, ServletContext ctx) throws ServletException {
        String mappings;
        String flag = System.getProperty(SYSTEM_PROPERTY_ACTIVATION);
        this.log.debug("The value of the flag {}: {}", (Object)SYSTEM_PROPERTY_ACTIVATION, (Object)flag);
        if ("disabled".equalsIgnoreCase(flag)) {
            this.log.info("The filter registration is disabled according to the system properties");
            return;
        }
        this.log.debug("Attempting to register filter {}", (Object)FILTER_NAME_DYNAMIC_OIDC_RESPONSE_HEADER);
        FilterRegistration.Dynamic headerFilter = ctx.addFilter(FILTER_NAME_DYNAMIC_OIDC_RESPONSE_HEADER, DelegatingFilterProxy.class);
        if (StringSupport.trimOrNull((String)System.getProperty(SYSTEM_PROPERTY_MAPPINGS)) == null) {
            mappings = DEFAULT_MAPPINGS;
            this.log.debug("Using default mappings: {}", (Object)DEFAULT_MAPPINGS);
        } else {
            mappings = System.getProperty(SYSTEM_PROPERTY_MAPPINGS);
            this.log.debug("Using custom mappings: {}", (Object)mappings);
        }
        for (String mapping : mappings.split(" ")) {
            headerFilter.addMappingForUrlPatterns(null, false, new String[]{mapping});
            this.log.debug("Mapping added for the following pattern: {}", (Object)mapping);
        }
        headerFilter.setInitParameter("targetBeanName", TARGET_BEAN_NAME);
        this.log.info("Registered the filter '{}'.", (Object)FILTER_NAME_DYNAMIC_OIDC_RESPONSE_HEADER);
    }
}

