/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.security.impl;

import com.nimbusds.jose.Algorithm;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.jwk.Curve;
import com.nimbusds.openid.connect.sdk.rp.OIDCClientInformation;
import java.security.interfaces.ECKey;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.spec.ECParameterSpec;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import net.shibboleth.idp.plugin.oidc.op.criterion.ClientInformationCriterion;
import net.shibboleth.oidc.security.credential.BasicJWKCredential;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import net.shibboleth.utilities.java.support.resolver.ResolverException;
import org.opensaml.security.credential.Credential;
import org.opensaml.xmlsec.SignatureSigningParameters;
import org.opensaml.xmlsec.criterion.SignatureSigningConfigurationCriterion;
import org.opensaml.xmlsec.impl.BasicSignatureSigningParametersResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OIDCClientInformationSignatureSigningParametersResolver
extends BasicSignatureSigningParametersResolver {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(OIDCClientInformationSignatureSigningParametersResolver.class);
    private ParameterType target = ParameterType.IDTOKEN_SIGNING;

    public void setParameterType(ParameterType value) {
        this.target = value;
    }

    @Nullable
    public SignatureSigningParameters resolveSingle(@Nonnull CriteriaSet criteria) throws ResolverException {
        Constraint.isNotNull((Object)criteria, (String)"CriteriaSet was null");
        Constraint.isNotNull((Object)((SignatureSigningConfigurationCriterion)criteria.get(SignatureSigningConfigurationCriterion.class)), (String)"Resolver requires an instance of SignatureSigningConfigurationCriterion");
        Predicate includeExcludePredicate = this.getIncludeExcludePredicate(criteria);
        SignatureSigningParameters params = new SignatureSigningParameters();
        this.resolveAndPopulateCredentialAndSignatureAlgorithm(params, criteria, includeExcludePredicate);
        if (this.validate(params)) {
            this.logResult(params);
            return params;
        }
        return null;
    }

    private boolean curveMatchesESAlgorithm(Curve curve, JWSAlgorithm algorithm) {
        if (algorithm.equals((Object)JWSAlgorithm.ES256)) {
            return curve.equals((Object)Curve.P_256);
        }
        if (algorithm.equals((Object)JWSAlgorithm.ES384)) {
            return curve.equals((Object)Curve.P_384);
        }
        if (algorithm.equals((Object)JWSAlgorithm.ES512)) {
            return curve.equals((Object)Curve.P_521);
        }
        return false;
    }

    protected void resolveAndPopulateCredentialAndSignatureAlgorithm(@Nonnull SignatureSigningParameters params, @Nonnull CriteriaSet criteria, @Nonnull Predicate<String> whitelistBlacklistPredicate) {
        JWSAlgorithm algorithm;
        this.log.debug("Resolving SignatureSigningParameters, purpose {}", (Object)(this.target.equals((Object)ParameterType.IDTOKEN_SIGNING) ? "id token signing" : "userinfo response signing"));
        if (!criteria.contains(ClientInformationCriterion.class)) {
            this.log.debug("No client criterion, nothing to do");
            super.resolveAndPopulateCredentialAndSignatureAlgorithm(params, criteria, whitelistBlacklistPredicate);
            return;
        }
        OIDCClientInformation clientInformation = ((ClientInformationCriterion)criteria.get(ClientInformationCriterion.class)).getOidcClientInformation();
        if (clientInformation == null) {
            this.log.debug("No client information, nothing to do");
            super.resolveAndPopulateCredentialAndSignatureAlgorithm(params, criteria, whitelistBlacklistPredicate);
            return;
        }
        List credentials = this.getEffectiveSigningCredentials(criteria);
        List algorithms = this.getEffectiveSignatureAlgorithms(criteria, whitelistBlacklistPredicate);
        this.log.trace("Resolved effective signature algorithms: {}", (Object)algorithms);
        JWSAlgorithm jWSAlgorithm = algorithm = this.target == ParameterType.IDTOKEN_SIGNING ? clientInformation.getOIDCMetadata().getIDTokenJWSAlg() : clientInformation.getOIDCMetadata().getUserInfoJWSAlg();
        if (algorithm == null) {
            if (this.target == ParameterType.USERINFO_SIGNING) {
                this.log.debug("No alg defined in client information, nothing to do");
                super.resolveAndPopulateCredentialAndSignatureAlgorithm(params, criteria, whitelistBlacklistPredicate);
                return;
            }
            if (this.target == ParameterType.IDTOKEN_SIGNING) {
                algorithm = JWSAlgorithm.RS256;
            }
        }
        if (algorithm != null && !algorithms.contains(algorithm.getName())) {
            this.log.warn("Client requests algorithm {} that is not available", (Object)algorithm.getName());
            super.resolveAndPopulateCredentialAndSignatureAlgorithm(params, criteria, whitelistBlacklistPredicate);
            return;
        }
        if (JWSAlgorithm.Family.HMAC_SHA.contains((Object)algorithm)) {
            if (clientInformation.getSecret() == null) {
                this.log.warn("No client secret to use as a key");
                super.resolveAndPopulateCredentialAndSignatureAlgorithm(params, criteria, whitelistBlacklistPredicate);
                return;
            }
            BasicJWKCredential jwkCredential = new BasicJWKCredential();
            jwkCredential.setSecretKey((SecretKey)new SecretKeySpec(clientInformation.getSecret().getValueBytes(), "NONE"));
            jwkCredential.setAlgorithm((Algorithm)algorithm);
            this.log.trace("HS Credential initialized from client secret for algorithm {}", (Object)algorithm.getName());
            params.setSigningCredential((Credential)jwkCredential);
            params.setSignatureAlgorithm(algorithm.getName());
            return;
        }
        for (Credential credential : credentials) {
            if ((!JWSAlgorithm.Family.RSA.contains((Object)algorithm) || !(credential.getPrivateKey() instanceof RSAPrivateKey)) && (!JWSAlgorithm.Family.EC.contains((Object)algorithm) || !(credential.getPrivateKey() instanceof ECPrivateKey) || !this.curveMatchesESAlgorithm(Curve.forECParameterSpec((ECParameterSpec)((ECKey)((Object)credential.getPrivateKey())).getParams()), algorithm))) continue;
            this.log.trace("Credential picked for algorithm {}", (Object)algorithm.getName());
            params.setSigningCredential(credential);
            params.setSignatureAlgorithm(algorithm.getName());
            return;
        }
        if (params.getSigningCredential() == null) {
            this.log.debug("Not able to resolve signing credential based on provided client information");
            super.resolveAndPopulateCredentialAndSignatureAlgorithm(params, criteria, whitelistBlacklistPredicate);
        }
    }

    protected boolean validate(@Nonnull SignatureSigningParameters params) {
        if (params.getSigningCredential() == null) {
            this.log.debug("Validation failure: Unable to resolve signing credential");
            return false;
        }
        if (params.getSignatureAlgorithm() == null) {
            this.log.debug("Validation failure: Unable to resolve signing algorithm URI");
            return false;
        }
        return true;
    }

    public static enum ParameterType {
        IDTOKEN_SIGNING,
        USERINFO_SIGNING;

    }
}

