/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.profile.logic;

import com.nimbusds.jwt.JWTClaimsSet;
import java.time.Duration;
import java.time.Instant;
import java.util.Date;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultTokenRevocationLifetimeLookupStrategy
implements Function<JWTClaimsSet, Duration> {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(DefaultTokenRevocationLifetimeLookupStrategy.class);

    @Override
    @Nullable
    public Duration apply(@Nullable JWTClaimsSet claimsSet) {
        Instant exp;
        if (claimsSet == null) {
            this.log.error("The given claims set was null, returning null");
            return null;
        }
        Date expiration = claimsSet.getExpirationTime();
        if (expiration == null) {
            this.log.debug("No token expiration time found from the claims set, returning null");
            return null;
        }
        Instant now = Instant.now();
        if (now.isAfter(exp = expiration.toInstant())) {
            this.log.debug("Token expiration time was in the past, returning ZERO");
            return Duration.ZERO;
        }
        return Duration.between(now, exp);
    }
}

