/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.oidc.op.profile.logic;

import com.nimbusds.jwt.JWTClaimsSet;
import java.text.ParseException;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultRootTokenIdentifierLookupStrategy
implements Function<JWTClaimsSet, String> {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(DefaultRootTokenIdentifierLookupStrategy.class);

    @Override
    @Nullable
    public String apply(@Nullable JWTClaimsSet claimsSet) {
        if (claimsSet == null) {
            this.log.error("The given claims set was null, returning null");
            return null;
        }
        try {
            String rootJti = claimsSet.getStringClaim("root_jti");
            if (StringSupport.trimOrNull((String)rootJti) != null) {
                this.log.debug("Root token identifier found from the claims set");
                return rootJti;
            }
        }
        catch (ParseException e) {
            this.log.error("Could not parse the root token identifier from the claims set", (Throwable)e);
        }
        this.log.debug("Could not find root token identifier, returning null");
        return null;
    }
}

